/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.biz.crm.tpm.business.budget.local.entity.ApprovalCollectImage;
import com.biz.crm.tpm.business.budget.local.repository.ApprovalCollectImageRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.ApprovalCollectDto;
import com.biz.crm.tpm.business.budget.sdk.dto.ApprovalCollectImageDto;
import com.biz.crm.tpm.business.budget.sdk.service.ApprovalCollectImageVoService;
import com.biz.crm.tpm.business.budget.sdk.service.ApprovalCollectVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectImageVo;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ApprovalCollectImageVoServiceImpl
implements ApprovalCollectImageVoService {
    @Autowired
    private ApprovalCollectVoService approvalCollectVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ApprovalCollectImageRepository approvalCollectImageRepository;

    @Transactional
    public List<ApprovalCollectImageVo> create(ApprovalCollectDto approvalCollect, List<ApprovalCollectImageDto> images) {
        Validate.notNull((Object)approvalCollect, (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getCode(), (String)"\u6838\u9500\u91c7\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ApprovalCollectVo approvalCollectVo = this.approvalCollectVoService.findByCode(approvalCollect.getCode());
        Validate.notNull((Object)approvalCollectVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u6838\u9500\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{approvalCollect.getCode()});
        Validate.notEmpty(images, (String)"\u6838\u9500\u91c7\u96c6\u56fe\u7247\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ApprovalCollectImageDto image : images) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)image.getId()), (String)"id\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
            image.setId(null);
            Validate.notBlank((CharSequence)image.getFileCode(), (String)"\u6587\u4ef6\u552f\u4e00\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)image.getApprovalCollectCode(), (String)"\u6838\u9500\u91c7\u96c6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)image.getApprovalCollectCode(), (CharSequence)approvalCollectVo.getCode()), (String)"\u4f20\u5165\u7684\u6838\u9500\u91c7\u96c6\u7f16\u7801\u4e0e\u6838\u9500\u91c7\u96c6\u56fe\u7247\u5173\u8054\u7684\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            image.setApprovalCollectCode(approvalCollect.getCode());
            image.setCreateAccount(approvalCollectVo.getCreateAccount());
            image.setCreateName(approvalCollectVo.getCreateName());
            image.setCreateTime(approvalCollectVo.getCreateTime());
            image.setTenantCode(approvalCollectVo.getTenantCode());
        }
        Collection imageEntities = this.nebulaToolkitService.copyCollectionByWhiteList(images, ApprovalCollectImageDto.class, ApprovalCollectImage.class, HashSet.class, ArrayList.class, new String[0]);
        this.approvalCollectImageRepository.saveBatch(imageEntities);
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)imageEntities, ApprovalCollectImage.class, ApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)result);
    }

    public List<ApprovalCollectImageVo> findByApprovalCollectCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Lists.newArrayList();
        }
        List<ApprovalCollectImage> images = this.approvalCollectImageRepository.findByApprovalCollectCode(code);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(images, ApprovalCollectImage.class, ApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    @Transactional
    public void deleteByIds(Set<String> ids) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.approvalCollectImageRepository.removeByIds(ids);
    }

    public List<ApprovalCollectImageVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<ApprovalCollectImageVo>(0);
        }
        List<ApprovalCollectImage> images = this.approvalCollectImageRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(images)) {
            return Lists.newArrayList();
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList(images, ApprovalCollectImage.class, ApprovalCollectImageVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }
}

