/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.budget.local.entity.ApprovalCollect;
import com.biz.crm.tpm.business.budget.local.repository.ApprovalCollectRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.ApprovalCollectDto;
import com.biz.crm.tpm.business.budget.sdk.dto.ApprovalCollectImageDto;
import com.biz.crm.tpm.business.budget.sdk.dto.ApprovalCollectLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.enums.ApprovalCollectType;
import com.biz.crm.tpm.business.budget.sdk.event.ApprovalCollectEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.ApprovalCollectLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.ApprovalCollectImageVoService;
import com.biz.crm.tpm.business.budget.sdk.service.ApprovalCollectVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectImageVo;
import com.biz.crm.tpm.business.budget.sdk.vo.ApprovalCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="approvalCollectService")
public class ApprovalCollectServiceImpl
implements ApprovalCollectVoService {
    @Autowired
    private ApprovalCollectRepository approvalCollectRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private ApprovalCollectImageVoService approvalCollectImageService;
    @Autowired(required=false)
    private List<ApprovalCollectEventListener> approvalCollectEventListeners;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private GenerateCodeService generateCodeService;

    public Page<ApprovalCollectVo> findByConditions(Pageable pageable, ApprovalCollectDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new ApprovalCollectDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.approvalCollectRepository.findByConditions(pageable, dto);
    }

    public ApprovalCollectVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ApprovalCollect approvalCollect = (ApprovalCollect)((Object)this.approvalCollectRepository.getById((Serializable)((Object)id)));
        if (approvalCollect == null) {
            return null;
        }
        return (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<ApprovalCollectVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List approvalCollects = this.approvalCollectRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)approvalCollects)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)approvalCollects, ApprovalCollect.class, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public ApprovalCollectVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        ApprovalCollect approvalCollect = (ApprovalCollect)((Object)this.approvalCollectRepository.getById((Serializable)((Object)id)));
        if (approvalCollect == null) {
            return null;
        }
        ApprovalCollectVo result = (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
        result.setImages(imageVos);
        return result;
    }

    public ApprovalCollectVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ApprovalCollect approvalCollect = this.approvalCollectRepository.findByCode(code);
        if (approvalCollect == null) {
            return null;
        }
        return (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public ApprovalCollectVo findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ApprovalCollect approvalCollect = this.approvalCollectRepository.findByCode(code);
        if (approvalCollect == null) {
            return null;
        }
        ApprovalCollectVo result = (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
        result.setImages(imageVos);
        return result;
    }

    public List<ApprovalCollectVo> findDetailsByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<ApprovalCollect> approvalCollects = this.approvalCollectRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(approvalCollects)) {
            return Lists.newArrayList();
        }
        Collection result = this.nebulaToolkitService.copyCollectionByWhiteList(approvalCollects, ApprovalCollect.class, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        for (ApprovalCollectVo approvalCollect : result) {
            List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(approvalCollect.getCode());
            if (CollectionUtils.isEmpty((Collection)imageVos)) continue;
            approvalCollect.setImages(imageVos);
        }
        return Lists.newArrayList((Iterable)result);
    }

    @Transactional
    public ApprovalCollectVo create(ApprovalCollectDto approvalCollect) {
        this.createValidate(approvalCollect);
        approvalCollect.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (StringUtils.isBlank((CharSequence)approvalCollect.getTenantCode())) {
            approvalCollect.setTenantCode(TenantUtils.getTenantCode());
        }
        approvalCollect.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        ApprovalCollect entity = (ApprovalCollect)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)approvalCollect, ApprovalCollect.class, HashSet.class, ArrayList.class, new String[]{"images"}));
        this.approvalCollectRepository.save((Object)entity);
        if (!CollectionUtils.isEmpty((Collection)approvalCollect.getImages())) {
            this.approvalCollectImageService.create(approvalCollect, approvalCollect.getImages());
        }
        ApprovalCollectLogEventDto logEventDto = new ApprovalCollectLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(approvalCollect);
        SerializableBiConsumer & Serializable onCreate = ApprovalCollectLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ApprovalCollectLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[]{"images"});
    }

    @Transactional
    public ApprovalCollectVo update(ApprovalCollectDto approvalCollect) {
        List needAdds;
        this.updateValidate(approvalCollect);
        ApprovalCollect dbApprovalCollect = (ApprovalCollect)((Object)this.approvalCollectRepository.getById((Serializable)((Object)approvalCollect.getId())));
        ApprovalCollectDto oldDto = (ApprovalCollectDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, ApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)dbApprovalCollect), (String)"\u6839\u636e\u6307\u5b9a\u7684id\u952e\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        ApprovalCollectVo oldApprovalCollect = (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
        dbApprovalCollect.setDescr(approvalCollect.getDescr());
        dbApprovalCollect.setName(approvalCollect.getName());
        dbApprovalCollect.setSortIndex(approvalCollect.getSortIndex());
        dbApprovalCollect.setType(approvalCollect.getType());
        this.approvalCollectRepository.saveOrUpdate((Object)dbApprovalCollect);
        List imageVos = this.approvalCollectImageService.findByApprovalCollectCode(dbApprovalCollect.getCode());
        Set<Object> currentIds = Sets.newHashSet();
        Set<Object> dbIds = Sets.newHashSet();
        if (!CollectionUtils.isEmpty((Collection)approvalCollect.getImages())) {
            currentIds = approvalCollect.getImages().stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).map(UuidDto::getId).collect(Collectors.toSet());
        }
        if (!CollectionUtils.isEmpty((Collection)imageVos)) {
            dbIds = imageVos.stream().map(UuidVo::getId).collect(Collectors.toSet());
        }
        Sets.SetView needDeletes = Sets.difference((Set)dbIds, (Set)currentIds);
        List oldImages = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            oldImages = this.approvalCollectImageService.findByIds((List)Lists.newArrayList((Iterable)needDeletes));
            this.approvalCollectImageService.deleteByIds((Set)needDeletes);
        }
        if (!CollectionUtils.isEmpty(needAdds = approvalCollect.getImages().stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            this.approvalCollectImageService.create(approvalCollect, needAdds);
        }
        if (!CollectionUtils.isEmpty(this.approvalCollectEventListeners)) {
            for (ApprovalCollectEventListener listener : this.approvalCollectEventListeners) {
                ApprovalCollectVo newApprovalCollect = (ApprovalCollectVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, ApprovalCollectVo.class, HashSet.class, ArrayList.class, new String[0]);
                listener.onUpdate(oldApprovalCollect, newApprovalCollect);
            }
        }
        ApprovalCollectLogEventDto logEventDto = new ApprovalCollectLogEventDto();
        if (!CollectionUtils.isEmpty(oldImages)) {
            List approvalCollectImageDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(oldImages, ApprovalCollectImageVo.class, ApprovalCollectImageDto.class, HashSet.class, ArrayList.class, new String[0]);
            oldDto.setImages(approvalCollectImageDtos);
        }
        logEventDto.setOriginal(oldDto);
        ApprovalCollectDto newDto = (ApprovalCollectDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbApprovalCollect, ApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        newDto.setImages(needAdds);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onUpdate = ApprovalCollectLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ApprovalCollectLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return this.findDetailsByCode(approvalCollect.getCode());
    }

    @Transactional
    public void delete(Set<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ApprovalCollectVo> approvalCollectVos = this.findByIds(idList);
        Validate.notEmpty(approvalCollectVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.approvalCollectEventListeners)) {
            for (ApprovalCollectEventListener listener : this.approvalCollectEventListeners) {
                for (ApprovalCollectVo approvalCollectVo : approvalCollectVos) {
                    listener.onDeleted(approvalCollectVo);
                }
            }
        }
        this.approvalCollectRepository.delete(idList);
        Collection approvalCollectDtos = this.nebulaToolkitService.copyCollectionByWhiteList(approvalCollectVos, ApprovalCollectVo.class, ApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = ApprovalCollectLogEventListener::onDelete;
        for (ApprovalCollectDto approvalCollectDto : approvalCollectDtos) {
            ApprovalCollectLogEventDto logEventDto = new ApprovalCollectLogEventDto();
            logEventDto.setOriginal(approvalCollectDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ApprovalCollectLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional
    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)enableStatus, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<ApprovalCollectVo> approvalCollects = this.findByIds(ids);
        Validate.notEmpty(approvalCollects, (String)"\u6839\u636e\u6307\u5b9a\u7684\u4e3b\u952e\u96c6\u5408\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u6570\u636e", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001", (Object[])new Object[0]);
        this.approvalCollectRepository.updateEnableStatus(approvalCollects.stream().map(UuidVo::getId).collect(Collectors.toSet()), enableStatus);
        List approvalCollectDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(approvalCollects, ApprovalCollectVo.class, ApprovalCollectDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onUpdateEnable = ApprovalCollectLogEventListener::onUpdateEnable;
        for (ApprovalCollectDto approvalCollectDto : approvalCollectDtos) {
            ApprovalCollectLogEventDto logEventDto = new ApprovalCollectLogEventDto();
            logEventDto.setOriginal(approvalCollectDto);
            ApprovalCollectDto newDto = new ApprovalCollectDto();
            newDto.setEnableStatus(enableStatus);
            logEventDto.setNewest(newDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, ApprovalCollectLogEventListener.class, (SerializableBiConsumer)onUpdateEnable);
        }
    }

    private void createValidate(ApprovalCollectDto approvalCollect) {
        Validate.notNull((Object)approvalCollect, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)approvalCollect.getId()), (String)"\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        approvalCollect.setId(null);
        Validate.notBlank((CharSequence)approvalCollect.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getType(), (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)ApprovalCollectType.findByCode((String)approvalCollect.getType()), (String)"\u672a\u77e5\u7684\u6838\u9500\u91c7\u96c6\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)approvalCollect.getSortIndex(), (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        approvalCollect.setCode(StringUtils.upperCase((String)approvalCollect.getCode()));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)approvalCollect.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        ApprovalCollectVo dbApprovalCollect = this.findByCode(approvalCollect.getCode());
        Validate.isTrue((dbApprovalCollect == null ? 1 : 0) != 0, (String)"\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
    }

    private void updateValidate(ApprovalCollectDto approvalCollect) {
        Validate.notNull((Object)approvalCollect, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getId(), (String)"\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)approvalCollect.getType(), (String)"\u6838\u9500\u91c7\u96c6\u4fe1\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)ApprovalCollectType.findByCode((String)approvalCollect.getType()), (String)"\u672a\u77e5\u7684\u6838\u9500\u91c7\u96c6\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notNull((Object)approvalCollect.getSortIndex(), (String)"\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }
}

