/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.entity.BudgetSubjects;
import com.biz.crm.tpm.business.budget.local.repository.BudgetSubjectsRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.BudgetSubjectsDto;
import com.biz.crm.tpm.business.budget.sdk.dto.BudgetSubjectsLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.event.BudgetSubjectsEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.BudgetSubjectsLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.BudgetSubjectsVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.BudgetControlTypeStrategy;
import com.biz.crm.tpm.business.budget.sdk.vo.BudgetSubjectsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="budgetSubjectsVoService")
public class BudgetSubjectsVoServiceImpl
implements BudgetSubjectsVoService {
    @Autowired
    private BudgetSubjectsRepository budgetSubjectsRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<BudgetSubjectsEventListener> budgetSubjectsEventListeners;
    @Autowired(required=false)
    private List<BudgetControlTypeStrategy> budgetControlTypeStrategics;

    public Page<BudgetSubjectsVo> findByConditions(Pageable pageable, BudgetSubjectsDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new BudgetSubjectsDto();
        }
        List selectedCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            selectedCodeList.add(dto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            dto.setSelectedCodeList(selectedCodeList);
        }
        return this.budgetSubjectsRepository.findByConditions(pageable, dto);
    }

    public BudgetSubjectsVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BudgetSubjects budgetSubjects = (BudgetSubjects)((Object)this.budgetSubjectsRepository.getById((Serializable)((Object)id)));
        BudgetSubjectsVo budgetSubjectsVo = (BudgetSubjectsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetSubjects, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return budgetSubjectsVo;
    }

    public BudgetSubjectsVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        BudgetSubjects budgetSubjects = this.budgetSubjectsRepository.findByCode(code);
        if (budgetSubjects == null) {
            return null;
        }
        BudgetSubjectsVo budgetSubjectsVo = (BudgetSubjectsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetSubjects, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return budgetSubjectsVo;
    }

    public List<BudgetSubjectsVo> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<BudgetSubjects> budgetSubjects = this.budgetSubjectsRepository.findByCodesAndTenantCode(codes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(budgetSubjects)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(budgetSubjects, BudgetSubjects.class, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public List<BudgetSubjectsVo> findByEnableStatus(String enableStatus) {
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return Collections.emptyList();
        }
        List<BudgetSubjects> budgetSubjects = this.budgetSubjectsRepository.findByEnableStatus(enableStatus);
        if (CollectionUtils.isEmpty(budgetSubjects)) {
            return Collections.emptyList();
        }
        Collection budgetSubjectsVos = this.nebulaToolkitService.copyCollectionByWhiteList(budgetSubjects, BudgetSubjects.class, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)budgetSubjectsVos);
    }

    @Transactional
    public BudgetSubjectsVo create(BudgetSubjectsVo budgetSubjectsVo) {
        budgetSubjectsVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidate(budgetSubjectsVo);
        BudgetControlTypeStrategy budgetControlTypeStrategy = this.findBudgetControlTypeStrategyByControlTypeCode(budgetSubjectsVo.getControlTypeCode());
        Validate.notNull((Object)budgetControlTypeStrategy, (String)"\u9884\u7b97\u79d1\u76ee\u63a7\u5236\u7b56\u7565\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        budgetSubjectsVo.setControlTypeName(budgetControlTypeStrategy.getName());
        BudgetSubjects budgetSubjects = (BudgetSubjects)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetSubjectsVo, BudgetSubjects.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        budgetSubjects.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        budgetSubjects.setTenantCode(TenantUtils.getTenantCode());
        this.budgetSubjectsRepository.saveOrUpdate((Object)budgetSubjects);
        budgetSubjectsVo.setId(budgetSubjects.getId());
        if (!CollectionUtils.isEmpty(this.budgetSubjectsEventListeners)) {
            for (BudgetSubjectsEventListener budgetSubjectsEventListener : this.budgetSubjectsEventListeners) {
                budgetSubjectsEventListener.onCreated(budgetSubjectsVo);
            }
        }
        BudgetSubjectsLogEventDto logEventDto = new BudgetSubjectsLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(budgetSubjectsVo);
        SerializableBiConsumer & Serializable onCreate = BudgetSubjectsLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetSubjectsLogEventListener.class, (SerializableBiConsumer)onCreate);
        return budgetSubjectsVo;
    }

    @Transactional
    public BudgetSubjectsVo update(BudgetSubjectsVo budgetSubjectsVo) {
        this.updateValidate(budgetSubjectsVo);
        BudgetSubjects budgetSubjects = (BudgetSubjects)((Object)this.budgetSubjectsRepository.getById((Serializable)((Object)budgetSubjectsVo.getId())));
        BudgetSubjectsVo oldBudgetSubjectsVo = (BudgetSubjectsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetSubjects, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)budgetSubjects), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        budgetSubjects.setBudgetSubjectsName(budgetSubjectsVo.getBudgetSubjectsName());
        budgetSubjects.setRemark(budgetSubjectsVo.getRemark());
        budgetSubjects.setBudgetSubjectsType(budgetSubjectsVo.getBudgetSubjectsType());
        BudgetControlTypeStrategy budgetControlTypeStrategy = this.findBudgetControlTypeStrategyByControlTypeCode(budgetSubjectsVo.getControlTypeCode());
        Validate.notNull((Object)budgetControlTypeStrategy, (String)"\u9884\u7b97\u79d1\u76ee\u63a7\u5236\u7b56\u7565\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        budgetSubjects.setControlTypeCode(budgetControlTypeStrategy.getCode());
        budgetSubjects.setControlTypeName(budgetControlTypeStrategy.getName());
        budgetSubjects.setGroupCode(budgetSubjectsVo.getGroupCode());
        this.budgetSubjectsRepository.saveOrUpdate((Object)budgetSubjects);
        if (!CollectionUtils.isEmpty(this.budgetSubjectsEventListeners)) {
            for (BudgetSubjectsEventListener budgetSubjectsEventListener : this.budgetSubjectsEventListeners) {
                budgetSubjectsEventListener.onUpdate(oldBudgetSubjectsVo, budgetSubjectsVo);
            }
        }
        BudgetSubjectsVo newVo = (BudgetSubjectsVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetSubjects, BudgetSubjectsVo.class, HashSet.class, ArrayList.class, new String[0]);
        BudgetSubjectsLogEventDto logEventDto = new BudgetSubjectsLogEventDto();
        logEventDto.setOriginal(oldBudgetSubjectsVo);
        logEventDto.setNewest(newVo);
        SerializableBiConsumer & Serializable onUpdate = BudgetSubjectsLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetSubjectsLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return budgetSubjectsVo;
    }

    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BudgetSubjects> budgetSubjectss = this.budgetSubjectsRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(budgetSubjectss)) {
            return;
        }
        Collection budgetSubjectsVos = this.nebulaToolkitService.copyCollectionByWhiteList(budgetSubjectss, BudgetSubjects.class, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.budgetSubjectsRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.budgetSubjectsEventListeners)) {
            for (BudgetSubjectsEventListener budgetSubjectsEventListener : this.budgetSubjectsEventListeners) {
                for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
                    budgetSubjectsEventListener.onDeleted(budgetSubjectsVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = BudgetSubjectsLogEventListener::onDelete;
        for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
            BudgetSubjectsLogEventDto logEventDto = new BudgetSubjectsLogEventDto();
            logEventDto.setOriginal(budgetSubjectsVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetSubjectsLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<BudgetSubjects> budgetSubjectss = this.budgetSubjectsRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(budgetSubjectss)) {
            return;
        }
        Collection budgetSubjectsVos = this.nebulaToolkitService.copyCollectionByWhiteList(budgetSubjectss, BudgetSubjects.class, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.budgetSubjectsRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(this.budgetSubjectsEventListeners)) {
            for (BudgetSubjectsEventListener budgetSubjectsEventListener : this.budgetSubjectsEventListeners) {
                for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
                    budgetSubjectsEventListener.onEnable(budgetSubjectsVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onEnable = BudgetSubjectsLogEventListener::onEnable;
        for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
            BudgetSubjectsLogEventDto logEventDto = new BudgetSubjectsLogEventDto();
            logEventDto.setOriginal(budgetSubjectsVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetSubjectsLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<BudgetSubjects> budgetSubjectss = this.budgetSubjectsRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(budgetSubjectss)) {
            return;
        }
        Collection budgetSubjectsVos = this.nebulaToolkitService.copyCollectionByWhiteList(budgetSubjectss, BudgetSubjects.class, BudgetSubjectsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.budgetSubjectsRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.budgetSubjectsEventListeners)) {
            for (BudgetSubjectsEventListener budgetSubjectsEventListener : this.budgetSubjectsEventListeners) {
                for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
                    budgetSubjectsEventListener.onEnable(budgetSubjectsVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDisable = BudgetSubjectsLogEventListener::onDisable;
        for (BudgetSubjectsVo budgetSubjectsVo : budgetSubjectsVos) {
            BudgetSubjectsLogEventDto logEventDto = new BudgetSubjectsLogEventDto();
            logEventDto.setOriginal(budgetSubjectsVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetSubjectsLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(BudgetSubjectsVo budgetSubjectsVo) {
        block5: {
            String prefix = budgetSubjectsVo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(BudgetSubjectsVo budgetSubjectsVo) {
        Validate.notNull((Object)budgetSubjectsVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        budgetSubjectsVo.setId(null);
        this.validationPrefix(budgetSubjectsVo);
        Validate.notBlank((CharSequence)budgetSubjectsVo.getBudgetSubjectsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)budgetSubjectsVo.getControlTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BudgetSubjectsVo current = this.findByCode(budgetSubjectsVo.getBudgetSubjectsCode());
        Validate.isTrue((current == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u53f7\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(BudgetSubjectsVo budgetSubjectsVo) {
        Validate.notNull((Object)budgetSubjectsVo, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(budgetSubjectsVo);
        Validate.notBlank((CharSequence)budgetSubjectsVo.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)budgetSubjectsVo.getControlTypeCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u63a7\u5236\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public BudgetControlTypeStrategy findBudgetControlTypeStrategyByCode(String budgetSubjectCode) {
        if (CollectionUtils.isEmpty(this.budgetControlTypeStrategics)) {
            return null;
        }
        BudgetSubjectsVo subjectsVo = this.findByCode(budgetSubjectCode);
        if (subjectsVo == null) {
            return null;
        }
        return this.budgetControlTypeStrategics.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)subjectsVo.getControlTypeCode())).findFirst().orElse(null);
    }

    public BudgetControlTypeStrategy findBudgetControlTypeStrategyByControlTypeCode(String code) {
        if (CollectionUtils.isEmpty(this.budgetControlTypeStrategics)) {
            return null;
        }
        return this.budgetControlTypeStrategics.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)code)).findFirst().orElse(null);
    }
}

