/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.local.entity.CostBudgetItem;
import com.biz.crm.tpm.business.budget.local.repository.CostBudgetItemRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetItemDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetOperateType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetItemVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetItemVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostBudgetItemServiceImpl
implements CostBudgetItemVoService {
    @Autowired
    private CostBudgetItemRepository costBudgetItemRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostBudgetVoService costBudgetService;

    public Page<CostBudgetItemVo> findByConditions(Pageable pageable, CostBudgetItemDto dto) {
        List<CostBudgetItem> items;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new CostBudgetItemDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (CollectionUtils.isEmpty(items = this.costBudgetItemRepository.findByCostBudgetCodeAndTenantCode(dto.getCostBudgetCode(), dto.getTenantCode()))) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getOperateType())) {
            String operateType = dto.getOperateType();
            items = items.stream().filter(e -> StringUtils.equals((CharSequence)e.getOperateType(), (CharSequence)operateType)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(items)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        long totalSize = items.size();
        items = items.stream().sorted(Comparator.comparing(CostBudgetItem::getSortIndex).reversed()).skip(pageable.getPageSize() * (pageable.getPageNumber() > 0 ? pageable.getPageNumber() - 1 : 0)).limit(pageable.getPageSize()).collect(Collectors.toList());
        List<CostBudgetItemVo> itemVos = this.prefect(items);
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        result.setRecords(itemVos);
        result.setTotal(totalSize);
        return result;
    }

    @Transactional
    public List<CostBudgetItemVo> create(List<CostBudgetItemDto> costBudgetItemDtos) {
        Validate.notEmpty(costBudgetItemDtos, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CostBudgetItemDto costBudgetItemDto : costBudgetItemDtos) {
            Validate.notNull((Object)costBudgetItemDto, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)costBudgetItemDto.getId()), (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6id\u4e3b\u952e\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
            costBudgetItemDto.setId(null);
            Validate.notBlank((CharSequence)costBudgetItemDto.getCostBudgetCode(), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)costBudgetItemDto.getOperateType(), (String)"\u8d39\u7528\u9884\u7b97\u64cd\u4f5c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)costBudgetItemDto.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)costBudgetItemDto.getBusinessCode(), (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)costBudgetItemDto.getSource(), (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)costBudgetItemDto.getBalance(), (String)"\u64cd\u4f5c\u524d\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)costBudgetItemDto.getFinalBalance(), (String)"\u6700\u7ec8\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)costBudgetItemDto.getOperateAmount(), (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)costBudgetItemDto.getSource()), (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetItemDto.getSource()});
            Validate.isTrue((costBudgetItemDto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            if (!StringUtils.equals((CharSequence)costBudgetItemDto.getOperateType(), (CharSequence)CostBudgetOperateType.USED.getCode()) && !StringUtils.equals((CharSequence)costBudgetItemDto.getOperateType(), (CharSequence)CostBudgetOperateType.BACK.getCode())) continue;
            Validate.notBlank((CharSequence)costBudgetItemDto.getBusinessItemCode(), (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Collection items = this.nebulaToolkitService.copyCollectionByWhiteList(costBudgetItemDtos, CostBudgetItemDto.class, CostBudgetItem.class, HashSet.class, ArrayList.class, new String[0]);
        for (CostBudgetItem item : items) {
            int count = this.costBudgetItemRepository.countByCostBudgetCodeAndTenantCode(item.getCostBudgetCode(), TenantUtils.getTenantCode());
            item.setSortIndex(count + 1);
            this.costBudgetItemRepository.save((Object)item);
        }
        Collection collection = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)collection);
    }

    @Transactional
    public CostBudgetItemVo updateForInitializationItem(CostBudgetItemDto costBudgetItemDto) {
        Validate.notNull((Object)costBudgetItemDto, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)costBudgetItemDto.getOperateType().equals(CostBudgetOperateType.INITIALIZATION.getCode()), (String)"\u53ea\u80fd\u5bf9\u660e\u7ec6\u9879\u4e3a\u3010\u671f\u521d\u3011\u7684\u4fe1\u606f\u8fdb\u884c\u7f16\u8f91\u64cd\u4f5c", (Object[])new Object[0]);
        Validate.notNull((Object)costBudgetItemDto, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetItemDto.getId(), (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6id\u4e3b\u952e\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        Validate.notNull((Object)costBudgetItemDto.getBalance(), (String)"\u64cd\u4f5c\u524d\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudgetItemDto.getFinalBalance(), (String)"\u6700\u7ec8\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudgetItemDto.getOperateAmount(), (String)"\u5f53\u524d\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((costBudgetItemDto.getOperateAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        CostBudgetItem costBudgetItem = this.costBudgetItemRepository.findById(costBudgetItemDto.getId());
        Validate.notNull((Object)((Object)costBudgetItem), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4e3b\u952eid\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        List<CostBudgetItemVo> itemVos = this.findByCostBudgetCode(costBudgetItem.getCostBudgetCode());
        Validate.notEmpty(itemVos, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((itemVos.size() == 1 && itemVos.get(0).getOperateType().equals(CostBudgetOperateType.INITIALIZATION.getCode()) ? 1 : 0) != 0, (String)"\u8be5\u8d39\u7528\u9884\u7b97\u5df2\u4ea7\u751f\u5176\u4ed6\u975e\u3010\u671f\u521d\u3011\u4fe1\u606f\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\u64cd\u4f5c", (Object[])new Object[0]);
        costBudgetItem.setBalance(costBudgetItemDto.getBalance());
        costBudgetItem.setOperateAmount(costBudgetItemDto.getOperateAmount());
        costBudgetItem.setFinalBalance(costBudgetItemDto.getOperateAmount());
        this.costBudgetItemRepository.saveOrUpdate((Object)costBudgetItem);
        return (CostBudgetItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costBudgetItem, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<CostBudgetItemVo> findByCostBudgetCode(String costBudgetCode) {
        if (StringUtils.isBlank((CharSequence)costBudgetCode)) {
            return Lists.newArrayList();
        }
        List<CostBudgetItem> items = this.costBudgetItemRepository.findByCostBudgetCodeAndTenantCode(costBudgetCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        Collection itemVos = this.nebulaToolkitService.copyCollectionByWhiteList(items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)itemVos);
    }

    public Map<String, List<CostBudgetItemVo>> findByCostBudgetCodes(List<String> costBudgetCodes) {
        if (CollectionUtils.isEmpty(costBudgetCodes)) {
            return Maps.newHashMap();
        }
        List costBudgetVos = this.costBudgetService.findByCodes((Set)Sets.newHashSet(costBudgetCodes));
        if (CollectionUtils.isEmpty((Collection)costBudgetVos)) {
            return Maps.newHashMap();
        }
        List<CostBudgetItem> items = this.costBudgetItemRepository.findByCostBudgetCodesAndTenantCode(costBudgetCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(items)) {
            return Maps.newHashMap();
        }
        Map<String, CostBudgetVo> costBudgetMaps = costBudgetVos.stream().collect(Collectors.toMap(CostBudgetVo::getCode, e -> e));
        List<CostBudgetItemVo> vos = this.prefect(items, costBudgetMaps);
        return vos.stream().collect(Collectors.groupingBy(CostBudgetItemVo::getCostBudgetCode));
    }

    public boolean existNoInitItemByCostBudgetCode(String costBudgetCode) {
        if (StringUtils.isBlank((CharSequence)costBudgetCode)) {
            return false;
        }
        return this.costBudgetItemRepository.countNoInitItemByCostBudgetCodeAndTenantCode(costBudgetCode, TenantUtils.getTenantCode()) > 0;
    }

    public List<CostBudgetItemVo> findByBusinessCode(String businessCode) {
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return Lists.newArrayList();
        }
        List<CostBudgetItem> items = this.costBudgetItemRepository.findByBusinessCodeAndTenantCode(businessCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<CostBudgetItemVo> findByBusinessCodeAndBusinessItemCode(String businessCode, String businessItemCode) {
        if (StringUtils.isBlank((CharSequence)businessItemCode)) {
            return Lists.newArrayList();
        }
        List<CostBudgetItem> items = this.costBudgetItemRepository.findByBusinessCodeAndBusinessItemCodeAndTenantCode(businessCode, businessItemCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    private List<CostBudgetItemVo> prefect(List<CostBudgetItem> items) {
        ArrayList results = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]));
        Set custBudgetCodes = items.stream().map(CostBudgetItem::getCostBudgetCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(custBudgetCodes) || custBudgetCodes.size() != 1) {
            return results;
        }
        CostBudgetVo costBudgetVo = this.costBudgetService.findByCode(((CostBudgetItemVo)results.get(0)).getCostBudgetCode());
        if (costBudgetVo == null) {
            return results;
        }
        for (CostBudgetItemVo itemVo : results) {
            itemVo.setChannelCode(costBudgetVo.getChannelCode());
            itemVo.setChannelName(costBudgetVo.getChannelName());
            itemVo.setCode(costBudgetVo.getCode());
            itemVo.setCustomerCode(costBudgetVo.getCustomerCode());
            itemVo.setCustomerName(costBudgetVo.getCustomerName());
            itemVo.setDelFlag(costBudgetVo.getDelFlag());
            itemVo.setEnableStatus(costBudgetVo.getEnableStatus());
            itemVo.setInitialAmount(costBudgetVo.getInitialAmount());
            itemVo.setMonth(costBudgetVo.getMonth());
            itemVo.setOrgCode(costBudgetVo.getOrgCode());
            itemVo.setOrgName(costBudgetVo.getOrgName());
            itemVo.setProductCode(costBudgetVo.getProductCode());
            itemVo.setProductLevelCode(costBudgetVo.getProductLevelCode());
            itemVo.setProductLevelName(costBudgetVo.getProductLevelName());
            itemVo.setProductName(costBudgetVo.getProductName());
            itemVo.setQuarter(costBudgetVo.getQuarter());
            itemVo.setTerminalCode(costBudgetVo.getTerminalCode());
            itemVo.setTerminalName(costBudgetVo.getTerminalName());
            itemVo.setType(costBudgetVo.getType());
            itemVo.setYear(costBudgetVo.getYear());
            itemVo.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
            itemVo.setBudgetSubjectName(costBudgetVo.getBudgetSubjectName());
            itemVo.setRemark(costBudgetVo.getRemark());
        }
        return results;
    }

    private List<CostBudgetItemVo> prefect(List<CostBudgetItem> items, Map<String, CostBudgetVo> costBudgetVoMap) {
        ArrayList results = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(items, CostBudgetItem.class, CostBudgetItemVo.class, HashSet.class, ArrayList.class, new String[0]));
        for (CostBudgetItemVo itemVo : results) {
            CostBudgetVo costBudgetVo = costBudgetVoMap.get(itemVo.getCostBudgetCode());
            if (costBudgetVo == null) continue;
            itemVo.setChannelCode(costBudgetVo.getChannelCode());
            itemVo.setChannelName(costBudgetVo.getChannelName());
            itemVo.setCode(costBudgetVo.getCode());
            itemVo.setCustomerCode(costBudgetVo.getCustomerCode());
            itemVo.setCustomerName(costBudgetVo.getCustomerName());
            itemVo.setDelFlag(costBudgetVo.getDelFlag());
            itemVo.setEnableStatus(costBudgetVo.getEnableStatus());
            itemVo.setInitialAmount(costBudgetVo.getInitialAmount());
            itemVo.setMonth(costBudgetVo.getMonth());
            itemVo.setOrgCode(costBudgetVo.getOrgCode());
            itemVo.setOrgName(costBudgetVo.getOrgName());
            itemVo.setProductCode(costBudgetVo.getProductCode());
            itemVo.setProductLevelCode(costBudgetVo.getProductLevelCode());
            itemVo.setProductLevelName(costBudgetVo.getProductLevelName());
            itemVo.setProductName(costBudgetVo.getProductName());
            itemVo.setQuarter(costBudgetVo.getQuarter());
            itemVo.setTerminalCode(costBudgetVo.getTerminalCode());
            itemVo.setTerminalName(costBudgetVo.getTerminalName());
            itemVo.setType(costBudgetVo.getType());
            itemVo.setYear(costBudgetVo.getYear());
            itemVo.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
            itemVo.setBudgetSubjectName(costBudgetVo.getBudgetSubjectName());
            itemVo.setRemark(costBudgetVo.getRemark());
        }
        return results;
    }
}

