/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.local.entity.CostBudget;
import com.biz.crm.tpm.business.budget.local.repository.CostBudgetRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetItemDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeCategoryDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetOperateType;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetType;
import com.biz.crm.tpm.business.budget.sdk.event.CostBudgetEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.CostBudgetLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.BudgetSubjectsVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetItemVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.BudgetControlTypeStrategy;
import com.biz.crm.tpm.business.budget.sdk.vo.BudgetSubjectsVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetItemVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetRelationVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="costBudgetService")
public class CostBudgetServiceImpl
implements CostBudgetVoService {
    private static final String BUDGET_GLOBAL_REDIS_LOCK_KEY = "BUDGET_GLOBAL_REDIS_LOCK_KEY";
    private static final Integer MAX_TIMES = 20;
    @Autowired
    private CostBudgetRepository costBudgetRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostBudgetItemVoService costBudgetItemService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private CostTypeCategoryVoService costTypeCategoryVoService;
    @Autowired(required=false)
    private List<CostBudgetEventListener> costBudgetEventListeners;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private BudgetSubjectsVoService budgetSubjectsVoService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<CostBudgetVo> findByConditions(Pageable pageable, CostBudgetDto dto) {
        List<Object> costBudgetVos;
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new CostBudgetDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (CollectionUtils.isEmpty(costBudgetVos = this.findByConditions(dto))) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        long totalSize = costBudgetVos.size();
        costBudgetVos = costBudgetVos.stream().sorted(Comparator.comparing(CostBudgetVo::getCode).reversed()).skip(pageable.getPageSize() * (pageable.getPageNumber() > 0 ? pageable.getPageNumber() - 1 : 0)).limit(pageable.getPageSize()).collect(Collectors.toList());
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        result.setRecords(costBudgetVos);
        result.setTotal(totalSize);
        return result;
    }

    public List<CostBudgetVo> findByConditions(CostBudgetDto dto) {
        List<CostBudget> costBudgetEntities;
        if (dto == null) {
            dto = new CostBudgetDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (CollectionUtils.isEmpty(costBudgetEntities = this.costBudgetRepository.findByConditions(dto))) {
            return Lists.newArrayList();
        }
        Collection<Object> costBudgetVos = this.prefectFinalBanlances(costBudgetEntities);
        if (dto.getHasAbleBalance() != null) {
            costBudgetVos = dto.getHasAbleBalance() != false ? (Collection)costBudgetVos.stream().filter(e -> e.getFinalBalance().compareTo(BigDecimal.ZERO) > 0 || e.isDoNot()).collect(Collectors.toList()) : (Collection)costBudgetVos.stream().filter(e -> e.getFinalBalance().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        }
        return Lists.newArrayList(costBudgetVos);
    }

    public CostBudgetVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CostBudget costBudget = (CostBudget)((Object)this.costBudgetRepository.getById((Serializable)((Object)id)));
        return this.prefectFinalBanlance(costBudget);
    }

    public List<CostBudgetVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List costBudgets = this.costBudgetRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)costBudgets)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costBudgets, CostBudget.class, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    private CostBudgetVo prefectFinalBanlance(CostBudget costBudget) {
        if (costBudget == null) {
            return null;
        }
        CostBudgetVo result = (CostBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costBudget, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
        List costBudgetItems = this.costBudgetItemService.findByCostBudgetCode(costBudget.getCode());
        if (CollectionUtils.isEmpty((Collection)costBudgetItems)) {
            return result;
        }
        CostBudgetItemVo item = costBudgetItems.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
        if (item == null) {
            return result;
        }
        result.setFinalBalance(item.getFinalBalance());
        return result;
    }

    private List<CostBudgetVo> prefectFinalBanlances(List<CostBudget> costBudgets) {
        if (CollectionUtils.isEmpty(costBudgets)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        Map costBudgetItemMap = this.costBudgetItemService.findByCostBudgetCodes(costBudgets.stream().map(CostBudget::getCode).collect(Collectors.toList()));
        List budgetSubjects = this.budgetSubjectsVoService.findByCodes(costBudgets.stream().map(CostBudget::getBudgetSubjectCode).collect(Collectors.toSet()));
        if (CollectionUtils.isEmpty((Collection)budgetSubjects)) {
            return Lists.newArrayList();
        }
        Map<String, BudgetSubjectsVo> budgetSubjectsMap = budgetSubjects.stream().collect(Collectors.toMap(BudgetSubjectsVo::getBudgetSubjectsCode, e -> e));
        for (CostBudget costBudget : costBudgets) {
            CostBudgetItemVo item;
            CostBudgetVo costBudgetResult = (CostBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costBudget, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
            result.add(costBudgetResult);
            List costBudgetItemVos = (List)costBudgetItemMap.get(costBudget.getCode());
            if (CollectionUtils.isEmpty((Collection)costBudgetItemVos) || (item = (CostBudgetItemVo)costBudgetItemVos.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null)) == null) continue;
            costBudgetResult.setFinalBalance(item.getFinalBalance());
            BudgetSubjectsVo budgetSubjectsVo = budgetSubjectsMap.get(costBudgetResult.getBudgetSubjectCode());
            if (budgetSubjectsVo == null) continue;
            costBudgetResult.setDoNot(budgetSubjectsVo.getControlTypeCode().equals("DO_NOT"));
        }
        return result;
    }

    private boolean validateRepeatabilityOnCreate(CostBudgetDto costBudget) {
        Validate.notNull((Object)costBudget, (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getYear(), (String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getQuarter(), (String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getType(), (String)"\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getBudgetSubjectCode(), (String)"\u9884\u7b97\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        costBudget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<CostBudget> result = this.costBudgetRepository.findByConditions(costBudget);
        return !CollectionUtils.isEmpty(result);
    }

    private boolean validateRepeatabilityOnUpdate(CostBudgetDto costBudget, CostBudget dbCostBudget) {
        Validate.notNull((Object)costBudget, (String)"\u8d39\u7528\u9884\u7b97\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getYear(), (String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getQuarter(), (String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getType(), (String)"\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getBudgetSubjectCode(), (String)"\u9884\u7b97\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        costBudget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List<CostBudget> result = this.costBudgetRepository.findByConditions(costBudget);
        if (CollectionUtils.isEmpty(result)) {
            return false;
        }
        Validate.isTrue((boolean)dbCostBudget.getId().equals(costBudget.getId()), (String)"\u53d8\u66f4\u7684\u8d39\u7528\u9884\u7b97\u4fe1\u606f\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        return result.size() > 1;
    }

    public CostBudgetVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CostBudget costBudget = this.costBudgetRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        return this.prefectFinalBanlance(costBudget);
    }

    public List<CostBudgetVo> findByBudgetSubjectCode(String budgetSubjectCode) {
        if (StringUtils.isBlank((CharSequence)budgetSubjectCode)) {
            return Lists.newArrayList();
        }
        List<CostBudget> costBudgets = this.costBudgetRepository.findByBudgetSubjectCodeAndTenantCode(budgetSubjectCode, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(costBudgets)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(costBudgets, CostBudget.class, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public List<CostBudgetVo> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<CostBudget> costBudgets = this.costBudgetRepository.findByCodesAndTenantCode(codes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(costBudgets)) {
            return Lists.newArrayList();
        }
        ArrayList costBudgetVos = Lists.newArrayList();
        for (CostBudget costBudget : costBudgets) {
            CostBudgetVo vo = this.prefectFinalBanlance(costBudget);
            if (vo == null) continue;
            costBudgetVos.add(vo);
        }
        return costBudgetVos;
    }

    @Transactional
    public CostBudgetVo create(CostBudgetDto costBudget) {
        this.createValidate(costBudget);
        costBudget.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costBudget.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        CostBudget entity = (CostBudget)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)costBudget, CostBudget.class, HashSet.class, ArrayList.class, new String[0]));
        this.costBudgetRepository.save((Object)entity);
        CostBudgetItemDto itemDto = new CostBudgetItemDto();
        itemDto.setOperateType(CostBudgetOperateType.INITIALIZATION.getCode());
        itemDto.setBalance(BigDecimal.ZERO);
        itemDto.setCostBudgetCode(costBudget.getCode());
        itemDto.setFinalBalance(costBudget.getInitialAmount());
        itemDto.setOperateAmount(costBudget.getInitialAmount());
        itemDto.setTenantCode(costBudget.getTenantCode());
        itemDto.setItemRemark(costBudget.getOperateRemark());
        itemDto.setBusinessCode(costBudget.getCode());
        itemDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
        this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
        CostBudgetLogEventDto logEventDto = new CostBudgetLogEventDto();
        logEventDto.setOriginal(null);
        costBudget.setId(entity.getId());
        logEventDto.setNewest(costBudget);
        SerializableBiConsumer & Serializable onCreate = CostBudgetLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostBudgetLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (CostBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public CostBudgetVo update(CostBudgetDto costBudget) {
        this.updateValidate(costBudget);
        boolean hasLock = false;
        CostBudget dbCostBudget = null;
        CostBudgetDto oldDto = null;
        try {
            dbCostBudget = (CostBudget)((Object)this.costBudgetRepository.getById((Serializable)((Object)costBudget.getId())));
            Validate.notNull((Object)((Object)dbCostBudget), (String)"\u6839\u636e\u6307\u5b9a\u7684id\u952e\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
            hasLock = this.redisMutexService.tryLock(BUDGET_GLOBAL_REDIS_LOCK_KEY, TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetType costBudgetType = CostBudgetType.findByCode((String)costBudget.getType());
            Validate.notNull((Object)costBudgetType, (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudget.getType()});
            Validate.isTrue((!this.validateRepeatabilityOnUpdate(costBudget, dbCostBudget) ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u5df2\u5b58\u5728\u3010%s-%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetType.getDescr(), costBudget.getBudgetSubjectName()});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dbCostBudget.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u7f16\u8f91", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dbCostBudget.getCode(), (CharSequence)costBudget.getCode()), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            List itemVos = this.costBudgetItemService.findByCostBudgetCode(costBudget.getCode());
            Validate.notEmpty((Collection)itemVos, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            boolean matched = itemVos.stream().anyMatch(e -> !e.getOperateType().equals(CostBudgetOperateType.INITIALIZATION.getCode()));
            Validate.isTrue((!matched ? 1 : 0) != 0, (String)"\u8be5\u8d39\u7528\u9884\u7b97\u5df2\u4ea7\u751f\u660e\u7ec6\u4fe1\u606f\u6216\u4e3a\u5212\u5165\u660e\u7ec6\uff0c\u4e0d\u80fd\u8fdb\u884c\u7f16\u8f91\u64cd\u4f5c", (Object[])new Object[0]);
            CostBudgetItemVo itemVo = itemVos.stream().filter(e -> e.getOperateType().equals(CostBudgetOperateType.INITIALIZATION.getCode())).findFirst().orElse(null);
            Validate.notNull((Object)itemVo, (String)"\u8be5\u8d39\u7528\u9884\u7b97\u3010%s\u3011\u6ca1\u6709\u671f\u521d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudget.getCode()});
            oldDto = (CostBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbCostBudget, CostBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
            dbCostBudget.setChannelCode(costBudget.getChannelCode());
            dbCostBudget.setChannelName(costBudget.getChannelName());
            dbCostBudget.setCustomerCode(costBudget.getCustomerCode());
            dbCostBudget.setCustomerName(costBudget.getCustomerName());
            dbCostBudget.setBudgetSubjectCode(costBudget.getBudgetSubjectCode());
            dbCostBudget.setBudgetSubjectName(costBudget.getBudgetSubjectName());
            dbCostBudget.setMonth(costBudget.getMonth());
            dbCostBudget.setOrgCode(costBudget.getOrgCode());
            dbCostBudget.setOrgName(costBudget.getOrgName());
            dbCostBudget.setProductCode(costBudget.getProductCode());
            dbCostBudget.setProductName(costBudget.getProductName());
            dbCostBudget.setProductLevelCode(costBudget.getProductLevelCode());
            dbCostBudget.setProductLevelName(costBudget.getProductLevelName());
            dbCostBudget.setQuarter(costBudget.getQuarter());
            dbCostBudget.setTerminalCode(costBudget.getTerminalCode());
            dbCostBudget.setTerminalName(costBudget.getTerminalName());
            dbCostBudget.setType(costBudget.getType());
            dbCostBudget.setYear(costBudget.getYear());
            dbCostBudget.setRemark(costBudget.getRemark());
            dbCostBudget.setInitialAmount(costBudget.getInitialAmount());
            this.costBudgetRepository.saveOrUpdate((Object)dbCostBudget);
            CostBudgetItemDto itemDto = new CostBudgetItemDto();
            itemDto.setId(itemVo.getId());
            itemDto.setBalance(BigDecimal.ZERO);
            itemDto.setOperateAmount(dbCostBudget.getInitialAmount());
            itemDto.setFinalBalance(dbCostBudget.getInitialAmount());
            itemDto.setOperateType(CostBudgetOperateType.INITIALIZATION.getCode());
            this.costBudgetItemService.updateForInitializationItem(itemDto);
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(BUDGET_GLOBAL_REDIS_LOCK_KEY);
            }
        }
        CostBudgetVo result = (CostBudgetVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbCostBudget, CostBudgetVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(this.costBudgetEventListeners)) {
            for (CostBudgetEventListener listener : this.costBudgetEventListeners) {
                listener.onUpdate(result);
            }
        }
        CostBudgetLogEventDto logEventDto = new CostBudgetLogEventDto();
        logEventDto.setOriginal(oldDto);
        CostBudgetDto newDto = (CostBudgetDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbCostBudget, CostBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer & Serializable onUpdate = CostBudgetLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostBudgetLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return result;
    }

    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CostBudgetVo> costBudgetVos = this.findByIds(Sets.newHashSet(idList));
        Validate.notEmpty(costBudgetVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684ids\u4e3b\u952e\u96c6\u5408\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        for (CostBudgetVo vo : costBudgetVos) {
            boolean exist = this.costBudgetItemService.existNoInitItemByCostBudgetCode(vo.getCode());
            Validate.isTrue((!exist ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u3010%s\u3011\u5b58\u5728\u3010\u975e\u671f\u521d\u3011\u660e\u7ec6\u9879\uff0c\u4e0d\u80fd\u8fdb\u884c\u5220\u9664\u64cd\u4f5c", (Object[])new Object[]{vo.getCode()});
        }
        if (!CollectionUtils.isEmpty(this.costBudgetEventListeners)) {
            for (CostBudgetVo vo : costBudgetVos) {
                for (CostBudgetEventListener listener : this.costBudgetEventListeners) {
                    listener.onDeleted(vo);
                }
            }
        }
        this.costBudgetRepository.deleteByIds(idList);
        List costBudgets = (List)this.nebulaToolkitService.copyCollectionByWhiteList(costBudgetVos, CostBudgetVo.class, CostBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onDelete = CostBudgetLogEventListener::onDelete;
        for (CostBudgetDto costBudget : costBudgets) {
            CostBudgetLogEventDto logEventDto = new CostBudgetLogEventDto();
            logEventDto.setOriginal(costBudget);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostBudgetLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    private void createValidate(CostBudgetDto costBudget) {
        Validate.notNull((Object)costBudget, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)costBudget.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        costBudget.setId(null);
        if (StringUtils.isBlank((CharSequence)costBudget.getTenantCode())) {
            costBudget.setTenantCode(TenantUtils.getTenantCode());
        }
        this.validateBase(costBudget);
        this.validateQuarterAndMonth(costBudget);
        this.validateCostBudgetType(costBudget);
        this.validateProductInfo(costBudget);
        CostBudgetType costBudgetType = CostBudgetType.findByCode((String)costBudget.getType());
        Validate.notNull((Object)costBudgetType, (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudget.getType()});
        Validate.isTrue((!this.validateRepeatabilityOnCreate(costBudget) ? 1 : 0) != 0, (String)"\u8be5\u8d39\u7528\u9884\u7b97\u5df2\u5b58\u5728\u3010%s-%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetType.getDescr(), costBudget.getBudgetSubjectName()});
        String ruleCode = StringUtils.join((Object[])new String[]{"SRYS", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.notEmpty((Collection)codeList, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u8d39\u7528\u9884\u7b97\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        costBudget.setCode((String)codeList.get(0));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)costBudget.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        CostBudgetVo costBudgetVo = this.findByCode(costBudget.getCode());
        Validate.isTrue((costBudgetVo == null ? 1 : 0) != 0, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
    }

    private void updateValidate(CostBudgetDto costBudget) {
        Validate.notNull((Object)costBudget, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getCode(), (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validateBase(costBudget);
        this.validateQuarterAndMonth(costBudget);
        this.validateCostBudgetType(costBudget);
        this.validateProductInfo(costBudget);
        if (StringUtils.isBlank((CharSequence)costBudget.getTenantCode())) {
            costBudget.setTenantCode(TenantUtils.getTenantCode());
        }
    }

    private void validateBase(CostBudgetDto costBudget) {
        Validate.notBlank((CharSequence)costBudget.getType(), (String)"\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getYear(), (String)"\u5e74\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getQuarter(), (String)"\u5b63\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getMonth(), (String)"\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)costBudget.getInitialAmount(), (String)"\u671f\u521d\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((costBudget.getInitialAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u671f\u521d\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getBudgetSubjectCode(), (String)"\u9884\u7b97\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudget.getBudgetSubjectName(), (String)"\u9884\u7b97\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void validateQuarterAndMonth(CostBudgetDto costBudget) {
        switch (costBudget.getQuarter()) {
            case 1: {
                Validate.isTrue((costBudget.getMonth() >= 1 && costBudget.getMonth() <= 3 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4e8e\u6708\u4efd\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[0]);
                break;
            }
            case 2: {
                Validate.isTrue((costBudget.getMonth() >= 4 && costBudget.getMonth() <= 6 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4e8e\u6708\u4efd\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[0]);
                break;
            }
            case 3: {
                Validate.isTrue((costBudget.getMonth() >= 7 && costBudget.getMonth() <= 9 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4e8e\u6708\u4efd\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[0]);
                break;
            }
            case 4: {
                Validate.isTrue((costBudget.getMonth() >= 10 && costBudget.getMonth() <= 12 ? 1 : 0) != 0, (String)"\u5b63\u5ea6\u4e8e\u6708\u4efd\u4fe1\u606f\u4e0d\u5339\u914d", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u5b63\u5ea6\u53d6\u503c\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }

    private void validateProductInfo(CostBudgetDto costBudget) {
        boolean productFlag = StringUtils.isNotBlank((CharSequence)costBudget.getProductCode()) || StringUtils.isNotBlank((CharSequence)costBudget.getProductName());
        boolean productLevelFlag = StringUtils.isNotBlank((CharSequence)costBudget.getProductLevelCode()) || StringUtils.isNotBlank((CharSequence)costBudget.getProductLevelName());
        Validate.isTrue((!productFlag || !productLevelFlag ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u4fe1\u606f\u4e92\u65a5\uff0c\u4e0d\u80fd\u540c\u65f6\u6709\u503c", (Object[])new Object[0]);
        if (productFlag) {
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)costBudget.getProductCode()) && StringUtils.isNotBlank((CharSequence)costBudget.getProductName()) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (productLevelFlag) {
            Validate.isTrue((StringUtils.isNotBlank((CharSequence)costBudget.getProductLevelCode()) && StringUtils.isNotBlank((CharSequence)costBudget.getProductLevelName()) ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
    }

    private void validateCostBudgetType(CostBudgetDto costBudget) {
        CostBudgetType costBudgetType = CostBudgetType.findByCode((String)costBudget.getType());
        Validate.notNull((Object)costBudgetType, (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudget.getType()});
        switch (costBudgetType) {
            case ORG_BUDGET: {
                Validate.notBlank((CharSequence)costBudget.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            case CUSTOMER_BUDGET: {
                Validate.notBlank((CharSequence)costBudget.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            case CHANNEL_BUDGET: {
                Validate.notBlank((CharSequence)costBudget.getChannelCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getChannelName(), (String)"\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
            case TERMINAL_BUDGET: {
                Validate.notBlank((CharSequence)costBudget.getTerminalCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getTerminalName(), (String)"\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)costBudget.getCustomerName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                break;
            }
        }
    }

    @Transactional
    public void updateEnableStatus(Set<String> ids, String enableStatus) {
        Validate.notEmpty(ids, (String)"\u4e3b\u952eid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)enableStatus, (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{enableStatus});
        List<CostBudgetVo> costBudgetVos = this.findByIds(ids);
        Validate.notEmpty(costBudgetVos, (String)"\u6839\u636e\u63d0\u4f9b\u7684ids\u4e3b\u952e\u96c6\u5408\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.costBudgetEventListeners)) {
            for (CostBudgetVo vo : costBudgetVos) {
                for (CostBudgetEventListener listener : this.costBudgetEventListeners) {
                    if (StringUtils.equals((CharSequence)enableStatus, (CharSequence)EnableStatusEnum.DISABLE.getCode())) {
                        listener.onDisable(vo);
                        continue;
                    }
                    listener.onEnable(vo);
                }
            }
        }
        this.costBudgetRepository.updateEnableStatus(ids, enableStatus);
        List costBudgets = (List)this.nebulaToolkitService.copyCollectionByWhiteList(costBudgetVos, CostBudgetVo.class, CostBudgetDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable onUpdateEnable = CostBudgetLogEventListener::onUpdateEnable;
        for (CostBudgetDto costBudget : costBudgets) {
            CostBudgetLogEventDto logEventDto = new CostBudgetLogEventDto();
            logEventDto.setOriginal(costBudget);
            CostBudgetDto newDto = new CostBudgetDto();
            newDto.setEnableStatus(enableStatus);
            logEventDto.setNewest(newDto);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostBudgetLogEventListener.class, (SerializableBiConsumer)onUpdateEnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void tranfer(String costBudgetCodeOut, String costBudgetCodeIn, BigDecimal operateAmount, String operateRemark) {
        Validate.notBlank((CharSequence)costBudgetCodeOut, (String)"\u8c03\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCodeIn, (String)"\u8c03\u5165\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)costBudgetCodeIn, (CharSequence)costBudgetCodeOut) ? 1 : 0) != 0, (String)"\u8c03\u5165\u8c03\u51fa\u65b9\u4e0d\u80fd\u76f8\u540c", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock(BUDGET_GLOBAL_REDIS_LOCK_KEY, TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo out = this.findByCode(costBudgetCodeOut);
            Validate.notNull((Object)out, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCodeOut});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)out.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            CostBudgetVo in = this.findByCode(costBudgetCodeIn);
            Validate.notNull((Object)in, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCodeIn});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)in.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            List costBudgetItemOuts = this.costBudgetItemService.findByCostBudgetCode(costBudgetCodeOut);
            Validate.notEmpty((Collection)costBudgetItemOuts, (String)"\u8c03\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CostBudgetItemVo itemOut = costBudgetItemOuts.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)itemOut, (String)"\u8c03\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((itemOut.getFinalBalance().compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u8c03\u51fa\u65b9\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            CostBudgetItemDto itemOutDto = new CostBudgetItemDto();
            itemOutDto.setOperateType(CostBudgetOperateType.TRANSFER_OUT.getCode());
            itemOutDto.setBalance(itemOut.getFinalBalance());
            itemOutDto.setCostBudgetCode(costBudgetCodeOut);
            itemOutDto.setFinalBalance(itemOut.getFinalBalance().subtract(operateAmount));
            itemOutDto.setOperateAmount(operateAmount);
            itemOutDto.setTenantCode(out.getTenantCode());
            itemOutDto.setItemRemark(operateRemark);
            itemOutDto.setBusinessCode(costBudgetCodeIn);
            itemOutDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
            this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemOutDto}));
            List costBudgetItemIns = this.costBudgetItemService.findByCostBudgetCode(costBudgetCodeIn);
            Validate.notEmpty((Collection)costBudgetItemIns, (String)"\u8c03\u5165\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CostBudgetItemVo itemIn = costBudgetItemIns.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)itemIn, (String)"\u8c03\u5165\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CostBudgetItemDto itemInDto = new CostBudgetItemDto();
            itemInDto.setOperateType(CostBudgetOperateType.TRANSFER_IN.getCode());
            itemInDto.setBalance(itemIn.getFinalBalance());
            itemInDto.setCostBudgetCode(costBudgetCodeIn);
            itemInDto.setFinalBalance(itemIn.getFinalBalance().add(operateAmount));
            itemInDto.setOperateAmount(operateAmount);
            itemInDto.setTenantCode(in.getTenantCode());
            itemInDto.setBusinessCode(costBudgetCodeOut);
            itemInDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
            this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemInDto}));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(BUDGET_GLOBAL_REDIS_LOCK_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void change(String costBudgetCode, BigDecimal operateAmount, String operateRemark, String operateType) {
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)operateType, (String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        CostBudgetOperateType operateTypeEnum = CostBudgetOperateType.findByCode((String)operateType);
        Validate.notNull((Object)operateTypeEnum, (String)"\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{operateType});
        switch (operateTypeEnum) {
            case APPEND: {
                break;
            }
            case REDUCE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b\u3010" + operateType + "\u3011\uff0c\u8bf7\u68c0\u67e5");
            }
        }
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock(BUDGET_GLOBAL_REDIS_LOCK_KEY, TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo change = this.findByCode(costBudgetCode);
            Validate.notNull((Object)change, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)change.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            List costBudgetItems = this.costBudgetItemService.findByCostBudgetCode(costBudgetCode);
            Validate.notEmpty((Collection)costBudgetItems, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CostBudgetItemVo item = costBudgetItems.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)item, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (operateTypeEnum == CostBudgetOperateType.REDUCE) {
                Validate.isTrue((item.getFinalBalance().compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            CostBudgetItemDto itemDto = new CostBudgetItemDto();
            itemDto.setOperateType(operateType);
            itemDto.setBalance(item.getFinalBalance());
            itemDto.setCostBudgetCode(costBudgetCode);
            if (operateTypeEnum == CostBudgetOperateType.REDUCE) {
                itemDto.setFinalBalance(item.getFinalBalance().subtract(operateAmount));
            } else {
                itemDto.setFinalBalance(item.getFinalBalance().add(operateAmount));
            }
            itemDto.setOperateAmount(operateAmount);
            itemDto.setTenantCode(item.getTenantCode());
            itemDto.setItemRemark(operateRemark);
            itemDto.setBusinessCode(costBudgetCode);
            itemDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
            this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(BUDGET_GLOBAL_REDIS_LOCK_KEY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void wipe(String costBudgetCodeOut, List<CostBudgetDto> costBudgetIns) {
        Validate.notBlank((CharSequence)costBudgetCodeOut, (String)"\u5212\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(costBudgetIns, (String)"\u5212\u5165\u65b9\u8d39\u7528\u9884\u7b97\u4fe1\u606f\u96c6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock(BUDGET_GLOBAL_REDIS_LOCK_KEY, TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo costBudgetVo = this.findByCode(costBudgetCodeOut);
            Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCodeOut});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            this.validateTargetWipeIn(costBudgetIns);
            List itemVos = this.costBudgetItemService.findByCostBudgetCode(costBudgetCodeOut);
            Validate.notEmpty((Collection)itemVos, (String)"\u5212\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            CostBudgetItemVo itemOut = itemVos.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)itemOut, (String)"\u5212\u51fa\u65b9\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            BigDecimal balance = itemOut.getFinalBalance();
            BigDecimal totalOperateAmount = BigDecimal.ZERO;
            for (CostBudgetDto dto : costBudgetIns) {
                dto.setInitialAmount(dto.getOperateAmount());
                totalOperateAmount = totalOperateAmount.add(dto.getInitialAmount());
                this.createValidate(dto);
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                CostBudget entity = (CostBudget)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CostBudget.class, HashSet.class, ArrayList.class, new String[0]));
                this.costBudgetRepository.save((Object)entity);
                CostBudgetItemDto itemDto = new CostBudgetItemDto();
                itemDto.setOperateType(CostBudgetOperateType.WIPE_IN.getCode());
                itemDto.setBalance(BigDecimal.ZERO);
                itemDto.setCostBudgetCode(dto.getCode());
                itemDto.setFinalBalance(dto.getInitialAmount());
                itemDto.setOperateAmount(dto.getInitialAmount());
                itemDto.setTenantCode(dto.getTenantCode());
                itemDto.setItemRemark(dto.getOperateRemark());
                itemDto.setBusinessCode(costBudgetCodeOut);
                itemDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
                this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
                CostBudgetItemDto itemOutDto = new CostBudgetItemDto();
                itemOutDto.setOperateType(CostBudgetOperateType.WIPE_OUT.getCode());
                itemOutDto.setBalance(balance);
                itemOutDto.setCostBudgetCode(costBudgetCodeOut);
                Validate.isTrue((balance.compareTo(dto.getInitialAmount()) >= 0 ? 1 : 0) != 0, (String)"\u5212\u51fa\u65b9\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                itemOutDto.setFinalBalance(balance.subtract(dto.getInitialAmount()));
                itemOutDto.setOperateAmount(dto.getInitialAmount());
                itemOutDto.setTenantCode(costBudgetVo.getTenantCode());
                itemOutDto.setBusinessCode(itemDto.getCostBudgetCode());
                itemOutDto.setSource(CostBudgetItemSourceType.COSTBUDGET.getDescr());
                this.costBudgetItemService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemOutDto}));
                balance = balance.subtract(dto.getInitialAmount());
            }
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock(BUDGET_GLOBAL_REDIS_LOCK_KEY);
            }
        }
    }

    @Transactional
    public void occupy(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        CostBudgetVo costBudgetVo = this.findByCode(costBudgetCode);
        Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
        BudgetControlTypeStrategy controlTypeStrategy = this.budgetSubjectsVoService.findBudgetControlTypeStrategyByCode(costBudgetVo.getBudgetSubjectCode());
        Validate.notNull((Object)controlTypeStrategy, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u79d1\u76ee\u9884\u7b97\u3010%s\u3011\u63a7\u5236\u7c7b\u578b\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetVo.getBudgetSubjectCode()});
        controlTypeStrategy.forward(businessCode, businessItemCode, costBudgetCode, operateAmount, itemRemark, source);
    }

    @Transactional
    public void back(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        CostBudgetVo costBudgetVo = this.findByCode(costBudgetCode);
        Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
        BudgetControlTypeStrategy controlTypeStrategy = this.budgetSubjectsVoService.findBudgetControlTypeStrategyByCode(costBudgetVo.getBudgetSubjectCode());
        Validate.notNull((Object)controlTypeStrategy, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u79d1\u76ee\u9884\u7b97\u3010%s\u3011\u63a7\u5236\u7c7b\u578b\u7b56\u7565\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetVo.getBudgetSubjectCode()});
        controlTypeStrategy.reverse(businessCode, businessItemCode, costBudgetCode, operateAmount, itemRemark, source);
    }

    private void validateTargetWipeIn(List<CostBudgetDto> costBudgetIns) {
        long size = costBudgetIns.stream().map(e -> StringUtils.joinWith((String)":", (Object[])new Object[]{StringUtils.isNotBlank((CharSequence)e.getOrgCode()) ? e.getOrgCode() : "", StringUtils.isNotBlank((CharSequence)e.getCustomerCode()) ? e.getCustomerCode() : "", StringUtils.isNotBlank((CharSequence)e.getTerminalCode()) ? e.getTerminalCode() : "", StringUtils.isNotBlank((CharSequence)e.getChannelCode()) ? e.getChannelCode() : ""})).distinct().count();
        Validate.isTrue((size == (long)costBudgetIns.size() ? 1 : 0) != 0, (String)"\u5212\u62e8\u5bf9\u8c61\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (Object[])new Object[0]);
    }

    public Set<CostBudgetRelationVo> findRelationByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptySet();
        }
        List<CostBudget> costBudgets = this.costBudgetRepository.findByCodesAndTenantCode(codes, TenantUtils.getTenantCode());
        HashSet costBudgetRelationVos = Sets.newHashSet();
        for (CostBudget costBudget : costBudgets) {
            CostTypeCategoryDto costTypeCategoryDto = new CostTypeCategoryDto();
            costTypeCategoryDto.setSelect(true);
            costTypeCategoryDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            costTypeCategoryDto.setBudgetSubjectsName(costBudget.getBudgetSubjectName());
            Page costTypeCategoryVoPage = this.costTypeCategoryVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE), costTypeCategoryDto);
            if (costTypeCategoryVoPage.getSize() <= 0L) continue;
            for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVoPage.getRecords()) {
                CostBudgetRelationVo costBudgetRelationVo = new CostBudgetRelationVo();
                costBudgetRelationVo.setCostBudgetCode(costBudget.getCode());
                costBudgetRelationVo.setBudgetSubjectsCode(costBudget.getBudgetSubjectCode());
                costBudgetRelationVo.setBudgetSubjectsName(costBudget.getBudgetSubjectName());
                costBudgetRelationVo.setCategoryCode(costTypeCategoryVo.getCategoryCode());
                costBudgetRelationVo.setCategoryName(costTypeCategoryVo.getCategoryName());
                costBudgetRelationVo.setUniqueKey(StringUtils.joinWith((String)":", (Object[])new Object[]{costBudgetRelationVo.getCostBudgetCode(), costBudgetRelationVo.getCategoryCode(), costBudgetRelationVo.getBudgetSubjectsCode()}));
                costBudgetRelationVos.add(costBudgetRelationVo);
            }
        }
        return costBudgetRelationVos;
    }
}

