/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.user.feign.feign.UserVoFeign;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeCategory;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeCategoryRange;
import com.biz.crm.tpm.business.budget.local.repository.CostTypeCategoryRepository;
import com.biz.crm.tpm.business.budget.local.service.CostTypeCategoryRangeService;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeCategoryDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeCategoryLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.event.CostTypeCategoryEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.CostTypeCategoryLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.BudgetSubjectsVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeCategoryVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.BudgetSubjectsVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryRangeVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeCategoryVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="costTypeCategoryVoService")
public class CostTypeCategoryVoServiceImpl
implements CostTypeCategoryVoService {
    @Autowired
    private CostTypeCategoryRepository costTypeCategoryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private BudgetSubjectsVoService budgetSubjectsVoService;
    @Autowired
    private CostTypeCategoryRangeService costTypeCategoryRangeService;
    @Autowired(required=false)
    private List<CostTypeCategoryEventListener> costTypeCategoryEventListeners;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private UserVoFeign userVoFeign;

    public Page<CostTypeCategoryVo> findByConditions(Pageable pageable, CostTypeCategoryDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CostTypeCategoryDto();
        }
        List selectedCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            selectedCodeList.add(dto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            dto.setSelectedCodeList(selectedCodeList);
        }
        if (dto.isSelect()) {
            Set<CostTypeCategoryRange> schemeRangeVos = this.costTypeCategoryRangeService.findAll();
            List schemeOrgCodes = schemeRangeVos.stream().filter(item -> item.getRangeType() == 1).map(CostTypeCategoryRange::getRangeCode).distinct().collect(Collectors.toList());
            List schemeOrgTypes = schemeRangeVos.stream().filter(item -> item.getRangeType() == 2).map(CostTypeCategoryRange::getRangeCode).distinct().collect(Collectors.toList());
            UserIdentity loginDetails = this.loginUserService.getLoginUser();
            Result userVoOrgCodeResult = this.userVoFeign.findRelationByUserNameAndOrgCodesOrOrgTypes(loginDetails.getAccount(), schemeOrgCodes, schemeOrgTypes);
            UserVo userVo = (UserVo)userVoOrgCodeResult.getResult();
            if (userVo != null) {
                dto.setOrgCodes(userVo.getRelationOrgCodes());
                dto.setOrgTypes(userVo.getRelationOrgTypes());
            }
        }
        return this.costTypeCategoryRepository.findByConditions(pageable, dto);
    }

    public CostTypeCategoryVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CostTypeCategory costTypeCategory = (CostTypeCategory)((Object)this.costTypeCategoryRepository.getById((Serializable)((Object)id)));
        if (costTypeCategory == null) {
            return null;
        }
        CostTypeCategoryVo costTypeCategoryVo = (CostTypeCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeCategory, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<CostTypeCategoryRangeVo> costTypeCategoryRangeVos = this.costTypeCategoryRangeService.findByCategoryCode(costTypeCategory.getCategoryCode());
        costTypeCategoryVo.setCostTypeCategoryRanges((Set)Sets.newLinkedHashSet(costTypeCategoryRangeVos));
        return costTypeCategoryVo;
    }

    public CostTypeCategoryVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CostTypeCategory costTypeCategory = this.costTypeCategoryRepository.findByCode(code);
        if (costTypeCategory == null) {
            return null;
        }
        CostTypeCategoryVo costTypeCategoryVo = (CostTypeCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeCategory, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<CostTypeCategoryRangeVo> costTypeCategoryRangeVos = this.costTypeCategoryRangeService.findByCategoryCode(costTypeCategory.getCategoryCode());
        costTypeCategoryVo.setCostTypeCategoryRanges((Set)Sets.newLinkedHashSet(costTypeCategoryRangeVos));
        return costTypeCategoryVo;
    }

    @Transactional
    public CostTypeCategoryVo create(CostTypeCategoryVo costTypeCategoryVo) {
        costTypeCategoryVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidate(costTypeCategoryVo);
        BudgetSubjectsVo budgetSubjectsVo = this.budgetSubjectsVoService.findByCode(costTypeCategoryVo.getBudgetSubjectsCode());
        costTypeCategoryVo.setBudgetSubjectsName(budgetSubjectsVo.getBudgetSubjectsName());
        CostTypeCategory costTypeCategory = (CostTypeCategory)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeCategoryVo, CostTypeCategory.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        costTypeCategory.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costTypeCategory.setTenantCode(TenantUtils.getTenantCode());
        this.costTypeCategoryRepository.saveOrUpdate((Object)costTypeCategory);
        Collection costTypeCategoryRanges = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costTypeCategoryVo.getCostTypeCategoryRanges(), CostTypeCategoryRangeVo.class, CostTypeCategoryRange.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        costTypeCategoryRanges.forEach(item -> {
            item.setId(null);
            item.setCategoryCode(costTypeCategory.getCategoryCode());
            item.setCategoryName(costTypeCategory.getCategoryName());
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.costTypeCategoryRangeService.saveBatch(costTypeCategoryRanges);
        costTypeCategoryVo.setId(costTypeCategory.getId());
        if (!CollectionUtils.isEmpty(this.costTypeCategoryEventListeners)) {
            for (CostTypeCategoryEventListener costTypeCategoryEventListener : this.costTypeCategoryEventListeners) {
                costTypeCategoryEventListener.onCreated(costTypeCategoryVo);
            }
        }
        CostTypeCategoryLogEventDto logEventDto = new CostTypeCategoryLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(costTypeCategoryVo);
        SerializableBiConsumer & Serializable onCreate = CostTypeCategoryLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeCategoryLogEventListener.class, (SerializableBiConsumer)onCreate);
        return costTypeCategoryVo;
    }

    @Transactional
    public CostTypeCategoryVo update(CostTypeCategoryVo costTypeCategoryVo) {
        this.updateValidate(costTypeCategoryVo);
        CostTypeCategory costTypeCategory = (CostTypeCategory)((Object)this.costTypeCategoryRepository.getById((Serializable)((Object)costTypeCategoryVo.getId())));
        CostTypeCategoryVo oldCostTypeCategoryVo = (CostTypeCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeCategory, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)costTypeCategory), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        costTypeCategory.setCategoryName(costTypeCategoryVo.getCategoryName());
        costTypeCategory.setBusinessExpensesType(costTypeCategoryVo.getBusinessExpensesType());
        costTypeCategory.setFinancialExpensesType(costTypeCategoryVo.getFinancialExpensesType());
        costTypeCategory.setBudgetSubjectsCode(costTypeCategoryVo.getBudgetSubjectsCode());
        BudgetSubjectsVo budgetSubjectsVo = this.budgetSubjectsVoService.findByCode(costTypeCategoryVo.getBudgetSubjectsCode());
        costTypeCategory.setBudgetSubjectsName(budgetSubjectsVo.getBudgetSubjectsName());
        costTypeCategory.setFormCode(costTypeCategoryVo.getFormCode());
        costTypeCategory.setFormName(costTypeCategoryVo.getFormName());
        costTypeCategory.setRemark(costTypeCategoryVo.getRemark());
        this.costTypeCategoryRepository.saveOrUpdate((Object)costTypeCategory);
        List<CostTypeCategoryRangeVo> byCategoryCode = this.costTypeCategoryRangeService.findByCategoryCode(costTypeCategory.getCategoryCode());
        oldCostTypeCategoryVo.setCostTypeCategoryRanges((Set)Sets.newLinkedHashSet(byCategoryCode));
        Collection costTypeCategoryRanges = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costTypeCategoryVo.getCostTypeCategoryRanges(), CostTypeCategoryRangeVo.class, CostTypeCategoryRange.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        costTypeCategoryRanges.forEach(item -> {
            item.setId(null);
            item.setCategoryCode(costTypeCategory.getCategoryCode());
            item.setCategoryName(costTypeCategory.getCategoryName());
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        });
        this.costTypeCategoryRangeService.deleteByCategoryCode(costTypeCategory.getCategoryCode());
        this.costTypeCategoryRangeService.saveBatch(costTypeCategoryRanges);
        if (!CollectionUtils.isEmpty(this.costTypeCategoryEventListeners)) {
            for (CostTypeCategoryEventListener costTypeCategoryEventListener : this.costTypeCategoryEventListeners) {
                costTypeCategoryEventListener.onUpdate(oldCostTypeCategoryVo, costTypeCategoryVo);
            }
        }
        CostTypeCategoryVo newVo = (CostTypeCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeCategory, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        newVo.setCostTypeCategoryRanges(costTypeCategoryVo.getCostTypeCategoryRanges());
        CostTypeCategoryLogEventDto logEventDto = new CostTypeCategoryLogEventDto();
        logEventDto.setOriginal(oldCostTypeCategoryVo);
        logEventDto.setNewest(costTypeCategoryVo);
        SerializableBiConsumer & Serializable onUpdate = CostTypeCategoryLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeCategoryLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return costTypeCategoryVo;
    }

    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CostTypeCategory> costTypeCategorys = this.costTypeCategoryRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeCategorys)) {
            return;
        }
        Collection costTypeCategoryVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategorys, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeCategoryRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.costTypeCategoryEventListeners)) {
            for (CostTypeCategoryEventListener costTypeCategoryEventListener : this.costTypeCategoryEventListeners) {
                for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
                    costTypeCategoryEventListener.onDeleted(costTypeCategoryVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = CostTypeCategoryLogEventListener::onDelete;
        for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
            CostTypeCategoryLogEventDto logEventDto = new CostTypeCategoryLogEventDto();
            logEventDto.setOriginal(costTypeCategoryVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeCategoryLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public List<CostTypeCategoryVo> findByEnableStatus(String enableStatus) {
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return Collections.emptyList();
        }
        List<CostTypeCategory> costTypeCategory = this.costTypeCategoryRepository.findByEnableStatus(enableStatus);
        if (CollectionUtils.isEmpty(costTypeCategory)) {
            return Collections.emptyList();
        }
        Collection costTypeCategorys = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategory, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)costTypeCategorys);
    }

    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CostTypeCategory> costTypeCategorys = this.costTypeCategoryRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeCategorys)) {
            return;
        }
        Collection costTypeCategoryVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategorys, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeCategoryRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(this.costTypeCategoryEventListeners)) {
            for (CostTypeCategoryEventListener costTypeCategoryEventListener : this.costTypeCategoryEventListeners) {
                for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
                    costTypeCategoryEventListener.onEnable(costTypeCategoryVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onEnable = CostTypeCategoryLogEventListener::onEnable;
        for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
            CostTypeCategoryLogEventDto logEventDto = new CostTypeCategoryLogEventDto();
            logEventDto.setOriginal(costTypeCategoryVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeCategoryLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CostTypeCategory> costTypeCategories = this.costTypeCategoryRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeCategories)) {
            return;
        }
        Collection costTypeCategoryVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategories, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeCategoryRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.costTypeCategoryEventListeners)) {
            for (CostTypeCategoryEventListener costTypeCategoryEventListener : this.costTypeCategoryEventListeners) {
                for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
                    costTypeCategoryEventListener.onEnable(costTypeCategoryVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDisable = CostTypeCategoryLogEventListener::onDisable;
        for (CostTypeCategoryVo costTypeCategoryVo : costTypeCategoryVos) {
            CostTypeCategoryLogEventDto logEventDto = new CostTypeCategoryLogEventDto();
            logEventDto.setOriginal(costTypeCategoryVo);
            logEventDto.setNewest(null);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeCategoryLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    public List<CostTypeCategoryVo> findByBudgetSubjectsCode(String budgetSubjectsCode) {
        if (StringUtils.isBlank((CharSequence)budgetSubjectsCode)) {
            return Collections.emptyList();
        }
        List<CostTypeCategory> costTypeCategories = this.costTypeCategoryRepository.findByBudgetSubjectsCode(budgetSubjectsCode);
        Collection costTypeCategoryVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategories, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)costTypeCategoryVos);
    }

    public List<CostTypeCategoryVo> findByBudgetSubjectsCodes(List<String> budgetSubjectsCodes) {
        if (CollectionUtils.isEmpty(budgetSubjectsCodes)) {
            return Collections.emptyList();
        }
        List<CostTypeCategory> costTypeCategories = this.costTypeCategoryRepository.findByBudgetSubjectsCodes(budgetSubjectsCodes);
        Collection costTypeCategoryVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeCategories, CostTypeCategory.class, CostTypeCategoryVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)costTypeCategoryVos);
    }

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(CostTypeCategoryVo costTypeCategoryVo) {
        block5: {
            String prefix = costTypeCategoryVo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(CostTypeCategoryVo costTypeCategoryVo) {
        Validate.notNull((Object)costTypeCategoryVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costTypeCategoryVo.setId(null);
        this.validationPrefix(costTypeCategoryVo);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getEnableStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6570\u636e\u4e1a\u52a1\u72b6\u6001\uff08\u542f\u7528\u72b6\u6001\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getCategoryCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getCategoryName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getFormCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8868\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getFormName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getBudgetSubjectsCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u9884\u7b97\u79d1\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeCategoryVo.getCostTypeCategoryRanges(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)costTypeCategoryVo.getCostTypeCategoryRanges().stream().allMatch(item -> StringUtils.isNotBlank((CharSequence)item.getRangeCode()) && StringUtils.isNotBlank((CharSequence)item.getRangeName()) && item.getRangeType() != null), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8303\u56f4\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        CostTypeCategoryVo current = this.findByCode(costTypeCategoryVo.getCategoryCode());
        Validate.isTrue((current == null ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7f16\u53f7\u91cd\u590d\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((!costTypeCategoryVo.getCategoryCode().contains("-") ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\"-\",\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CostTypeCategoryVo costTypeCategoryVo) {
        Validate.notNull((Object)costTypeCategoryVo, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(costTypeCategoryVo);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getCategoryCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getCategoryName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getFormCode(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8868\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeCategoryVo.getFormName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8868\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeCategoryVo.getCostTypeCategoryRanges(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u8303\u56f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)costTypeCategoryVo.getCostTypeCategoryRanges().stream().allMatch(item -> StringUtils.isNotBlank((CharSequence)item.getRangeCode()) && StringUtils.isNotBlank((CharSequence)item.getRangeName()) && item.getRangeType() != null), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u8303\u56f4\u6570\u636e\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((!costTypeCategoryVo.getCategoryCode().contains("-") ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u5927\u7c7b\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u7b26\u53f7\"-\",\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }
}

