/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeDetail;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeDetailSettingStrategy;
import com.biz.crm.tpm.business.budget.local.entity.CostTypeMapping;
import com.biz.crm.tpm.business.budget.local.repository.CostTypeDetailRepository;
import com.biz.crm.tpm.business.budget.local.repository.CostTypeDetailSettingStrategyRepository;
import com.biz.crm.tpm.business.budget.local.service.CostTypeMappingService;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeDetailLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostTypeDetailsDto;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingValueType;
import com.biz.crm.tpm.business.budget.sdk.event.CostTypeDetailEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.CostTypeDetailLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.service.StrategySettingManageVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.payby.PayByStrategy;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.CollectDistributionOrdersSetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.ControlActivityExpensesSetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.SignDisplaySetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStruct;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStructAnalysis;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeMappingVo;
import com.biz.crm.tpm.business.budget.sdk.vo.StrategySettingManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="costTypeDetailVoService")
public class CostTypeDetailVoServiceImpl
implements CostTypeDetailVoService {
    @Autowired
    private CostTypeDetailRepository costTypeDetailRepository;
    @Autowired
    private CostTypeMappingService costTypeMappingService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private List<CostTypeDetailEventListener> costTypeDetailEventListeners;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<PayByStrategy> payByStrategies;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private StrategySettingStructAnalysis strategySettingStructAnalysis;
    @Autowired
    private CostTypeDetailSettingStrategyRepository costTypeDetailSettingStrategyRepository;
    @Autowired
    private StrategySettingManageVoService strategySettingManageVoService;

    public Page<CostTypeDetailVo> findByConditions(Pageable pageable, CostTypeDetailsDto dto) {
        Page<CostTypeDetailVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CostTypeDetailsDto();
        }
        List selectedCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(new ArrayList());
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            selectedCodeList.add(dto.getSelectedCode());
        }
        if (!CollectionUtils.isEmpty((Collection)selectedCodeList)) {
            dto.setSelectedCodeList(selectedCodeList);
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.costTypeDetailRepository.findByConditions(pageable, dto)).getRecords())) {
            page.getRecords().forEach(item -> {
                item.setPayBys((Set)Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)item.getPayBy(), (String)","))));
                List<CostTypeMapping> costTypeMappings = this.costTypeMappingService.findByDetailCode(item.getDetailCode());
                if (!CollectionUtils.isEmpty(costTypeMappings)) {
                    Collection costTypeMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeMappings, CostTypeMapping.class, CostTypeMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    item.setCostTypeMappings((Set)Sets.newLinkedHashSet((Iterable)costTypeMappingVos));
                }
            });
        }
        return page;
    }

    public CostTypeDetailVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CostTypeDetail costTypeDetail = (CostTypeDetail)((Object)this.costTypeDetailRepository.getById((Serializable)((Object)id)));
        if (costTypeDetail == null) {
            return null;
        }
        CostTypeDetailVo costTypeDetailVo = (CostTypeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeDetail, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<CostTypeDetailSettingStrategy> settingStrategies = this.costTypeDetailSettingStrategyRepository.findByDetailCode(costTypeDetail.getDetailCode());
        if (!CollectionUtils.isEmpty(settingStrategies)) {
            ArrayList structs = Lists.newArrayList();
            this.transferToStrategySettingStruct(structs, settingStrategies);
            ArrayList trees = Lists.newArrayList();
            List tops = structs.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(tops)) {
                for (StrategySettingStruct top : tops) {
                    this.strategySettingStructAnalysis.structTree((List)trees, (List)structs, top);
                }
                costTypeDetailVo.setSettingStrategies((List)trees);
            }
        }
        costTypeDetailVo.setPayBys((Set)Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)costTypeDetailVo.getPayBy(), (String)","))));
        List<CostTypeMapping> costTypeMappings = this.costTypeMappingService.findByDetailCode(costTypeDetailVo.getDetailCode());
        if (!CollectionUtils.isEmpty(costTypeMappings)) {
            Collection costTypeMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeMappings, CostTypeMapping.class, CostTypeMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            costTypeDetailVo.setCostTypeMappings((Set)Sets.newLinkedHashSet((Iterable)costTypeMappingVos));
        }
        return costTypeDetailVo;
    }

    public CostTypeDetailVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CostTypeDetail costTypeDetail = this.costTypeDetailRepository.findByCode(code);
        if (costTypeDetail == null) {
            return null;
        }
        CostTypeDetailVo costTypeDetailVo = (CostTypeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeDetail, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<CostTypeDetailSettingStrategy> settingStrategies = this.costTypeDetailSettingStrategyRepository.findByDetailCode(costTypeDetail.getDetailCode());
        if (!CollectionUtils.isEmpty(settingStrategies)) {
            ArrayList structs = Lists.newArrayList();
            this.transferToStrategySettingStruct(structs, settingStrategies);
            ArrayList trees = Lists.newArrayList();
            List tops = structs.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(tops)) {
                for (StrategySettingStruct top : tops) {
                    this.strategySettingStructAnalysis.structTree((List)trees, (List)structs, top);
                }
                costTypeDetailVo.setSettingStrategies((List)trees);
            }
        }
        costTypeDetailVo.setPayBys((Set)Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)costTypeDetailVo.getPayBy(), (String)","))));
        List<CostTypeMapping> costTypeMappings = this.costTypeMappingService.findByDetailCode(costTypeDetailVo.getDetailCode());
        if (!CollectionUtils.isEmpty(costTypeMappings)) {
            Collection costTypeMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeMappings, CostTypeMapping.class, CostTypeMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            costTypeDetailVo.setCostTypeMappings((Set)Sets.newLinkedHashSet((Iterable)costTypeMappingVos));
        }
        return costTypeDetailVo;
    }

    public List<CostTypeDetailVo> findByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<CostTypeDetail> costTypeDetail = this.costTypeDetailRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(costTypeDetail)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetail, CostTypeDetail.class, CostTypeDetailVo.class, HashSet.class, ArrayList.class, new String[0]));
        Set<String> costTypeDetailCodes = costTypeDetail.stream().map(CostTypeDetail::getDetailCode).collect(Collectors.toSet());
        List<CostTypeDetailSettingStrategy> costTypeDetailSettingStrategies = this.costTypeDetailSettingStrategyRepository.findByDetailCodes(costTypeDetailCodes);
        if (CollectionUtils.isEmpty(costTypeDetailSettingStrategies)) {
            return result;
        }
        ArrayList allSettingStructs = Lists.newArrayList();
        this.transferToStrategySettingStruct(allSettingStructs, costTypeDetailSettingStrategies);
        Map<String, List<StrategySettingStruct>> settingStructMap = allSettingStructs.stream().collect(Collectors.groupingBy(StrategySettingStruct::getDetailCode));
        block0: for (CostTypeDetailVo detail : result) {
            for (Map.Entry<String, List<StrategySettingStruct>> entry : settingStructMap.entrySet()) {
                if (!StringUtils.equals((CharSequence)detail.getDetailCode(), (CharSequence)entry.getKey())) continue;
                List<StrategySettingStruct> structs = settingStructMap.get(detail.getDetailCode());
                if (CollectionUtils.isEmpty(structs)) continue block0;
                ArrayList trees = Lists.newArrayList();
                List tops = structs.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(tops)) {
                    for (StrategySettingStruct top : tops) {
                        this.strategySettingStructAnalysis.structTree((List)trees, structs, top);
                    }
                }
                detail.setSettingStrategies((List)trees);
                continue block0;
            }
        }
        return result;
    }

    @Transactional
    public CostTypeDetailVo create(CostTypeDetailVo costTypeDetailVo) {
        costTypeDetailVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        costTypeDetailVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidate(costTypeDetailVo);
        String code = (String)this.generateCodeService.generateCode("HDXL", 1).get(0);
        costTypeDetailVo.setDetailCode(code);
        CostTypeDetail costTypeDetail = (CostTypeDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeDetailVo, CostTypeDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        costTypeDetail.setTenantCode(TenantUtils.getTenantCode());
        String payBy = String.join((CharSequence)",", costTypeDetailVo.getPayBys());
        costTypeDetail.setPayBy(payBy);
        this.costTypeDetailRepository.saveOrUpdate((Object)costTypeDetail);
        StrategySettingManageVo settingManageVo = this.strategySettingManageVoService.findEnabled();
        Validate.notNull((Object)settingManageVo, (String)"\u5f53\u524d\u4e0d\u5b58\u5728\u6b63\u5728\u4f7f\u7528\u7684\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u8bbe\u7f6e\u7b56\u7565\u914d\u7f6e\u4fe1\u606f", (Object[])new Object[0]);
        List activityStructs = settingManageVo.getActivitySettings();
        Validate.notEmpty((Collection)activityStructs, (String)"\u7b56\u7565\u914d\u7f6e\u3010%s\u3011\u6d3b\u52a8\u76f8\u5173\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingManageVo.getName()});
        List auditStructs = settingManageVo.getAuditSettings();
        Validate.notEmpty((Collection)auditStructs, (String)"\u7b56\u7565\u914d\u7f6e\u3010%s\u3011\u6838\u9500\u76f8\u5173\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingManageVo.getName()});
        ArrayList flatStructs = Lists.newArrayList();
        activityStructs.forEach(e -> this.flatStrategySettingStructs((StrategySettingStruct)e, flatStructs));
        auditStructs.forEach(e -> this.flatStrategySettingStructs((StrategySettingStruct)e, flatStructs));
        Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u65b0\u589e\u6d3b\u52a8\u7ec6\u7c7b\u65f6\uff0c\u4f20\u5165\u7684\u6b63\u5728\u4f7f\u7528\u7684\u7b56\u7565\u9879\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set newestStrategySettingCodes = flatStructs.stream().map(StrategySettingStruct::getCode).collect(Collectors.toSet());
        Set currentStrategySettingCodes = costTypeDetailVo.getSettingStrategies().stream().map(StrategySettingStruct::getCode).collect(Collectors.toSet());
        Validate.isTrue((boolean)newestStrategySettingCodes.containsAll(currentStrategySettingCodes), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u63d0\u4ea4\u7684\u7b56\u7565\u9879\u4fe1\u606f\u4e0e\u6700\u65b0\u4f7f\u7528\u7684\u7b56\u7565\u914d\u7f6e\u9879\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ArrayList costTypeDetailSettingStrategies = Lists.newArrayList();
        this.transferToCostTypeDetailSettingStrategy(costTypeDetailSettingStrategies, costTypeDetailVo.getSettingStrategies(), costTypeDetail.getDetailCode());
        CostTypeDetailSettingStrategy controlActivityExpensesSetting = costTypeDetailSettingStrategies.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())).findFirst().orElse(null);
        this.validateDisplaySpecial(controlActivityExpensesSetting, costTypeDetailSettingStrategies);
        for (Object settingStrategy : costTypeDetailSettingStrategies) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)settingStrategy.getId()), (String)"\u7b56\u7565\u9879\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
            this.validateBase((CostTypeDetailSettingStrategy)((Object)settingStrategy));
        }
        this.costTypeDetailSettingStrategyRepository.saveBatch(costTypeDetailSettingStrategies);
        Collection costTypeMappings = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costTypeDetailVo.getCostTypeMappings(), CostTypeMappingVo.class, CostTypeMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (CostTypeMapping CostTypeMapping2 : costTypeMappings) {
            CostTypeMapping2.setId(null);
            CostTypeMapping2.setTenantCode(TenantUtils.getTenantCode());
            CostTypeMapping2.setDetailCode(costTypeDetail.getDetailCode());
        }
        this.costTypeMappingService.saveBatch(costTypeMappings);
        costTypeDetailVo.setId(costTypeDetail.getId());
        if (!CollectionUtils.isEmpty(this.costTypeDetailEventListeners)) {
            for (CostTypeDetailEventListener costTypeDetailEventListener : this.costTypeDetailEventListeners) {
                costTypeDetailEventListener.onCreated(costTypeDetailVo);
            }
        }
        CostTypeDetailLogEventDto logEventDto = new CostTypeDetailLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(costTypeDetailVo);
        SerializableBiConsumer & Serializable onCreate = CostTypeDetailLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeDetailLogEventListener.class, (SerializableBiConsumer)onCreate);
        return costTypeDetailVo;
    }

    @Transactional
    public CostTypeDetailVo update(CostTypeDetailVo costTypeDetailVo) {
        this.updateValidate(costTypeDetailVo);
        CostTypeDetail costTypeDetail = (CostTypeDetail)((Object)this.costTypeDetailRepository.getById((Serializable)((Object)costTypeDetailVo.getId())));
        CostTypeDetailVo oldCostTypeDetailVo = (CostTypeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeDetail, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Validate.notNull((Object)((Object)costTypeDetail), (String)"\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        costTypeDetail.setRemark(costTypeDetailVo.getRemark());
        costTypeDetail.setDetailName(costTypeDetailVo.getDetailName());
        costTypeDetail.setAccountingSubjectsCode(costTypeDetailVo.getAccountingSubjectsCode());
        costTypeDetail.setAccountingSubjectsName(costTypeDetailVo.getAccountingSubjectsName());
        costTypeDetail.setIsShareToProduct(costTypeDetailVo.getIsShareToProduct());
        String payBy = String.join((CharSequence)",", costTypeDetailVo.getPayBys());
        costTypeDetail.setPayBy(payBy);
        this.costTypeDetailRepository.saveOrUpdate((Object)costTypeDetail);
        this.costTypeDetailSettingStrategyRepository.deleteByDetailCodes(Sets.newHashSet((Object[])new String[]{costTypeDetail.getDetailCode()}));
        ArrayList costTypeDetailSettingStrategies = Lists.newArrayList();
        this.transferToCostTypeDetailSettingStrategy(costTypeDetailSettingStrategies, costTypeDetailVo.getSettingStrategies(), costTypeDetail.getDetailCode());
        CostTypeDetailSettingStrategy controlActivityExpensesSetting = costTypeDetailSettingStrategies.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())).findFirst().orElse(null);
        this.validateDisplaySpecial(controlActivityExpensesSetting, costTypeDetailSettingStrategies);
        for (Object settingStrategy : costTypeDetailSettingStrategies) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)settingStrategy.getId()), (String)"\u7b56\u7565\u9879\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
            this.validateBase((CostTypeDetailSettingStrategy)((Object)settingStrategy));
        }
        this.costTypeDetailSettingStrategyRepository.saveBatch(costTypeDetailSettingStrategies);
        Collection costTypeMappings = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)costTypeDetailVo.getCostTypeMappings(), CostTypeMappingVo.class, CostTypeMapping.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        for (Object CostTypeMapping2 : costTypeMappings) {
            CostTypeMapping2.setId(null);
            CostTypeMapping2.setTenantCode(TenantUtils.getTenantCode());
            ((CostTypeMapping)((Object)CostTypeMapping2)).setDetailCode(costTypeDetail.getDetailCode());
        }
        List<CostTypeMapping> oldMapping = this.costTypeMappingService.findByDetailCode(costTypeDetail.getDetailCode());
        this.costTypeMappingService.deleteByDetailCode(costTypeDetail.getDetailCode());
        this.costTypeMappingService.saveBatch(costTypeMappings);
        if (!CollectionUtils.isEmpty(this.costTypeDetailEventListeners)) {
            for (CostTypeDetailEventListener costTypeDetailEventListener : this.costTypeDetailEventListeners) {
                costTypeDetailEventListener.onUpdate(oldCostTypeDetailVo, costTypeDetailVo);
            }
        }
        CostTypeDetailLogEventDto logEventDto = new CostTypeDetailLogEventDto();
        if (!CollectionUtils.isEmpty(oldMapping)) {
            Collection costTypeMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(oldMapping, CostTypeMapping.class, CostTypeMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            oldCostTypeDetailVo.setCostTypeMappings((Set)Sets.newLinkedHashSet((Iterable)costTypeMappingVos));
        }
        logEventDto.setOriginal(oldCostTypeDetailVo);
        CostTypeDetailVo newVo = (CostTypeDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)costTypeDetail, CostTypeDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        newVo.setCostTypeMappings(costTypeDetailVo.getCostTypeMappings());
        logEventDto.setNewest(newVo);
        SerializableBiConsumer & Serializable onUpdate = CostTypeDetailLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeDetailLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return costTypeDetailVo;
    }

    private void transferToCostTypeDetailSettingStrategy(List<CostTypeDetailSettingStrategy> costTypeDetailSettingStrategies, List<StrategySettingStruct> structs, String detailCode) {
        for (StrategySettingStruct strategySettingStruct : structs) {
            CostTypeDetailSettingStrategy costTypeDetailSettingStrategy = new CostTypeDetailSettingStrategy();
            costTypeDetailSettingStrategy.setId(strategySettingStruct.getId());
            costTypeDetailSettingStrategy.setCode(strategySettingStruct.getCode());
            costTypeDetailSettingStrategy.setDateFormat(strategySettingStruct.getDateFormat());
            costTypeDetailSettingStrategy.setDefaultValue(strategySettingStruct.getDefaultValue() == null ? null : String.valueOf(strategySettingStruct.getDefaultValue()));
            costTypeDetailSettingStrategy.setDisplay(strategySettingStruct.getDisplay());
            costTypeDetailSettingStrategy.setDetailCode(detailCode);
            costTypeDetailSettingStrategy.setName(strategySettingStruct.getName());
            costTypeDetailSettingStrategy.setNecessary(strategySettingStruct.getNecessary());
            costTypeDetailSettingStrategy.setParentCode(strategySettingStruct.getParentCode());
            costTypeDetailSettingStrategy.setSettingManageCode(strategySettingStruct.getSettingManageCode());
            costTypeDetailSettingStrategy.setSortIndex(strategySettingStruct.getSortIndex());
            costTypeDetailSettingStrategy.setTip(strategySettingStruct.getTip());
            costTypeDetailSettingStrategy.setType(strategySettingStruct.getType());
            costTypeDetailSettingStrategy.setValue(strategySettingStruct.getValue() == null ? null : strategySettingStruct.getValue().toString());
            costTypeDetailSettingStrategy.setValueType(strategySettingStruct.getValueType());
            costTypeDetailSettingStrategies.add(costTypeDetailSettingStrategy);
            if (CollectionUtils.isEmpty((Collection)strategySettingStruct.getChildren())) continue;
            this.transferToCostTypeDetailSettingStrategy(costTypeDetailSettingStrategies, strategySettingStruct.getChildren(), detailCode);
        }
    }

    private void transferToStrategySettingStruct(List<StrategySettingStruct> structs, List<CostTypeDetailSettingStrategy> settingStrategies) {
        for (CostTypeDetailSettingStrategy settingStrategy : settingStrategies) {
            StrategySettingStruct struct = new StrategySettingStruct();
            struct.setId(settingStrategy.getId());
            struct.setCode(settingStrategy.getCode());
            struct.setDateFormat(settingStrategy.getDateFormat());
            struct.setDefaultValue(StringUtils.isBlank((CharSequence)settingStrategy.getValue()) ? null : this.strategySettingStructAnalysis.transferValue(settingStrategy.getValue(), settingStrategy.getValueType()));
            struct.setDisplay(settingStrategy.getDisplay());
            struct.setDetailCode(settingStrategy.getDetailCode());
            struct.setName(settingStrategy.getName());
            struct.setNecessary(settingStrategy.getNecessary());
            struct.setParentCode(settingStrategy.getParentCode());
            struct.setSettingManageCode(settingStrategy.getSettingManageCode());
            struct.setSortIndex(settingStrategy.getSortIndex());
            struct.setTip(settingStrategy.getTip());
            struct.setType(settingStrategy.getType());
            struct.setValue(StringUtils.isBlank((CharSequence)settingStrategy.getValue()) ? null : this.strategySettingStructAnalysis.transferValue(settingStrategy.getValue(), settingStrategy.getValueType()));
            struct.setValueType(settingStrategy.getValueType());
            structs.add(struct);
        }
    }

    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((!CollectionUtils.isEmpty(ids) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CostTypeDetail> costTypeDetailsses = this.costTypeDetailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeDetailsses)) {
            return;
        }
        this.costTypeDetailSettingStrategyRepository.deleteByDetailCodes(costTypeDetailsses.stream().map(CostTypeDetail::getDetailCode).collect(Collectors.toSet()));
        Collection costTypeDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetailsses, CostTypeDetail.class, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeDetailRepository.removeByIds(ids);
        if (!CollectionUtils.isEmpty(this.costTypeDetailEventListeners)) {
            for (CostTypeDetailEventListener costTypeDetailEventListener : this.costTypeDetailEventListeners) {
                for (CostTypeDetailVo costTypeDetailsVo : costTypeDetailVos) {
                    costTypeDetailEventListener.onDeleted(costTypeDetailsVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDelete = CostTypeDetailLogEventListener::onDelete;
        for (CostTypeDetailVo vo : costTypeDetailVos) {
            CostTypeDetailLogEventDto logEventDto = new CostTypeDetailLogEventDto();
            logEventDto.setOriginal(vo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeDetailLogEventListener.class, (SerializableBiConsumer)onDelete);
        }
    }

    public List<CostTypeDetailVo> findByEnableStatus(String enableStatus) {
        if (StringUtils.isBlank((CharSequence)enableStatus)) {
            return Collections.emptyList();
        }
        List<CostTypeDetail> costTypeDetails = this.costTypeDetailRepository.findByEnableStatus(enableStatus);
        if (CollectionUtils.isEmpty(costTypeDetails)) {
            return Collections.emptyList();
        }
        Collection costTypeDetailss = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetails, CostTypeDetail.class, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        costTypeDetailss.forEach(item -> item.setPayBys((Set)Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)item.getPayBy(), (String)",")))));
        return Lists.newArrayList((Iterable)costTypeDetailss);
    }

    @Transactional
    public void enable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u542f\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CostTypeDetail> costTypeDetails = this.costTypeDetailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeDetails)) {
            return;
        }
        Collection costTypeDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetails, CostTypeDetail.class, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeDetailRepository.updateEnableStatusByIds(EnableStatusEnum.ENABLE, ids);
        if (!CollectionUtils.isEmpty(this.costTypeDetailEventListeners)) {
            for (CostTypeDetailEventListener costTypeDetailEventListener : this.costTypeDetailEventListeners) {
                for (CostTypeDetailVo costTypeDetailVo : costTypeDetailVos) {
                    costTypeDetailEventListener.onEnable(costTypeDetailVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onEnable = CostTypeDetailLogEventListener::onEnable;
        for (CostTypeDetailVo vo : costTypeDetailVos) {
            CostTypeDetailLogEventDto logEventDto = new CostTypeDetailLogEventDto();
            logEventDto.setOriginal(vo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeDetailLogEventListener.class, (SerializableBiConsumer)onEnable);
        }
    }

    @Transactional
    public void disable(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CostTypeDetail> costTypeDetails = this.costTypeDetailRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(costTypeDetails)) {
            return;
        }
        Collection costTypeDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetails, CostTypeDetail.class, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.costTypeDetailRepository.updateEnableStatusByIds(EnableStatusEnum.DISABLE, ids);
        if (!CollectionUtils.isEmpty(this.costTypeDetailEventListeners)) {
            for (CostTypeDetailEventListener costTypeDetailEventListener : this.costTypeDetailEventListeners) {
                for (CostTypeDetailVo costTypeDetailVo : costTypeDetailVos) {
                    costTypeDetailEventListener.onEnable(costTypeDetailVo);
                }
            }
        }
        SerializableBiConsumer & Serializable onDisable = CostTypeDetailLogEventListener::onDisable;
        for (CostTypeDetailVo vo : costTypeDetailVos) {
            CostTypeDetailLogEventDto logEventDto = new CostTypeDetailLogEventDto();
            logEventDto.setOriginal(vo);
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, CostTypeDetailLogEventListener.class, (SerializableBiConsumer)onDisable);
        }
    }

    public String preSave() {
        String prefix = UUID.randomUUID().toString();
        this.redisMutexService.setMCode("generate:prefix", prefix, prefix, TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS));
        return prefix;
    }

    public Set<CostTypeDetailVo> findByCategoryCode(String categoryCode) {
        if (StringUtils.isBlank((CharSequence)categoryCode)) {
            return Collections.emptySet();
        }
        List<CostTypeMapping> costTypeMappings = this.costTypeMappingService.findByCategoryCode(categoryCode);
        if (CollectionUtils.isEmpty(costTypeMappings)) {
            return Collections.emptySet();
        }
        List<String> detailCodes = costTypeMappings.stream().map(CostTypeMapping::getDetailCode).collect(Collectors.toList());
        List<CostTypeDetail> costTypeDetails = this.costTypeDetailRepository.findByCodes(detailCodes);
        if (CollectionUtils.isEmpty(costTypeDetails)) {
            return Collections.emptySet();
        }
        Collection costTypeDetailVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeDetails, CostTypeDetail.class, CostTypeDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Collection costTypeMappingVos = this.nebulaToolkitService.copyCollectionByWhiteList(costTypeMappings, CostTypeMapping.class, CostTypeMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        Set<CostTypeDetailVo> enableCostTypeDetailVos = costTypeDetailVos.stream().filter(item -> EnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toSet());
        enableCostTypeDetailVos.forEach(item -> {
            item.setPayBys((Set)Sets.newLinkedHashSet(Arrays.asList(StringUtils.split((String)item.getPayBy(), (String)","))));
            item.setCostTypeMappings((Set)Sets.newLinkedHashSet((Iterable)costTypeMappingVos));
        });
        return Sets.newLinkedHashSet(enableCostTypeDetailVos);
    }

    public boolean existByApprovalCollect(String code) {
        return NumberUtils.compare((int)this.costTypeDetailSettingStrategyRepository.countByApprovalCollect(code), (int)0) > 0;
    }

    public List<PayByStrategy> findAllPayBy() {
        if (CollectionUtils.isEmpty(this.payByStrategies)) {
            return Collections.emptyList();
        }
        return this.payByStrategies;
    }

    public Set<String> findCodeByCondition(CostTypeDetailsDto dto) {
        return this.costTypeDetailRepository.findCodeByCondition(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validationPrefix(CostTypeDetailVo costTypeDetailVo) {
        block5: {
            String prefix = costTypeDetailVo.getPrefix();
            Validate.notBlank((CharSequence)prefix, (String)"\u9519\u8bef\u7684\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)this.redisMutexService.getMCode("generate:prefix", prefix)), (String)"\u6ca1\u6709\u53d1\u73b0\u9884\u64cd\u4f5c\u6807\u8bb0\uff0c\u53ef\u80fd\u662f\u56e0\u4e3a\u91cd\u590d\u64cd\u4f5c\u7684\u539f\u56e0!", (Object[])new Object[0]);
            boolean isLock = false;
            try {
                isLock = this.redisMutexService.tryLock(prefix, TimeUnit.MILLISECONDS, 1);
                if (isLock) {
                    this.redisMutexService.setMCode("generate:prefix", prefix, prefix, 1L);
                    break block5;
                }
                throw new IllegalArgumentException("\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c!!");
            }
            finally {
                if (isLock) {
                    this.redisMutexService.unlock(prefix);
                }
            }
        }
    }

    private void createValidate(CostTypeDetailVo costTypeDetailVo) {
        Validate.notNull((Object)costTypeDetailVo, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        costTypeDetailVo.setId(null);
        Validate.notBlank((CharSequence)costTypeDetailVo.getDetailName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeDetailVo.getPayBys(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List structs = costTypeDetailVo.getSettingStrategies();
        for (StrategySettingStruct struct : structs) {
            this.strategySettingStructAnalysis.validateValue(struct);
        }
        Validate.notEmpty((Collection)costTypeDetailVo.getCostTypeMappings(), (String)"\u65b0\u589e\u6570\u636e\u662f\uff0c\u6d3b\u52a8\u5927\u7c7b\u5173\u8054\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)costTypeDetailVo.getCostTypeMappings().stream().allMatch(item -> StringUtils.isNotBlank((CharSequence)item.getCategoryCode()) && StringUtils.isNotBlank((CharSequence)item.getCategoryName()) && StringUtils.isNotBlank((CharSequence)item.getBudgetSubjectsCode()) && StringUtils.isNotBlank((CharSequence)item.getBudgetSubjectsName())), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u5173\u8054\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        long count = costTypeDetailVo.getCostTypeMappings().stream().map(CostTypeMappingVo::getCategoryCode).distinct().count();
        Validate.isTrue(((long)costTypeDetailVo.getCostTypeMappings().size() == count ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5173\u8054\u6d3b\u52a8\u5927\u7c7b\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CostTypeDetailVo costTypeDetailVo) {
        Validate.notNull((Object)costTypeDetailVo, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.validationPrefix(costTypeDetailVo);
        Validate.notBlank((CharSequence)costTypeDetailVo.getId(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costTypeDetailVo.getDetailName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7ec6\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeDetailVo.getPayBys(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List structs = costTypeDetailVo.getSettingStrategies();
        for (StrategySettingStruct struct : structs) {
            this.strategySettingStructAnalysis.validateValue(struct);
        }
        Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)costTypeDetailVo.getCostTypeMappings().stream().allMatch(item -> StringUtils.isNotBlank((CharSequence)item.getCategoryCode()) && StringUtils.isNotBlank((CharSequence)item.getCategoryName()) && StringUtils.isNotBlank((CharSequence)item.getBudgetSubjectsCode()) && StringUtils.isNotBlank((CharSequence)item.getBudgetSubjectsName())), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5927\u7c7b\u5173\u8054\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        long count = costTypeDetailVo.getCostTypeMappings().stream().map(CostTypeMappingVo::getCategoryCode).distinct().count();
        Validate.isTrue(((long)costTypeDetailVo.getCostTypeMappings().size() == count ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5173\u8054\u6d3b\u52a8\u5927\u7c7b\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
    }

    private void flatStrategySettingStructs(StrategySettingStruct struct, List<StrategySettingStruct> result) {
        result.add(struct);
        if (!CollectionUtils.isEmpty((Collection)struct.getChildren())) {
            for (StrategySettingStruct child : struct.getChildren()) {
                this.flatStrategySettingStructs(child, result);
            }
        }
    }

    private void validateBase(CostTypeDetailSettingStrategy settingStrategy) {
        Validate.notBlank((CharSequence)settingStrategy.getName(), (String)"\u7b56\u7565\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)settingStrategy.getCode(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notBlank((CharSequence)settingStrategy.getType(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notBlank((CharSequence)settingStrategy.getValueType(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notBlank((CharSequence)settingStrategy.getSettingManageCode(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notNull((Object)settingStrategy.getNecessary(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u5fc5\u9700\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notNull((Object)settingStrategy.getDisplay(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        Validate.notNull((Object)settingStrategy.getSortIndex(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        if (StringUtils.equals((CharSequence)settingStrategy.getValueType(), (CharSequence)StrategySettingValueType.DATE.getCode())) {
            Validate.notBlank((CharSequence)settingStrategy.getDateFormat(), (String)"\u7b56\u7565\u9879\u7ed3\u6784\u3010%s\u3011\u65f6\u95f4\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        }
        if (settingStrategy.getNecessary().booleanValue() && settingStrategy.getDisplay() != null && settingStrategy.getDisplay() == Boolean.TRUE) {
            Validate.notBlank((CharSequence)settingStrategy.getValue(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{settingStrategy.getName()});
        }
    }

    private void validateDisplaySpecial(CostTypeDetailSettingStrategy struct, List<CostTypeDetailSettingStrategy> specialStructs) {
        if (struct == null) {
            return;
        }
        this.validateDisplaySpecialForStruct(struct, specialStructs);
        if (StringUtils.equals((CharSequence)struct.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())) {
            CostTypeDetailSettingStrategy collectDistributionOrdersSetting = specialStructs.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)CollectDistributionOrdersSetting.class.getSimpleName())).findFirst().orElse(null);
            CostTypeDetailSettingStrategy signDisplaySetting = specialStructs.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)SignDisplaySetting.class.getSimpleName())).findFirst().orElse(null);
            Validate.isTrue((collectDistributionOrdersSetting != null || signDisplaySetting != null ? 1 : 0) != 0, (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u3010\u662f\u5426\u7b7e\u7f72\u9648\u5217\u534f\u8bae\u3011\u548c\u3010\u662f\u5426\u91c7\u96c6\u5206\u9500\u8ba2\u5355\u3011\u4e0d\u80fd\u540c\u65f6\u9690\u85cf", (Object[])new Object[0]);
            if (collectDistributionOrdersSetting != null && collectDistributionOrdersSetting.getValue() != null && StringUtils.equals((CharSequence)collectDistributionOrdersSetting.getValue().toString(), (CharSequence)Boolean.TRUE.toString()) || signDisplaySetting != null && signDisplaySetting.getValue() != null && StringUtils.equals((CharSequence)signDisplaySetting.getValue().toString(), (CharSequence)Boolean.TRUE.toString())) {
                Validate.notNull((Object)struct.getDisplay(), (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getDisplay().toString(), (CharSequence)Boolean.TRUE.toString()), (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u9690\u85cf", (Object[])new Object[]{struct.getName()});
            } else {
                Validate.notNull((Object)struct.getDisplay(), (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getDisplay().toString(), (CharSequence)Boolean.FALSE.toString()), (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u663e\u793a", (Object[])new Object[]{struct.getName()});
            }
        }
    }

    private void validateDisplaySpecialForStruct(CostTypeDetailSettingStrategy struct, List<CostTypeDetailSettingStrategy> specialStructs) {
        if (struct == null) {
            return;
        }
        Validate.notEmpty(specialStructs, (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u6307\u5b9a\u7684\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)struct.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())) {
            boolean matched = specialStructs.stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)CollectDistributionOrdersSetting.class.getSimpleName()) || StringUtils.equals((CharSequence)e.getCode(), (CharSequence)SignDisplaySetting.class.getSimpleName()));
            Validate.isTrue((boolean)matched, (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u5982\u679c\u7b56\u7565\u9879\u3010%s\u3011\u5b58\u5728\uff0c\u3010\u662f\u5426\u7b7e\u7f72\u9648\u5217\u534f\u8bae\u3011\u548c\u3010\u662f\u5426\u91c7\u96c6\u5206\u9500\u8ba2\u5355\u3011\u4e0d\u80fd\u540c\u65f6\u9690\u85cf", (Object[])new Object[]{struct.getName()});
        }
    }
}

