/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultGenerateCodeServiceImpl
implements GenerateCodeService {
    @Autowired
    private RedisMutexService redisMutexService;
    private static final String KEY_FORMAT = "%s:code:index:%s";

    public List<String> generateCode(String ruleCode, int number) {
        ArrayList codes = Lists.newArrayList();
        String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
        for (int i = 0; i < number; ++i) {
            String index = this.redisMutexService.getAndIncrement(key, 1L, Integer.valueOf(4));
            codes.add(StringUtils.join((Object[])new String[]{ruleCode, index}));
        }
        return codes;
    }

    public List<String> generateCode(String ruleCode, int number, Integer mixStrLen, long expire, TimeUnit unit) {
        ArrayList codes = Lists.newArrayList();
        String key = String.format(KEY_FORMAT, ruleCode, TenantUtils.getTenantCode());
        for (int i = 0; i < number; ++i) {
            String index = this.redisMutexService.getAndIncrement(key, 1L, mixStrLen, expire, unit);
            codes.add(StringUtils.join((Object[])new String[]{ruleCode, index}));
        }
        return codes;
    }
}

