/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.budget.local.entity.StrategySettingManage;
import com.biz.crm.tpm.business.budget.local.repository.StrategySettingManageRepository;
import com.biz.crm.tpm.business.budget.sdk.dto.StrategySettingManageDto;
import com.biz.crm.tpm.business.budget.sdk.dto.StrategySettingManageLogEventDto;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingType;
import com.biz.crm.tpm.business.budget.sdk.event.StrategySettingManageEventListener;
import com.biz.crm.tpm.business.budget.sdk.event.log.StrategySettingManageLogEventListener;
import com.biz.crm.tpm.business.budget.sdk.service.StrategySettingManageVoService;
import com.biz.crm.tpm.business.budget.sdk.service.StrategySettingVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.AbstractStrategySetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStruct;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStructAnalysis;
import com.biz.crm.tpm.business.budget.sdk.vo.StrategySettingManageVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StrategySettingManageVoServiceImpl
implements StrategySettingManageVoService {
    @Autowired
    private StrategySettingManageRepository strategySettingManageRepository;
    @Autowired
    private StrategySettingVoService strategySettingVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<AbstractStrategySetting> abstractStrategySettings;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private StrategySettingStructAnalysis strategySettingStructAnalysis;
    @Autowired(required=false)
    private List<StrategySettingManageEventListener> strategySettingManageEventListeners;

    @Transactional
    public void create(StrategySettingManageDto dto) {
        this.createValidation(dto);
        List all = this.strategySettingManageRepository.list();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty((Collection)all)) {
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        } else {
            dto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        }
        StrategySettingManage entity = (StrategySettingManage)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, StrategySettingManage.class, HashSet.class, ArrayList.class, new String[0]));
        this.strategySettingManageRepository.save((Object)entity);
        dto.setCode(entity.getCode());
        ArrayList items = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)dto.getActivitySettings())) {
            dto.getActivitySettings().forEach(e -> this.fillSettingManageCode(entity.getCode(), (StrategySettingStruct)e));
            items.addAll(dto.getActivitySettings());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getAuditSettings())) {
            dto.getAuditSettings().forEach(e -> this.fillSettingManageCode(entity.getCode(), (StrategySettingStruct)e));
            items.addAll(dto.getAuditSettings());
        }
        this.strategySettingVoService.create((List)items);
        if (dto.getEnableOprt() != null && dto.getEnableOprt() == Boolean.TRUE) {
            this.enableStatus(entity.getId());
        }
        StrategySettingManageVo strategySettingManageVo = (StrategySettingManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]);
        strategySettingManageVo.setActivitySettings(items.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.ACTIVITY.name())).collect(Collectors.toList()));
        strategySettingManageVo.setAuditSettings(items.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.AUDIT.name())).collect(Collectors.toList()));
        StrategySettingManageLogEventDto logEventDto = new StrategySettingManageLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(strategySettingManageVo);
        SerializableBiConsumer & Serializable onCreate = StrategySettingManageLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, StrategySettingManageLogEventListener.class, (SerializableBiConsumer)onCreate);
    }

    @Transactional
    public void update(StrategySettingManageDto dto) {
        this.updateValidation(dto);
        StrategySettingManage dbSetting = (StrategySettingManage)((Object)this.strategySettingManageRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)dbSetting), (String)"\u6839\u636e\u6307\u5b9a\u7684id\u952e\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(this.strategySettingManageEventListeners)) {
            for (StrategySettingManageEventListener listener : this.strategySettingManageEventListeners) {
                listener.onUpdate(dbSetting.getCode());
            }
        }
        dbSetting.setName(dto.getName());
        this.strategySettingManageRepository.saveOrUpdate((Object)dbSetting);
        ArrayList items = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)dto.getActivitySettings())) {
            dto.getActivitySettings().forEach(e -> this.fillSettingManageCode(dbSetting.getCode(), (StrategySettingStruct)e));
            items.addAll(dto.getActivitySettings());
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getAuditSettings())) {
            dto.getAuditSettings().forEach(e -> this.fillSettingManageCode(dbSetting.getCode(), (StrategySettingStruct)e));
            items.addAll(dto.getAuditSettings());
        }
        this.strategySettingVoService.update((List)items);
        if (dto.getEnableOprt() != null && dto.getEnableOprt() == Boolean.TRUE) {
            this.enableStatus(dbSetting.getId());
        }
        StrategySettingManageVo strategySettingManageVo = (StrategySettingManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]);
        StrategySettingManageVo newestStrategySettingManageVo = (StrategySettingManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbSetting, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]);
        newestStrategySettingManageVo.setActivitySettings(items.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.ACTIVITY.name())).collect(Collectors.toList()));
        newestStrategySettingManageVo.setAuditSettings(items.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.AUDIT.name())).collect(Collectors.toList()));
        StrategySettingManageLogEventDto logEventDto = new StrategySettingManageLogEventDto();
        logEventDto.setOriginal(strategySettingManageVo);
        logEventDto.setNewest(newestStrategySettingManageVo);
        SerializableBiConsumer & Serializable onUpdate = StrategySettingManageLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, StrategySettingManageLogEventListener.class, (SerializableBiConsumer)onUpdate);
    }

    public Page<StrategySettingManageVo> findByConditions(Pageable pageable, StrategySettingManageDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (dto == null) {
            dto = new StrategySettingManageDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getDelFlag())) {
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        return this.strategySettingManageRepository.findByConditions(pageable, dto);
    }

    public List<StrategySettingManageVo> findByIds(Set<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<StrategySettingManage> settings = this.strategySettingManageRepository.findByIds(ids);
        if (CollectionUtils.isEmpty(settings)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(settings, StrategySettingManage.class, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public StrategySettingManageVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        StrategySettingManage strategySettingManage = this.strategySettingManageRepository.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (strategySettingManage == null) {
            return null;
        }
        List itemVos = this.strategySettingVoService.findBySettingManageCode(strategySettingManage.getCode());
        StrategySettingManageVo settingVo = (StrategySettingManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)strategySettingManage, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty((Collection)itemVos)) {
            return settingVo;
        }
        List<StrategySettingStruct> activityItems = itemVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.ACTIVITY.name())).collect(Collectors.toList());
        ArrayList activityTrees = Lists.newArrayList();
        this.buildItemTrees(activityItems, activityTrees);
        settingVo.setActivitySettings((List)activityTrees);
        List<StrategySettingStruct> auditItems = itemVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.AUDIT.name())).collect(Collectors.toList());
        ArrayList auditTrees = Lists.newArrayList();
        this.buildItemTrees(auditItems, auditTrees);
        settingVo.setAuditSettings((List)auditTrees);
        return settingVo;
    }

    public List<StrategySettingStruct> structs(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes) || CollectionUtils.isEmpty(this.abstractStrategySettings)) {
            return Lists.newArrayList();
        }
        List settings = this.abstractStrategySettings.stream().filter(e -> codes.contains(e.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(settings)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (AbstractStrategySetting setting : settings) {
            StrategySettingStruct struct = this.strategySettingStructAnalysis.transferToStruct(setting);
            if (struct == null) continue;
            result.add(struct);
        }
        return result;
    }

    public StrategySettingManageVo findEnabled() {
        StrategySettingManage strategySettingManage = this.strategySettingManageRepository.findEnabled();
        if (strategySettingManage == null) {
            return null;
        }
        List strategySettingVos = this.strategySettingVoService.findBySettingManageCode(strategySettingManage.getCode());
        StrategySettingManageVo strategySettingManageVo = (StrategySettingManageVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)strategySettingManage, StrategySettingManageVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty((Collection)strategySettingVos)) {
            return null;
        }
        List<StrategySettingStruct> activityItems = strategySettingVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.ACTIVITY.name())).collect(Collectors.toList());
        ArrayList activityTrees = Lists.newArrayList();
        this.buildItemTrees(activityItems, activityTrees);
        strategySettingManageVo.setActivitySettings((List)activityTrees);
        List<StrategySettingStruct> auditItems = strategySettingVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getType(), (CharSequence)StrategySettingType.AUDIT.name())).collect(Collectors.toList());
        ArrayList auditTrees = Lists.newArrayList();
        this.buildItemTrees(auditItems, auditTrees);
        strategySettingManageVo.setAuditSettings((List)auditTrees);
        return strategySettingManageVo;
    }

    @Transactional
    public void enableStatus(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u7b56\u7565\u914d\u7f6eid\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StrategySettingManage strategySettingManage = (StrategySettingManage)((Object)this.strategySettingManageRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)strategySettingManage), (String)"\u6839\u636e\u63d0\u4f9b\u7684\u7b56\u7565\u914d\u7f6e\u4e3b\u952eid\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{id});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)strategySettingManage.getEnableStatus(), (CharSequence)EnableStatusEnum.DISABLE.getCode()), (String)"\u7b56\u7565\u914d\u7f6e\u3010%s\u3011\u5df2\u662f\u4f7f\u7528\u72b6\u6001", (Object[])new Object[]{strategySettingManage.getName()});
        List all = this.strategySettingManageRepository.list();
        Validate.notEmpty((Collection)all, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u4efb\u4f55\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        List<StrategySettingManage> needDisableds = all.stream().filter(e -> !StringUtils.equals((CharSequence)e.getCode(), (CharSequence)strategySettingManage.getCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(needDisableds)) {
            needDisableds.forEach(e -> e.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
            this.strategySettingManageRepository.saveOrUpdateBatch(needDisableds);
        }
        strategySettingManage.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.strategySettingManageRepository.saveOrUpdate((Object)strategySettingManage);
    }

    @Transactional
    public void disabled(Set<String> ids) {
        Validate.notEmpty(ids, (String)"\u7981\u7528\u65f6\uff0c\u7b56\u7565\u914d\u7f6e\u4e3b\u952eid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<StrategySettingManage> strategySettingManages = this.strategySettingManageRepository.findByIds(ids);
        Validate.notEmpty(strategySettingManages, (String)"\u6839\u636e\u6307\u5b9a\u7684\u7b56\u7565\u914d\u7f6e\u4e3b\u952eid\u96c6\u5408\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[0]);
        strategySettingManages.forEach(e -> e.setEnableStatus(EnableStatusEnum.DISABLE.getCode()));
        this.strategySettingManageRepository.saveOrUpdateBatch(strategySettingManages);
    }

    private void createValidation(StrategySettingManageDto settingDto) {
        this.validateBase(settingDto);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)settingDto.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u914d\u7f6e\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        settingDto.setId(null);
        if (StringUtils.isBlank((CharSequence)settingDto.getTenantCode())) {
            settingDto.setTenantCode(TenantUtils.getTenantCode());
        }
        String ruleCode = StringUtils.join((Object[])new String[]{"XLCL", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")});
        List codeList = this.generateCodeService.generateCode(ruleCode, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS);
        Validate.notEmpty((Collection)codeList, (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u751f\u6210\u7b56\u7565\u914d\u7f6e\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        settingDto.setCode((String)codeList.get(0));
        String pattern = "^[A-Z]{1}[A-Z0-9]*$";
        Validate.matchesPattern((CharSequence)settingDto.getCode(), (String)pattern, (String)"\u7f16\u7801\u53ea\u80fd\u662f\u5b57\u6bcd\u548c\u6570\u5b57\u6784\u6210\uff0c\u4e14\u9996\u5b57\u6bcd\u4e0d\u80fd\u662f\u6570\u5b57\uff0c\u6700\u7ec8\u7f16\u7801\u90fd\u5c06\u88ab\u5927\u5199", (Object[])new Object[0]);
        StrategySettingManageVo strategySettingManageVo = this.findByCode(settingDto.getCode());
        Validate.isTrue((strategySettingManageVo == null ? 1 : 0) != 0, (String)"\u7b56\u7565\u914d\u7f6e\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        boolean exist = this.strategySettingManageRepository.existByName(settingDto.getName());
        Validate.isTrue((!exist ? 1 : 0) != 0, (String)"\u7b56\u7565\u914d\u7f6e\u540d\u79f0\u3010%s\u3011\u5df2\u5b58\u5728", (Object[])new Object[]{settingDto.getName()});
    }

    private void updateValidation(StrategySettingManageDto settingDto) {
        this.validateBase(settingDto);
        Validate.notBlank((CharSequence)settingDto.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u7b56\u7565\u914d\u7f6e\u4e3b\u952eid\u5fc5\u987b\u6709\u503c", (Object[])new Object[0]);
        StrategySettingManage setting = this.strategySettingManageRepository.findByName(settingDto.getName());
        Validate.isTrue((setting == null || StringUtils.equals((CharSequence)setting.getName(), (CharSequence)settingDto.getName()) ? 1 : 0) != 0, (String)"\u7b56\u7565\u914d\u7f6e\u540d\u79f0\u3010%s\u3011\u5df2\u5b58\u5728", (Object[])new Object[]{settingDto.getName()});
    }

    private void validateBase(StrategySettingManageDto settingDto) {
        Validate.notNull((Object)settingDto, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)settingDto.getName(), (String)"\u7b56\u7565\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)settingDto.getActivitySettings()) || !CollectionUtils.isEmpty((Collection)settingDto.getAuditSettings()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u6267\u884c\u76f8\u5173\u7684\u7b56\u7565\u4e0e\u6838\u9500\u76f8\u5173\u7684\u7b56\u7565\u4fe1\u606f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void buildItemTrees(List<StrategySettingStruct> items, List<StrategySettingStruct> trees) {
        List tops = items.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(tops)) {
            return;
        }
        for (StrategySettingStruct top : tops) {
            trees.add(top);
            this.buildItemTreeNodes(top, items);
        }
    }

    private void buildItemTreeNodes(StrategySettingStruct current, List<StrategySettingStruct> allItems) {
        if (current == null) {
            return;
        }
        List children = allItems.stream().filter(e -> StringUtils.equals((CharSequence)e.getParentCode(), (CharSequence)current.getCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(children)) {
            current.setChildren(children);
            for (StrategySettingStruct child : current.getChildren()) {
                this.buildItemTreeNodes(child, allItems);
            }
        }
    }

    private void fillSettingManageCode(String settingManageCode, StrategySettingStruct item) {
        item.setSettingManageCode(settingManageCode);
        if (!CollectionUtils.isEmpty((Collection)item.getChildren())) {
            for (StrategySettingStruct child : item.getChildren()) {
                this.fillSettingManageCode(settingManageCode, child);
            }
        }
    }
}

