/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingValueType;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.AbstractStrategySetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.CollectDistributionOrdersSetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.ControlActivityExpensesSetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.SignDisplaySetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStruct;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStructAnalysis;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class StrategySettingStructAnalysisServiceImpl
implements StrategySettingStructAnalysis {
    @Autowired(required=false)
    private List<AbstractStrategySetting> abstractStrategySettings;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public void validateBaseStruct(StrategySettingStruct struct, AbstractStrategySetting setting) {
        Validate.notNull((Object)struct, (String)"\u4f20\u5165\u7684\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)setting, (String)"\u6307\u5b9a\u7684\u7b56\u7565\u9879\u7ed3\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validateBase(struct, setting);
    }

    private void validateBase(StrategySettingStruct struct) {
        Validate.notBlank((CharSequence)struct.getName(), (String)"\u7b56\u7565\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)struct.getCode(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notBlank((CharSequence)struct.getType(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notBlank((CharSequence)struct.getValueType(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notBlank((CharSequence)struct.getSettingManageCode(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notNull((Object)struct.getNecessary(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u5fc5\u9700\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notNull((Object)struct.getDisplay(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        Validate.notNull((Object)struct.getSortIndex(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        if (StringUtils.equals((CharSequence)struct.getValueType(), (CharSequence)StrategySettingValueType.DATE.getCode())) {
            Validate.notBlank((CharSequence)struct.getDateFormat(), (String)"\u7b56\u7565\u9879\u7ed3\u6784\u3010%s\u3011\u65f6\u95f4\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        }
    }

    private void validateBase(StrategySettingStruct struct, AbstractStrategySetting setting) {
        this.validateBase(struct);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getCode(), (CharSequence)setting.getCode()), (String)"\u7b56\u7565\u9879\u7f16\u7801\u3010%s\u3011\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u7f16\u7801\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getCode()});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getName(), (CharSequence)setting.getName()), (String)"\u7b56\u7565\u9879\u540d\u79f0\u3010%s\u3011\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u540d\u79f0\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getName()});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getType(), (CharSequence)setting.getType()), (String)"\u7b56\u7565\u9879\u7c7b\u578b\u3010%s\u3011\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getType()});
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)struct.getValueType(), (CharSequence)setting.getValueType()), (String)"\u7b56\u7565\u9879\u503c\u7c7b\u578b\u3010%s\u3011\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u503c\u7c7b\u578b\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getValueType()});
        Validate.isTrue((boolean)struct.getNecessary().equals(setting.getNecessary()), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5426\u5fc5\u9700\u5c5e\u6027\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u662f\u5426\u5fc5\u9700\u5c5e\u6027\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getName()});
        Validate.isTrue((boolean)struct.getSortIndex().equals(setting.getSortIndex()), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u6392\u5e8f\u503c\u4e0e\u7b56\u7565\u9879\u7ed3\u6784\u6392\u5e8f\u503c\u4e0d\u5339\u914d", (Object[])new Object[]{struct.getName()});
        if (StringUtils.isBlank((CharSequence)struct.getParentCode())) {
            Validate.isTrue((struct.getDisplay() == Boolean.TRUE ? 1 : 0) != 0, (String)"\u6839\u7b56\u7565\u9879\u3010%s\u3011\u5fc5\u9700\u663e\u793a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{struct.getName()});
        }
        if (CollectionUtils.isEmpty((Collection)struct.getChildren())) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)setting.getChildren()) && !CollectionUtils.isEmpty((Collection)struct.getChildren())) {
            long displayCount = struct.getChildren().stream().filter(e -> e.getDisplay() == Boolean.TRUE).count();
            Validate.isTrue((displayCount > 0L ? 1 : 0) != 0, (String)"\u7b56\u7565\u9879\u3010%s\u3011\u7684\u5b50\u8282\u70b9\u5fc5\u9700\u81f3\u5c11\u542b\u6709\u4e00\u4e2a\u663e\u793a\u9879\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{struct.getName()});
            for (StrategySettingStruct childStruct : struct.getChildren()) {
                Validate.notBlank((CharSequence)childStruct.getCode(), (String)"\u7b56\u7565\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)childStruct.getParentCode(), (String)"\u7b56\u7565\u9879\u7f16\u7801\u3010%s\u3011\u7684\u7236\u7ea7\u7f16\u7801\u672a\u6307\u5b9a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{childStruct.getCode()});
                Validate.isTrue((boolean)StringUtils.equals((CharSequence)childStruct.getParentCode(), (CharSequence)struct.getCode()), (String)"\u6307\u5b9a\u7684\u7b56\u7565\u9879\u3010%s\u3011\u7236\u7ea7\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{childStruct.getCode()});
                AbstractStrategySetting childSetting = setting.getChildren().stream().filter(e -> StringUtils.equals((CharSequence)childStruct.getCode(), (CharSequence)e.getCode())).findFirst().orElse(null);
                Validate.notNull((Object)childSetting, (String)"\u6839\u636e\u6307\u5b9a\u7684\u7b56\u7565\u9879\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u7ed3\u6784\u4fe1\u606f", (Object[])new Object[]{childStruct.getCode()});
                this.validateBase(childStruct, childSetting);
            }
        }
    }

    public StrategySettingStruct transferToStruct(AbstractStrategySetting setting) {
        if (setting == null) {
            return null;
        }
        StrategySettingStruct struct = (StrategySettingStruct)this.nebulaToolkitService.copyObjectByWhiteList((Object)setting, StrategySettingStruct.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty((Collection)setting.getChildren())) {
            return struct;
        }
        ArrayList children = Lists.newArrayList();
        struct.setDefaultValue(setting.getDefaultValue());
        struct.setChildren((List)children);
        for (AbstractStrategySetting child : setting.getChildren()) {
            children.add(this.transferToStruct(child));
        }
        return struct;
    }

    public void validateValue(StrategySettingStruct struct) {
        Validate.notNull((Object)struct, (String)"\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.validateBase(struct);
        boolean display = struct.getDisplay() == null ? Boolean.FALSE : struct.getDisplay();
        if (struct.getValue() == null || !display) {
            struct.setValue(this.getDefaultValue(struct.getCode()));
        }
        if (struct.getNecessary().booleanValue() && display) {
            Validate.notNull((Object)struct.getValue(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u662f\u5fc5\u9700\u5c5e\u6027\uff0c\u5176\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{struct.getName()});
        }
        if (struct.getValue() != null) {
            this.validateValueType(struct);
        }
        if (!CollectionUtils.isEmpty((Collection)struct.getChildren())) {
            for (StrategySettingStruct child : struct.getChildren()) {
                this.validateValue(child);
            }
        }
    }

    public Object getDefaultValue(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        AbstractStrategySetting abstractStrategySetting = this.abstractStrategySettings.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)code)).findFirst().orElse(null);
        if (abstractStrategySetting == null) {
            return null;
        }
        return abstractStrategySetting.getDefaultValue();
    }

    public void validateDisplaySpecialForStruct(StrategySettingStruct struct, List<StrategySettingStruct> specialStructs) {
        if (struct == null) {
            return;
        }
        Validate.notEmpty(specialStructs, (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u6307\u5b9a\u7684\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)struct.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())) {
            boolean matched = specialStructs.stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)CollectDistributionOrdersSetting.class.getSimpleName()) || StringUtils.equals((CharSequence)e.getCode(), (CharSequence)SignDisplaySetting.class.getSimpleName()));
            Validate.isTrue((boolean)matched, (String)"\u9a8c\u8bc1\u662f\u5426\u663e\u793a\u65f6\uff0c\u5982\u679c\u7b56\u7565\u9879\u3010%s\u3011\u5b58\u5728\uff0c\u3010\u662f\u5426\u7b7e\u7f72\u9648\u5217\u534f\u8bae\u3011\u548c\u3010\u662f\u5426\u91c7\u96c6\u5206\u9500\u8ba2\u5355\u3011\u4e0d\u80fd\u540c\u65f6\u9690\u85cf", (Object[])new Object[]{struct.getName()});
        }
    }

    public Object transferValue(String value, String valueType) {
        StrategySettingValueType strategySettingValueType = StrategySettingValueType.findByCode((String)valueType);
        Validate.notNull((Object)strategySettingValueType, (String)"\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{valueType});
        switch (strategySettingValueType) {
            case STRING: 
            case OBJECT: 
            case DATE: 
            case ARRAY: {
                return value;
            }
            case NUMBER: {
                return NumberUtils.createNumber((String)value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
    }

    public List<StrategySettingStruct> structTree(List<StrategySettingStruct> trees, List<StrategySettingStruct> sourceStructs, StrategySettingStruct currentStruct) {
        if (CollectionUtils.isEmpty(sourceStructs) || currentStruct == null) {
            return trees;
        }
        if (StringUtils.isBlank((CharSequence)currentStruct.getParentCode())) {
            trees.add(currentStruct);
        }
        String parentCode = currentStruct.getCode();
        List children = sourceStructs.stream().filter(e -> StringUtils.equals((CharSequence)e.getParentCode(), (CharSequence)parentCode)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(children)) {
            currentStruct.setChildren(children);
            for (StrategySettingStruct child : children) {
                this.structTree(trees, sourceStructs, child);
            }
        }
        return trees;
    }

    private void validateValueType(StrategySettingStruct struct) {
        Object value = struct.getValue();
        Validate.notNull((Object)value, (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
        StrategySettingValueType valueType = StrategySettingValueType.findByCode((String)struct.getValueType());
        Validate.notNull((Object)valueType, (String)"\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{struct.getValueType()});
        switch (valueType) {
            case STRING: {
                Validate.notBlank((CharSequence)value.toString(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
                break;
            }
            case OBJECT: {
                break;
            }
            case DATE: {
                Validate.notBlank((CharSequence)struct.getDateFormat(), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u65e5\u671f\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{struct.getName()});
                SimpleDateFormat sdf = new SimpleDateFormat(struct.getDateFormat());
                try {
                    sdf.parse(value.toString());
                    break;
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("\u7b56\u7565\u9879" + struct.getName() + "\u7684\u503c\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65e5\u671f\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
                }
            }
            case NUMBER: {
                Validate.isTrue((boolean)NumberUtils.isParsable((String)value.toString()), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u4fe1\u606f\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{struct.getName()});
                break;
            }
            case ARRAY: {
                try {
                    JSONArray.parseArray((String)value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("\u7b56\u7565\u9879" + struct.getName() + "\u7684\u503c\u4e0d\u80fd\u8f6c\u6362\u4e3a\u6570\u7ec4\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
                }
            }
            case BOOLEAN: {
                Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)value.toString(), (CharSequence[])new CharSequence[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}), (String)"\u7b56\u7565\u9879\u3010%s\u3011\u503c\u4fe1\u606f\u4e0d\u662f\u5e03\u5c14\u7c7b\u578b", (Object[])new Object[]{struct.getName()});
                break;
            }
            default: {
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
            }
        }
    }
}

