/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.budget.local.entity.StrategySetting;
import com.biz.crm.tpm.business.budget.local.repository.StrategySettingRepository;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingValueType;
import com.biz.crm.tpm.business.budget.sdk.service.StrategySettingVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.AbstractStrategySetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.ControlActivityExpensesSetting;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStruct;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.StrategySettingStructAnalysis;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StrategySettingVoServiceImpl
implements StrategySettingVoService {
    @Autowired
    private StrategySettingRepository strategySettingRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private StrategySettingStructAnalysis strategySettingStructAnalysis;
    @Autowired(required=false)
    private List<AbstractStrategySetting> abstractStrategySettings;

    public List<StrategySettingStruct> findBySettingManageCode(String settingManageCode) {
        if (StringUtils.isBlank((CharSequence)settingManageCode)) {
            return Lists.newArrayList();
        }
        List<StrategySetting> items = this.strategySettingRepository.findBySettingManageCode(settingManageCode);
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        for (StrategySetting setting : items) {
            StrategySettingStruct struct = new StrategySettingStruct();
            struct.setId(setting.getId());
            struct.setCode(setting.getCode());
            struct.setDefaultValue(StringUtils.isBlank((CharSequence)setting.getDefaultValue()) ? null : this.transferDefaultValue(setting));
            struct.setDateFormat(setting.getDateFormat());
            struct.setName(setting.getName());
            struct.setNecessary(setting.getNecessary());
            struct.setParentCode(setting.getParentCode());
            struct.setSortIndex(setting.getSortIndex());
            struct.setTip(setting.getTip());
            struct.setType(setting.getType());
            struct.setValueType(setting.getValueType());
            struct.setDisplay(setting.getDisplay());
            struct.setSettingManageCode(setting.getSettingManageCode());
            result.add(struct);
        }
        return result;
    }

    @Transactional
    public void create(List<StrategySettingStruct> items) {
        List<StrategySettingStruct> datas = this.createValidation(items);
        ArrayList entities = Lists.newArrayList();
        for (StrategySettingStruct data : datas) {
            StrategySetting item = new StrategySetting();
            item.setSettingManageCode(data.getSettingManageCode());
            item.setParentCode(data.getParentCode());
            item.setCode(data.getCode());
            item.setName(data.getName());
            item.setDisplay(data.getDisplay());
            item.setTip(data.getTip());
            item.setDefaultValue(data.getDefaultValue() == null ? null : data.getDefaultValue().toString());
            item.setDateFormat(data.getDateFormat());
            item.setNecessary(data.getNecessary());
            item.setSortIndex(data.getSortIndex());
            item.setType(data.getType());
            item.setValueType(data.getValueType());
            entities.add(item);
        }
        StrategySettingStruct controlActivityExpensesSetting = datas.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())).findFirst().orElse(null);
        this.strategySettingStructAnalysis.validateDisplaySpecialForStruct(controlActivityExpensesSetting, datas);
        this.strategySettingRepository.saveBatch(entities);
        datas.forEach(e -> entities.stream().filter(entity -> StringUtils.equals((CharSequence)entity.getCode(), (CharSequence)e.getCode())).findFirst().ifPresent(data -> e.setId(data.getId())));
    }

    @Transactional
    public void update(List<StrategySettingStruct> items) {
        List<StrategySettingStruct> needAdds;
        Sets.SetView needUpdates;
        List<StrategySettingStruct> datas = this.updateValidation(items);
        Set settingManageCodes = datas.stream().map(StrategySettingStruct::getSettingManageCode).collect(Collectors.toSet());
        Validate.notEmpty(settingManageCodes, (String)"\u66f4\u65b0\u65f6\uff0c\u7b56\u7565\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((settingManageCodes.size() == 1 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u65f6\uff0c\u7b56\u7565\u914d\u7f6e\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        StrategySettingStruct controlActivityExpensesSetting = datas.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)ControlActivityExpensesSetting.class.getSimpleName())).findFirst().orElse(null);
        this.strategySettingStructAnalysis.validateDisplaySpecialForStruct(controlActivityExpensesSetting, datas);
        List<StrategySetting> dbItems = this.strategySettingRepository.findBySettingManageCode((String)settingManageCodes.iterator().next());
        Set dbIds = dbItems.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        Set ids = datas.stream().map(UuidVo::getId).collect(Collectors.toSet());
        Sets.SetView needDeletes = Sets.difference(dbIds, ids);
        if (!CollectionUtils.isEmpty((Collection)needDeletes)) {
            this.strategySettingRepository.removeByIds((Collection)needDeletes);
        }
        if (!CollectionUtils.isEmpty((Collection)(needUpdates = Sets.intersection(dbIds, ids)))) {
            List currentDbItems = dbItems.stream().filter(arg_0 -> StrategySettingVoServiceImpl.lambda$update$5((Set)needUpdates, arg_0)).collect(Collectors.toList());
            List currentItemDtos = datas.stream().filter(arg_0 -> StrategySettingVoServiceImpl.lambda$update$6((Set)needUpdates, arg_0)).collect(Collectors.toList());
            block0: for (StrategySetting item : currentDbItems) {
                for (StrategySettingStruct dto : currentItemDtos) {
                    if (!StringUtils.equals((CharSequence)item.getId(), (CharSequence)dto.getId())) continue;
                    item.setCode(dto.getCode());
                    item.setName(dto.getName());
                    item.setDisplay(dto.getDisplay());
                    item.setTip(dto.getTip());
                    item.setDefaultValue(dto.getDefaultValue() == null ? null : dto.getDefaultValue().toString());
                    item.setDateFormat(dto.getDateFormat());
                    item.setNecessary(dto.getNecessary());
                    item.setSortIndex(dto.getSortIndex());
                    item.setType(dto.getType());
                    item.setValueType(dto.getValueType());
                    continue block0;
                }
            }
            this.strategySettingRepository.saveOrUpdateBatch(currentDbItems);
        }
        if (!CollectionUtils.isEmpty(needAdds = items.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toList()))) {
            this.create(needAdds);
        }
    }

    private List<StrategySettingStruct> createValidation(List<StrategySettingStruct> items) {
        List<StrategySettingStruct> flatItems = this.validateBase(items);
        for (StrategySettingStruct item : flatItems) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)item.getId()), (String)"\u65b0\u589e\u65f6\uff0c\u7b56\u7565\u9879\u4e3b\u952eid\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getSettingManageCode(), (String)"\u7b56\u7565\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (item.getDisplay() != null) continue;
            item.setDisplay(Boolean.FALSE);
        }
        return flatItems;
    }

    private List<StrategySettingStruct> updateValidation(List<StrategySettingStruct> items) {
        return this.validateBase(items);
    }

    private void buildFlatItems(StrategySettingStruct struct, List<StrategySettingStruct> flatItems) {
        flatItems.add(struct);
        if (CollectionUtils.isEmpty((Collection)struct.getChildren())) {
            return;
        }
        for (StrategySettingStruct child : struct.getChildren()) {
            this.buildFlatItems(child, flatItems);
        }
    }

    private List<StrategySettingStruct> validateBase(List<StrategySettingStruct> items) {
        Validate.notEmpty(items, (String)"\u7b56\u7565\u9879\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty(this.abstractStrategySettings, (String)"\u7b56\u7565\u9879\u914d\u7f6e\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List tops = items.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getParentCode())).collect(Collectors.toList());
        Validate.notEmpty(tops, (String)"\u4e0d\u5b58\u5728\u7b56\u7565\u9879\u6839\u8282\u70b9\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        ArrayList flatItems = Lists.newArrayList();
        for (StrategySettingStruct top : tops) {
            String code = top.getCode();
            Validate.notBlank((CharSequence)code, (String)"\u7b56\u7565\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AbstractStrategySetting abstractStrategySetting = this.abstractStrategySettings.stream().filter(e -> StringUtils.equals((CharSequence)e.getCode(), (CharSequence)code)).findFirst().orElse(null);
            Validate.notNull((Object)abstractStrategySetting, (String)"\u6839\u636e\u7b56\u7565\u9879\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u7b56\u7565", (Object[])new Object[]{code});
            this.strategySettingStructAnalysis.validateBaseStruct(top, abstractStrategySetting);
            this.buildFlatItems(top, flatItems);
        }
        return flatItems;
    }

    private Object transferDefaultValue(StrategySetting setting) {
        StrategySettingValueType valueType = StrategySettingValueType.findByCode((String)setting.getValueType());
        Validate.notNull((Object)valueType, (String)"\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{setting.getValueType()});
        switch (valueType) {
            case STRING: 
            case OBJECT: 
            case DATE: 
            case ARRAY: {
                return setting.getDefaultValue();
            }
            case NUMBER: {
                return NumberUtils.createNumber((String)setting.getDefaultValue());
            }
            case BOOLEAN: {
                return Boolean.valueOf(setting.getDefaultValue());
            }
        }
        throw new IllegalArgumentException("\u672a\u77e5\u7684\u7b56\u7565\u9879\u503c\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
    }

    private static /* synthetic */ boolean lambda$update$6(Set needUpdates, StrategySettingStruct e) {
        return needUpdates.contains(e.getId());
    }

    private static /* synthetic */ boolean lambda$update$5(Set needUpdates, StrategySetting e) {
        return needUpdates.contains(e.getId());
    }
}

