/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.strategy.controltype;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.strategy.controltype.AbstractBudgetControlTypeStrategy;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetItemDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetOperateType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetItemVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetItemVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class MonthControlTypeStrategy
extends AbstractBudgetControlTypeStrategy {
    private static final Logger log = LoggerFactory.getLogger(MonthControlTypeStrategy.class);
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private CostBudgetItemVoService costBudgetItemVoService;
    @Autowired
    private RedisMutexService redisMutexService;

    public String getCode() {
        return "MONTH";
    }

    public String getName() {
        return "\u6708\u4efd";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)source, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u4f7f\u7528\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)source), (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{source});
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock("BUDGET_GLOBAL_REDIS_LOCK_KEY", TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(costBudgetCode);
            Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getEnableStatus(), (CharSequence)EnableStatusEnum.ENABLE.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u7981\u7528\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            List itemVos = this.costBudgetItemVoService.findByCostBudgetCode(costBudgetCode);
            Validate.notNull((Object)itemVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u9879\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            CostBudgetItemVo item = itemVos.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)item, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((item.getFinalBalance().compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            CostBudgetItemDto itemDto = new CostBudgetItemDto();
            itemDto.setOperateType(CostBudgetOperateType.USED.getCode());
            itemDto.setBalance(item.getFinalBalance());
            itemDto.setCostBudgetCode(costBudgetCode);
            itemDto.setFinalBalance(item.getFinalBalance().subtract(operateAmount));
            itemDto.setOperateAmount(operateAmount);
            itemDto.setTenantCode(costBudgetVo.getTenantCode());
            itemDto.setBusinessCode(businessCode);
            itemDto.setBusinessItemCode(businessItemCode);
            itemDto.setItemRemark(itemRemark);
            itemDto.setSource(source);
            this.costBudgetItemVoService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock("BUDGET_GLOBAL_REDIS_LOCK_KEY");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverse(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)source, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)source), (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{source});
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock("BUDGET_GLOBAL_REDIS_LOCK_KEY", TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(costBudgetCode);
            Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getEnableStatus(), (CharSequence)EnableStatusEnum.ENABLE.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u7981\u7528\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            List itemVos = this.costBudgetItemVoService.findByCostBudgetCode(costBudgetCode);
            Validate.notNull((Object)itemVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u9879\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            CostBudgetItemVo item = itemVos.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
            Validate.notNull((Object)item, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u9879\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List itemBusinessVos = this.costBudgetItemVoService.findByBusinessCodeAndBusinessItemCode(businessCode, businessItemCode);
            if (CollectionUtils.isEmpty((Collection)itemBusinessVos)) {
                Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)source), (String)"\u8be5\u64cd\u4f5c\u6ca1\u6709\u6838\u9500\u5dee\u989d\u9000\u56de\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            } else {
                Validate.notEmpty((Collection)itemBusinessVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u660e\u7ec6\u9879\u4fe1\u606f", (Object[])new Object[]{businessItemCode});
                CostBudgetItemVo newestItem = itemBusinessVos.stream().filter(e -> StringUtils.equals((CharSequence)e.getOperateType(), (CharSequence)CostBudgetOperateType.USED.getCode())).max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
                Validate.notNull((Object)newestItem, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\uff0c\u6700\u65b0\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{businessItemCode});
                Validate.isTrue((newestItem.getOperateAmount().compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u56de\u9000\u91d1\u989d\u3010%s\u3011\u4e0d\u80fd\u8d85\u51fa\u8be5\u4e1a\u52a1\u660e\u7ec6\u7684\u5360\u7528\u91d1\u989d\u3010%s\u3011", (Object[])new Object[]{operateAmount.toString(), newestItem.getOperateAmount().toString()});
            }
            CostBudgetItemDto itemDto = new CostBudgetItemDto();
            itemDto.setOperateType(CostBudgetOperateType.BACK.getCode());
            itemDto.setBalance(item.getFinalBalance());
            itemDto.setCostBudgetCode(costBudgetCode);
            itemDto.setFinalBalance(item.getFinalBalance().add(operateAmount));
            itemDto.setOperateAmount(operateAmount);
            itemDto.setTenantCode(costBudgetVo.getTenantCode());
            itemDto.setBusinessCode(businessCode);
            itemDto.setBusinessItemCode(businessItemCode);
            itemDto.setItemRemark(itemRemark);
            itemDto.setSource(source);
            this.costBudgetItemVoService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock("BUDGET_GLOBAL_REDIS_LOCK_KEY");
            }
        }
    }

    public int getOrder() {
        return 2;
    }
}

