/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.local.strategy.controltype;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.budget.local.strategy.controltype.AbstractBudgetControlTypeStrategy;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetDto;
import com.biz.crm.tpm.business.budget.sdk.dto.CostBudgetItemDto;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetItemSourceType;
import com.biz.crm.tpm.business.budget.sdk.enums.CostBudgetOperateType;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetItemVoService;
import com.biz.crm.tpm.business.budget.sdk.service.CostBudgetVoService;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetItemVo;
import com.biz.crm.tpm.business.budget.sdk.vo.CostBudgetVo;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class YearControlTypeStrategy
extends AbstractBudgetControlTypeStrategy {
    private static final Logger log = LoggerFactory.getLogger(YearControlTypeStrategy.class);
    @Autowired
    private CostBudgetVoService costBudgetVoService;
    @Autowired
    private CostBudgetItemVoService costBudgetItemVoService;
    @Autowired
    private RedisMutexService redisMutexService;

    public String getCode() {
        return "YEAR";
    }

    public String getName() {
        return "\u5168\u5e74";
    }

    public int getOrder() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)source, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)source), (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{source});
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u4f7f\u7528\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock("BUDGET_GLOBAL_REDIS_LOCK_KEY", TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(costBudgetCode);
            Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getEnableStatus(), (CharSequence)EnableStatusEnum.ENABLE.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u7981\u7528\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            CostBudgetDto costBudgetDto = new CostBudgetDto();
            costBudgetDto.setType(costBudgetVo.getType());
            costBudgetDto.setYear(costBudgetVo.getYear());
            costBudgetDto.setOrgCode(costBudgetVo.getOrgCode());
            costBudgetDto.setCustomerCode(costBudgetVo.getCustomerCode());
            costBudgetDto.setChannelCode(costBudgetVo.getChannelCode());
            costBudgetDto.setTerminalCode(costBudgetVo.getTerminalCode());
            costBudgetDto.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
            costBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            costBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List costBudgetVos = this.costBudgetVoService.findByConditions(costBudgetDto);
            Validate.notEmpty((Collection)costBudgetVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u83b7\u53d6\u5230\u540c\u5e74\u5ea6\uff0c\u540c\u7c7b\u578b\uff0c\u4e14\u6709\u6548\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
            List effectiveCostBudgetCodes = costBudgetVos.stream().map(CostBudgetVo::getCode).collect(Collectors.toList());
            Map itemsMap = this.costBudgetItemVoService.findByCostBudgetCodes(effectiveCostBudgetCodes);
            Validate.notEmpty((Map)itemsMap, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u83b7\u53d6\u5230\u540c\u5e74\u5ea6\uff0c\u540c\u7c7b\u578b\uff0c\u4e14\u6709\u6548\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
            List<Object> processDatas = Lists.newArrayList();
            BigDecimal totalFinalBalance = BigDecimal.ZERO;
            for (Map.Entry entry : itemsMap.entrySet()) {
                CostBudgetItemVo newestItem = ((List)entry.getValue()).stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
                Validate.notNull((Object)newestItem, (String)"\u8d39\u7528\u9884\u7b97\u3010%s\u3011\uff0c\u6ca1\u6709\u76f8\u5173\u8d39\u7528\u9884\u7b97\u660e\u7ec6\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{entry.getKey()});
                if (newestItem.getFinalBalance().compareTo(BigDecimal.ZERO) <= 0) continue;
                ProcessData processData = new ProcessData(newestItem.getFinalBalance(), newestItem.getCostBudgetCode(), this.buildSortKey(newestItem.getYear(), newestItem.getQuarter(), newestItem.getMonth()));
                processDatas.add(processData);
                totalFinalBalance = totalFinalBalance.add(newestItem.getFinalBalance());
            }
            Validate.notEmpty((Collection)processDatas, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u53d1\u73b0\u540c\u5e74\u5ea6\uff0c\u540c\u7c7b\u578b\u7684\u8d39\u7528\u9884\u7b97\u53ef\u7528\u4f59\u989d\u5df2\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((totalFinalBalance.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u3010%d\u3011\u5e74\u5ea6\u7684\u8d39\u7528\u9884\u7b97\u53ef\u7528\u4f59\u989d\u4e3a0\uff0c\u4e0d\u80fd\u8fdb\u884c\u8d39\u7528\u7533\u8bf7", (long)costBudgetVo.getYear().intValue());
            Validate.isTrue((totalFinalBalance.compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u8d39\u7528\u7533\u8bf7\u91d1\u989d\u3010%s\u3011\uff0c\u3010%d\u3011\u5e74\u5ea6\u7684\u603b\u8d39\u7528\u9884\u7b97\u53ef\u7528\u4f59\u989d\u3010%s\u3011\u4e0d\u8db3", (Object[])new Object[]{operateAmount.toString(), costBudgetVo.getYear(), totalFinalBalance.toString()});
            processDatas = processDatas.stream().sorted(Comparator.comparing(ProcessData::getSortKey)).collect(Collectors.toList());
            this.processForward(processDatas, costBudgetCode, businessCode, businessItemCode, operateAmount, itemRemark, source, this.buildSortKey(costBudgetVo.getYear(), costBudgetVo.getQuarter(), costBudgetVo.getMonth()));
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock("BUDGET_GLOBAL_REDIS_LOCK_KEY");
            }
        }
    }

    private BigDecimal processCostBudgetItems(List<ProcessData> items, BigDecimal operateAmount, String businessCode, String businessItemCode, String itemRemark, String source) {
        BigDecimal amount = operateAmount;
        for (ProcessData item : items) {
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            if (item.getFinalBalance().compareTo(amount) >= 0) {
                this.processCostBudgetItem(item, amount, businessCode, businessItemCode, itemRemark, source);
                return BigDecimal.ZERO;
            }
            this.processCostBudgetItem(item, item.getFinalBalance(), businessCode, businessItemCode, itemRemark, source);
            amount = amount.subtract(item.getFinalBalance());
        }
        return amount;
    }

    private BigDecimal processCostBudgetItemsReverse(List<ProcessData> items, BigDecimal operateAmount, String businessCode, String businessItemCode, String itemRemark, String source) {
        BigDecimal amount = operateAmount;
        for (ProcessData item : items) {
            if (amount.compareTo(BigDecimal.ZERO) == 0) {
                return amount;
            }
            if (item.getCurrentOperateAmount().compareTo(amount) >= 0) {
                this.processCostBudgetItemReverse(item, amount, businessCode, businessItemCode, itemRemark, source);
                return BigDecimal.ZERO;
            }
            this.processCostBudgetItemReverse(item, item.getCurrentOperateAmount(), businessCode, businessItemCode, itemRemark, source);
            amount = amount.subtract(item.getCurrentOperateAmount());
        }
        return amount;
    }

    private void processCostBudgetItem(ProcessData item, BigDecimal operateAmount, String businessCode, String businessItemCode, String itemRemark, String source) {
        CostBudgetItemDto itemDto = new CostBudgetItemDto();
        itemDto.setOperateType(CostBudgetOperateType.USED.getCode());
        itemDto.setBalance(item.getFinalBalance());
        itemDto.setCostBudgetCode(item.getCostBudgetCode());
        itemDto.setFinalBalance(item.getFinalBalance().subtract(operateAmount));
        itemDto.setOperateAmount(operateAmount);
        itemDto.setTenantCode(TenantUtils.getTenantCode());
        itemDto.setBusinessCode(businessCode);
        itemDto.setBusinessItemCode(businessItemCode);
        itemDto.setItemRemark(itemRemark);
        itemDto.setSource(source);
        this.costBudgetItemVoService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
    }

    private void processCostBudgetItemReverse(ProcessData item, BigDecimal operateAmount, String businessCode, String businessItemCode, String itemRemark, String source) {
        CostBudgetItemDto itemDto = new CostBudgetItemDto();
        itemDto.setOperateType(CostBudgetOperateType.BACK.getCode());
        itemDto.setBalance(item.getFinalBalance());
        itemDto.setCostBudgetCode(item.getCostBudgetCode());
        itemDto.setFinalBalance(item.getFinalBalance().add(operateAmount));
        itemDto.setOperateAmount(operateAmount);
        itemDto.setTenantCode(TenantUtils.getTenantCode());
        itemDto.setBusinessCode(businessCode);
        itemDto.setBusinessItemCode(businessItemCode);
        itemDto.setItemRemark(itemRemark);
        itemDto.setSource(source);
        this.costBudgetItemVoService.create((List)Lists.newArrayList((Object[])new CostBudgetItemDto[]{itemDto}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reverse(String businessCode, String businessItemCode, String costBudgetCode, BigDecimal operateAmount, String itemRemark, String source) {
        Validate.notBlank((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessItemCode, (String)"\u4e1a\u52a1\u660e\u7ec6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)costBudgetCode, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)source, (String)"\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)operateAmount, (String)"\u64cd\u4f5c\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CostBudgetItemSourceType.contains((String)source), (String)"\u672a\u77e5\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6765\u6e90\u3010%s\u3011\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{source});
        Validate.isTrue((operateAmount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        boolean hasLock = false;
        try {
            hasLock = this.redisMutexService.tryLock("BUDGET_GLOBAL_REDIS_LOCK_KEY", TimeUnit.SECONDS, MAX_TIMES.intValue());
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7f51\u7edc\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            CostBudgetVo costBudgetVo = this.costBudgetVoService.findByCode(costBudgetCode);
            Validate.notNull((Object)costBudgetVo, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u4fe1\u606f", (Object[])new Object[]{costBudgetCode});
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getDelFlag(), (CharSequence)DelFlagStatusEnum.NORMAL.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u5220\u9664\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)costBudgetVo.getEnableStatus(), (CharSequence)EnableStatusEnum.ENABLE.getCode()), (String)"\u4e0d\u80fd\u5bf9\u3010\u5df2\u7981\u7528\u3011\u8d39\u7528\u9884\u7b97\u8fdb\u884c\u64cd\u4f5c", (Object[])new Object[0]);
            CostBudgetDto costBudgetDto = new CostBudgetDto();
            costBudgetDto.setType(costBudgetVo.getType());
            costBudgetDto.setYear(costBudgetVo.getYear());
            costBudgetDto.setOrgCode(costBudgetVo.getOrgCode());
            costBudgetDto.setCustomerCode(costBudgetVo.getCustomerCode());
            costBudgetDto.setChannelCode(costBudgetVo.getChannelCode());
            costBudgetDto.setTerminalCode(costBudgetVo.getTerminalCode());
            costBudgetDto.setBudgetSubjectCode(costBudgetVo.getBudgetSubjectCode());
            costBudgetDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            costBudgetDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            List costBudgetVos = this.costBudgetVoService.findByConditions(costBudgetDto);
            Validate.notEmpty((Collection)costBudgetVos, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u83b7\u53d6\u5230\u540c\u5e74\u5ea6\uff0c\u540c\u7c7b\u578b\uff0c\u4e14\u6709\u6548\u7684\u8d39\u7528\u9884\u7b97\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
            List effectiveCostBudgetCodes = costBudgetVos.stream().map(CostBudgetVo::getCode).collect(Collectors.toList());
            Map itemsMap = this.costBudgetItemVoService.findByCostBudgetCodes(effectiveCostBudgetCodes);
            Validate.notEmpty((Map)itemsMap, (String)"\u6839\u636e\u6307\u5b9a\u7684\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u83b7\u53d6\u5230\u540c\u5e74\u5ea6\uff0c\u540c\u7c7b\u578b\uff0c\u4e14\u6709\u6548\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
            List<Object> processDatas = Lists.newArrayList();
            for (Map.Entry entry : itemsMap.entrySet()) {
                boolean hasBusinessData = ((List)entry.getValue()).stream().anyMatch(e -> StringUtils.equals((CharSequence)e.getBusinessItemCode(), (CharSequence)businessItemCode));
                if (!hasBusinessData) continue;
                CostBudgetItemVo newestItem = ((List)entry.getValue()).stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
                Validate.notNull((Object)newestItem, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u4e0d\u5b58\u5728\u6700\u65b0\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{entry.getKey()});
                CostBudgetItemVo effectiveItem = ((List)entry.getValue()).stream().filter(e -> StringUtils.equals((CharSequence)e.getBusinessItemCode(), (CharSequence)businessItemCode) && e.getOperateType().equals(CostBudgetOperateType.USED.getCode())).max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
                Validate.notNull((Object)effectiveItem, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u4e0d\u5b58\u5728\u4e1a\u52a1\u660e\u7ec6\u7f16\u7801\u4e3a\u3010%s\u3011\u3010\u5df2\u4f7f\u7528\u3011\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{entry.getKey(), businessItemCode});
                ProcessData processData = new ProcessData(newestItem.getFinalBalance(), (String)entry.getKey(), this.buildSortKey(effectiveItem.getYear(), effectiveItem.getQuarter(), effectiveItem.getMonth()), effectiveItem.getOperateAmount());
                processDatas.add(processData);
            }
            if (!CollectionUtils.isEmpty((Collection)processDatas)) {
                processDatas = processDatas.stream().sorted(Comparator.comparing(ProcessData::getSortKey).reversed()).collect(Collectors.toList());
                this.processReverse((List<ProcessData>)processDatas, costBudgetCode, businessCode, businessItemCode, operateAmount, itemRemark, source, this.buildSortKey(costBudgetVo.getYear(), costBudgetVo.getQuarter(), costBudgetVo.getMonth()));
            } else {
                List costBudgetItemVos = (List)itemsMap.get(costBudgetCode);
                CostBudgetItemVo newestItem = costBudgetItemVos.stream().max(Comparator.comparing(CostBudgetItemVo::getSortIndex)).orElse(null);
                Validate.notNull((Object)newestItem, (String)"\u8d39\u7528\u9884\u7b97\u7f16\u7801\u3010%s\u3011\uff0c\u4e0d\u5b58\u5728\u6700\u65b0\u7684\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costBudgetCode});
                ProcessData processData = new ProcessData(newestItem.getFinalBalance(), costBudgetCode, this.buildSortKey(costBudgetVo.getYear(), costBudgetVo.getQuarter(), costBudgetVo.getMonth()), operateAmount);
                this.processCostBudgetItemReverse(processData, operateAmount, businessCode, businessItemCode, itemRemark, source);
            }
        }
        finally {
            if (hasLock) {
                this.redisMutexService.unlock("BUDGET_GLOBAL_REDIS_LOCK_KEY");
            }
        }
    }

    private String buildSortKey(Integer year, Integer quarter, Integer month) {
        if (month >= 10) {
            return StringUtils.join((Object[])new Integer[]{year, quarter, month});
        }
        return StringUtils.join((Object[])new Serializable[]{year, quarter, "0", month});
    }

    private void processForward(List<ProcessData> processDatas, String costBudgetCode, String businessCode, String businessItemCode, BigDecimal operateAmount, String itemRemark, String source, String time) {
        List<ProcessData> afterCurrentMonthProcessDatas;
        ProcessData currentMonthProcessData = processDatas.stream().filter(e -> StringUtils.equals((CharSequence)costBudgetCode, (CharSequence)e.getCostBudgetCode())).findFirst().orElse(null);
        if (currentMonthProcessData != null) {
            if (currentMonthProcessData.getFinalBalance().compareTo(operateAmount) >= 0) {
                this.processCostBudgetItem(currentMonthProcessData, operateAmount, businessCode, businessItemCode, itemRemark, source);
                return;
            }
            this.processCostBudgetItem(currentMonthProcessData, currentMonthProcessData.getFinalBalance(), businessCode, businessItemCode, itemRemark, source);
            operateAmount = operateAmount.subtract(currentMonthProcessData.getFinalBalance());
        }
        if (!CollectionUtils.isEmpty(afterCurrentMonthProcessDatas = processDatas.stream().filter(e -> StringUtils.compare((String)e.getSortKey(), (String)time) > 0).collect(Collectors.toList())) && (operateAmount = this.processCostBudgetItems(afterCurrentMonthProcessDatas, operateAmount, businessCode, businessItemCode, itemRemark, source)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        List<ProcessData> beforeCurrentMonthProcessDatas = processDatas.stream().filter(e -> StringUtils.compare((String)e.getSortKey(), (String)time) < 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(beforeCurrentMonthProcessDatas)) {
            Validate.isTrue(((operateAmount = this.processCostBudgetItems(beforeCurrentMonthProcessDatas, operateAmount, businessCode, businessItemCode, itemRemark, source)).compareTo(BigDecimal.ZERO) == 0 ? 1 : 0) != 0, (String)"\u6267\u884c\u9884\u7b97\u8d39\u7528\u6263\u51cf\u65f6\uff0c\u53d1\u73b0\u672c\u5e74\u5ea6\u53ef\u7528\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        }
    }

    private void processReverse(List<ProcessData> processDatas, String costBudgetCode, String businessCode, String businessItemCode, BigDecimal operateAmount, String itemRemark, String source, String time) {
        List<ProcessData> beforeCurrentMonthProcessDatas = processDatas.stream().filter(e -> StringUtils.compare((String)e.getSortKey(), (String)time) < 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(beforeCurrentMonthProcessDatas) && (operateAmount = this.processCostBudgetItemsReverse(beforeCurrentMonthProcessDatas, operateAmount, businessCode, businessItemCode, itemRemark, source)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        List<ProcessData> afterCurrentMonthProcessDatas = processDatas.stream().filter(e -> StringUtils.compare((String)e.getSortKey(), (String)time) > 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(afterCurrentMonthProcessDatas) && (operateAmount = this.processCostBudgetItemsReverse(afterCurrentMonthProcessDatas, operateAmount, businessCode, businessItemCode, itemRemark, source)).compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        ProcessData currentMonthProcessData = processDatas.stream().filter(e -> StringUtils.equals((CharSequence)costBudgetCode, (CharSequence)e.getCostBudgetCode())).findFirst().orElse(null);
        if (currentMonthProcessData != null) {
            Validate.isTrue((currentMonthProcessData.getCurrentOperateAmount().compareTo(operateAmount) >= 0 ? 1 : 0) != 0, (String)"\u672c\u5e74\u5ea6\u5f53\u524d\u8d39\u7528\u9884\u7b97\u660e\u7ec6\u7684\u4f7f\u7528\u91d1\u989d\u4e0e\u5f53\u524d\u7684\u64cd\u4f5c\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            this.processCostBudgetItemReverse(currentMonthProcessData, operateAmount, businessCode, businessItemCode, itemRemark, source);
        }
    }

    static class ProcessData {
        private BigDecimal finalBalance;
        private String costBudgetCode;
        private String sortKey;
        private BigDecimal currentOperateAmount;

        public ProcessData(BigDecimal finalBalance, String costBudgetCode, String sortKey) {
            this.finalBalance = finalBalance;
            this.costBudgetCode = costBudgetCode;
            this.sortKey = sortKey;
        }

        public ProcessData(BigDecimal finalBalance, String costBudgetCode, String sortKey, BigDecimal currentOperateAmount) {
            this.finalBalance = finalBalance;
            this.costBudgetCode = costBudgetCode;
            this.sortKey = sortKey;
            this.currentOperateAmount = currentOperateAmount;
        }

        public BigDecimal getFinalBalance() {
            return this.finalBalance;
        }

        public String getCostBudgetCode() {
            return this.costBudgetCode;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public BigDecimal getCurrentOperateAmount() {
            return this.currentOperateAmount;
        }
    }
}

