package com.biz.crm.tpm.business.car.subsidy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM-车补信息(AuditCarSubsidy)表控制层
 *
 * @author liuyifan
 * @date 2023-02-15 11:07:06
 */
@Slf4j
@Api(tags = "TPM-车补信息")
@RestController
@RequestMapping(value = {"/v1/auditCarSubsidy/auditCarSubsidy"})
public class AuditCarSubsidyController {

  @Autowired(required = false)
  private AuditCarSubsidyVoService auditCarSubsidyVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<AuditCarSubsidyVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                          AuditCarSubsidyDto paginationDto) {
    try {
      Page<AuditCarSubsidyVo> result = this.auditCarSubsidyVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<AuditCarSubsidyVo> findDetailById(@RequestParam("id") String id) {
    try {
      AuditCarSubsidyVo auditCarSubsidyVo = this.auditCarSubsidyVoService.findDetailById(id);
      return Result.ok(auditCarSubsidyVo);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 手动执行任务
   *
   * @param masterDataMdgCarSubsidyDto
   * @return
   */
  @ApiOperation(value = "手动执行任务")
  @GetMapping(value = {"/fullAllData"})
  public void fullAllData(MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto) {
    try {
      this.auditCarSubsidyVoService.fullAllData(masterDataMdgCarSubsidyDto);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
    }
  }

  /**
   * 创建
   *
   * @param auditCarSubsidyVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<AuditCarSubsidyVo> create(@RequestBody AuditCarSubsidyVo auditCarSubsidyVo) {
    try {
      AuditCarSubsidyVo current = this.auditCarSubsidyVoService.create(auditCarSubsidyVo);
      return Result.ok(current);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param auditCarSubsidyVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<AuditCarSubsidyVo> update(@RequestBody AuditCarSubsidyVo auditCarSubsidyVo) {
    try {
      AuditCarSubsidyVo current = this.auditCarSubsidyVoService.update(auditCarSubsidyVo);
      return Result.ok(current);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.auditCarSubsidyVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.auditCarSubsidyVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.auditCarSubsidyVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
