package com.biz.crm.tpm.business.car.subsidy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM-车补明细信息(AuditCarSubsidyDetail)表控制层
 *
 * @author liuyifan
 * @date 2023-02-15 11:07:46
 */
@Slf4j
@Api(tags = "TPM-车补明细信息")
@RestController
@RequestMapping(value = {"/v1/auditCarSubsidyDetail/auditCarSubsidyDetail"})
public class AuditCarSubsidyDetailController {

  @Autowired(required = false)
  private AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService;

  /**
   * 查询分页列表
   *
   * @param pageable
   * @param paginationDto
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<AuditCarSubsidyDetailVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                AuditCarSubsidyDetailDto paginationDto) {
    try {
      Page<AuditCarSubsidyDetailVo> result = this.auditCarSubsidyDetailVoService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 详情
   *
   * @param id
   * @return
   */
  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<AuditCarSubsidyDetailVo> findDetailById(@RequestParam("id") String id) {
    try {
      AuditCarSubsidyDetailVo auditCarSubsidyDetailVo = this.auditCarSubsidyDetailVoService.findDetailById(id);
      return Result.ok(auditCarSubsidyDetailVo);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建
   *
   * @param auditCarSubsidyDetailVo
   * @return
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<AuditCarSubsidyDetailVo> create(@RequestBody AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
    try {
      AuditCarSubsidyDetailVo current = this.auditCarSubsidyDetailVoService.create(auditCarSubsidyDetailVo);
      return Result.ok(current);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 更新
   *
   * @param auditCarSubsidyDetailVo
   * @return
   */
  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<AuditCarSubsidyDetailVo> update(@RequestBody AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
    try {
      AuditCarSubsidyDetailVo current = this.auditCarSubsidyDetailVoService.update(auditCarSubsidyDetailVo);
      return Result.ok(current);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 启用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "启用")
  @PatchMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    try {
      this.auditCarSubsidyDetailVoService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 禁用
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "禁用")
  @PatchMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    try {
      this.auditCarSubsidyDetailVoService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 逻辑删除
   *
   * @param ids
   * @return
   */
  @ApiOperation(value = "逻辑删除")
  @DeleteMapping("/delete")
  public Result delete(@RequestParam("ids") List<String> ids) {
    try {
      this.auditCarSubsidyDetailVoService.updateDelFlagByIds(ids);
      return Result.ok("删除成功");
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 手动执行任务
   *
   * @param masterDataMdgCarSubsidyDetailDto
   * @return
   */
  @ApiOperation(value = "手动执行任务")
  @GetMapping(value = {"/fullAllData"})
  public void fullAllData(MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto) {
    try {
      this.auditCarSubsidyDetailVoService.fullAllData(masterDataMdgCarSubsidyDetailDto);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
    }
  }
}
