package com.biz.crm.tpm.business.car.subsidy.local.dataView;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/12/5 20:08
 * @description: tpm付款单数据视图
 */
@Component
@Slf4j
public class AuditCarSubsidyDataViewRegister implements DataviewRegister {
    /**
     * 编码
     */
    @Override
    public String code() {
        return "tpm_audit_car_subsidy_data_view";
    }

    /**
     * 名称
     */
    @Override
    public String desc() {
        return "TPM-车补汇总信息";
    }

    /**
     * sql
     */
    @Override
    public String buildSql() {
        return "select * from tpm_audit_car_subsidy a   " +
                "    where a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "    and a.tenant_code = :tenantCode ";
    }
}
