package com.biz.crm.tpm.business.car.subsidy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 实体：TPM-车补信息;
 *
 * @author : Keller
 * @date : 2022-5-18
 */
@ApiModel(value = "AuditCarSubsidy", description = "TPM-车补信息")
@TableName("tpm_audit_car_subsidy")
@Getter
@Setter
@Entity(name = "tpm_audit_car_subsidy")
@Table(name = "tpm_audit_car_subsidy", indexes = {})
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_car_subsidy", comment = "TPM-车补信息")
public class AuditCarSubsidy  extends TenantFlagOpEntity {


    @ApiModelProperty(value = "组织名称")
    @Column(name = "org_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称 '")
    private String orgName;


    @ApiModelProperty(value = "sap市场编码")
    @Column(name = "dealer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'sap市场编码 '")
    private String dealerCode;

    @ApiModelProperty(value = "sap市场名称")
    @Column(name = "dealer_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT 'sap市场名称 '")
    private String dealerName;

    @ApiModelProperty(value = "车补客户编码")
    @Column(name = "zc_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '车补客户编码 '")
    private String zcCode;

    @ApiModelProperty(value = "车补客户名称")
    @Column(name = "zc_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '车补客户名称 '")
    private String zcName;


    @ApiModelProperty(value = "车辆补贴金额（元）")
    @Column(name = "zst_subsidy_moy",  columnDefinition = "Decimal(24,6) COMMENT '车辆补贴金额（元）'")
    private BigDecimal zstSubsidyMoy;



    @ApiModelProperty(value = "业务月月份")
    @Column(name = "statistics_month",  columnDefinition = "VARCHAR(32) COMMENT '业务月月份'")
    private String statisticsMonth;


    @ApiModelProperty(value = "乡镇里程数")
    @Column(name = "town_mileage",  columnDefinition = "Decimal(24,6) COMMENT '乡镇里程数'")
    private BigDecimal townMileage;


    @ApiModelProperty(value = "补贴上限")
    @Column(name = "zup_subsidy",  columnDefinition = "Decimal(24,6) COMMENT '补贴上限'")
    private BigDecimal zupSubsidy;


    @ApiModelProperty(value = "前置金额")
    @Column(name = "zbf_money",  columnDefinition = "Decimal(24,6) COMMENT '前置金额 '")
    private BigDecimal zbfMoney;


    @ApiModelProperty(value = "已结案补贴")
    @Column(name = "z_close_subsidy",  columnDefinition = "Decimal(24,6) COMMENT '已结案补贴 '")
    private BigDecimal zCloseSubsidy;

    @ApiModelProperty(value = "累计车补系统补贴金额")
    @Column(name = "z_sum_money",  columnDefinition = "Decimal(24,6) COMMENT '累计车补系统补贴金额 '")
    private BigDecimal zSumMoney;

    @ApiModelProperty(value = "月度结案金额")
    @Column(name = "monthly_amount",  columnDefinition = "Decimal(24,6) COMMENT '月度结案金额 '")
    private BigDecimal monthlyAmount;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @Column(name = "sales_region_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '大区编码'")
    private String salesRegionCode;


    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @Column(name = "sales_region_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '大区名称'")
    private String salesRegionName;



}
