package com.biz.crm.tpm.business.car.subsidy.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;


/**
 * 实体：TPM-预算项目;
 *
 * @author : Keller
 * @date : 2022-5-18
 */
@ApiModel(value = "AuditCarSubsidyDetail", description = "TPM-车补明细信息")
@TableName("tpm_audit_car_subsidy_detail")
@Getter
@Setter
@Entity(name = "tpm_audit_car_subsidy_detail")
@Table(name = "tpm_audit_car_subsidy_detail", indexes = {})
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_car_subsidy_detail", comment = "TPM-车补明细信息")
public class AuditCarSubsidyDetail extends TenantFlagOpEntity {

    @ApiModelProperty(value = "车牌号")
    @Column(name = "car_number", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '车牌号 '")
    private String carNumber;


    @ApiModelProperty(value = "补贴标准（元/公里）")
    @Column(name = "zst_subsidy",  columnDefinition = "Decimal(24,6) COMMENT '补贴标准（元/公里） '")
    private BigDecimal zstSubsidy;


    @ApiModelProperty(value = "组织名称")
    @Column(name = "org_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织名称 '")
    private String orgName;


    @ApiModelProperty(value = "sap市场编码")
    @Column(name = "dealer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'sap市场编码 '")
    private String dealerCode;

    @ApiModelProperty(value = "sap市场名称")
    @Column(name = "dealer_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT 'sap市场名称 '")
    private String dealerName;

    @ApiModelProperty(value = "车补客户编码")
    @Column(name = "zc_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '车补客户编码 '")
    private String zcCode;

    @ApiModelProperty(value = "车补客户名称")
    @Column(name = "zc_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '车补客户名称 '")
    private String zcName;


    @ApiModelProperty(value = "车辆补贴金额（元）")
    @Column(name = "zst_subsidy_moy",  columnDefinition = "Decimal(24,6) COMMENT '车辆补贴金额（元）'")
    private BigDecimal zstSubsidyMoy;



    @ApiModelProperty(value = "业务月月份")
    @Column(name = "statistics_month",  columnDefinition = "VARCHAR(32) COMMENT '业务月月份'")
    private String statisticsMonth;


    @ApiModelProperty(value = "乡镇里程数")
    @Column(name = "town_mileage",  columnDefinition = "Decimal(24,6) COMMENT '乡镇里程数'")
    private BigDecimal townMileage;


    @ApiModelProperty(value = "补贴上限")
    @Column(name = "zup_subsidy",  columnDefinition = "Decimal(24,6) COMMENT '补贴上限'")
    private BigDecimal zupSubsidy;


    @ApiModelProperty(value = "前置金额")
    @Column(name = "zbf_money",  columnDefinition = "Decimal(24,6) COMMENT '前置金额 '")
    private BigDecimal zbfMoney;


    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @Column(name = "business_format_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元'")
    private String businessUnitCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @Column(name = "sales_region_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '大区编码'")
    private String salesRegionCode;


    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    @Column(name = "sales_region_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '大区名称'")
    private String salesRegionName;


}
