package com.biz.crm.tpm.business.car.subsidy.local.mapper;

import com.biz.crm.tpm.business.car.subsidy.local.model.AuditCarSubsidyDetailExportsDto;
import com.biz.crm.tpm.business.car.subsidy.local.model.AuditCarSubsidyDetailExportsVo;
import org.apache.ibatis.annotations.Param;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * TPM-车补明细信息(AuditCarSubsidyDetail)表数据库访问层
 *
 * @author liuyifan
 * @date 2023-02-22 14:53:21
 */
public interface AuditCarSubsidyDetailExportsMapper {

    /**
     * 获取匹配的数据总量
     *
     * @param dto
     * @return
     */
    Integer getExportTotal(@Param("dto") AuditCarSubsidyDetailExportsDto dto);

    /**
     * 获取导出数据
     *
     * @param dto
     * @return
     */
    List<AuditCarSubsidyDetailExportsVo> findData(@Param("dto") AuditCarSubsidyDetailExportsDto dto);
}
