package com.biz.crm.tpm.business.car.subsidy.local.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@Data
public class AuditCarSubsidyDetailExportsDto {

    private String id;

    /**
     * 创建人账号
     */
    @ApiModelProperty("创建人账号")
    private String createAccount;

    /**
     * 创建人名称
     */
    @ApiModelProperty("创建人名称")
    private String createName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间 ")
    private Date createTime;

    /**
     * 修改人账号
     */
    @ApiModelProperty("修改人账号")
    private String modifyAccount;

    /**
     * 修改人名称
     */
    @ApiModelProperty("修改人名称")
    private String modifyName;

    /**
     * 修改时间
     */
    @ApiModelProperty("修改时间")
    private Date modifyTime;

    /**
     * 数据状态（删除状态）
     */
    @ApiModelProperty("数据状态（删除状态）")
    private String delFlag;

    /**
     * 数据业务状态（启用状态）
     */
    @ApiModelProperty("数据业务状态（启用状态）")
    private String enableStatus;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 租户编号
     */
    @ApiModelProperty("租户编号")
    private String tenantCode;

    /**
     * 车牌号
     */
    @ApiModelProperty("车牌号 ")
    private String carNumber;

    /**
     * sap市场编码
     */
    @ApiModelProperty("sap市场编码 ")
    private String dealerCode;

    /**
     * sap市场名称
     */
    @ApiModelProperty("sap市场名称 ")
    private String dealerName;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称 ")
    private String orgName;

    /**
     * 业务月月份
     */
    @ApiModelProperty("业务月月份")
    private String statisticsMonth;

    /**
     * 乡镇里程数
     */
    @ApiModelProperty("乡镇里程数")
    private Double townMileage;

    /**
     * 前置金额
     */
    @ApiModelProperty("前置金额 ")
    private Double zbfMoney;

    /**
     * 车补客户编码
     */
    @ApiModelProperty("车补客户编码 ")
    private String zcCode;

    /**
     * 车补客户名称
     */
    @ApiModelProperty("车补客户名称 ")
    private String zcName;

    /**
     * 补贴标准（元/公里）
     */
    @ApiModelProperty("补贴标准（元/公里） ")
    private Double zstSubsidy;

    /**
     * 车辆补贴金额（元）
     */
    @ApiModelProperty("车辆补贴金额（元）")
    private Double zstSubsidyMoy;

    /**
     * 补贴上限
     */
    @ApiModelProperty("补贴上限")
    private Double zupSubsidy;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 大区编码
     */
    @ApiModelProperty("大区编码")
    private String salesRegionCode;

    /**
     * 大区名称
     */
    @ApiModelProperty("大区名称")
    private String salesRegionName;

    /**
     * 偏移量
     */
    @ApiModelProperty(name = "offset", notes = "偏移量", value = "偏移量")
    private Integer offset;

    /**
     * limit
     */
    @ApiModelProperty(name = "limit", notes = "limit", value = "limit")
    private Integer limit;

}
