package com.biz.crm.tpm.business.car.subsidy.local.model;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@CrmExcelExport
@Data
public class AuditCarSubsidyDetailExportsVo extends CrmExcelVo {


    /**
     * 车牌号
     */
    @ApiModelProperty("车牌号")
    @CrmExcelColumn("车牌号")
    private String carNumber;

    /**
     * sap市场编码
     */
    @ApiModelProperty("sap市场编码")
    @CrmExcelColumn("sap市场编码")
    private String dealerCode;

    /**
     * sap市场名称
     */
    @ApiModelProperty("sap市场名称")
    @CrmExcelColumn("sap市场名称")
    private String dealerName;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称 ")
    @CrmExcelColumn("组织名称 ")
    private String orgName;

    /**
     * 业务月月份
     */
    @ApiModelProperty("业务月月份")
    @CrmExcelColumn("业务月月份")
    private String statisticsMonth;

    /**
     * 乡镇里程数
     */
    @ApiModelProperty("乡镇里程数")
    @CrmExcelColumn("乡镇里程数")
    private Double townMileage;

    /**
     * 前置金额
     */
    @ApiModelProperty("前置金额 ")
    @CrmExcelColumn("前置金额 ")
    private Double zbfMoney;

    /**
     * 车补客户编码
     */
    @ApiModelProperty("车补客户编码 ")
    @CrmExcelColumn("车补客户编码 ")
    private String zcCode;

    /**
     * 车补客户名称
     */
    @ApiModelProperty("车补客户名称 ")
    @CrmExcelColumn("车补客户名称 ")
    private String zcName;

    /**
     * 补贴标准（元/公里）
     */
    @ApiModelProperty("补贴标准（元/公里） ")
    @CrmExcelColumn("补贴标准（元/公里） ")
    private Double zstSubsidy;

    /**
     * 车辆补贴金额（元）
     */
    @ApiModelProperty("车辆补贴金额（元）")
    @CrmExcelColumn("车辆补贴金额（元）")
    private Double zstSubsidyMoy;

    /**
     * 补贴上限
     */
    @ApiModelProperty("补贴上限")
    @CrmExcelColumn("补贴上限")
    private Double zupSubsidy;

    /**
     * 业态
     */
    @ApiModelProperty("业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    /**
     * 大区编码
     */
    @ApiModelProperty("大区编码")
    @CrmExcelColumn("大区编码")
    private String salesRegionCode;

    /**
     * 大区名称
     */
    @ApiModelProperty("大区名称")
    @CrmExcelColumn("大区名称")
    private String salesRegionName;

}
