package com.biz.crm.tpm.business.car.subsidy.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidy;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.local.mapper.AuditCarSubsidyDetailMapper;
import java.util.List;

import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import org.springframework.stereotype.Component;

/**
 * TPM-车补明细信息(repository)
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:36
 */
@Component
public class AuditCarSubsidyDetailRepository extends ServiceImpl<AuditCarSubsidyDetailMapper, AuditCarSubsidyDetail> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditCarSubsidyDetailVo> findByConditions(Page<AuditCarSubsidyDetailVo> page,
        AuditCarSubsidyDetailDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditCarSubsidyDetail findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditCarSubsidyDetail> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditCarSubsidyDetail::getId, ids).list();
    }

    /**
     * 唯一性查找 组织名称+SAP市场编码+车补客户编码+车牌号+年月
     *
     * @param orgName
     *            组织名字
     * @param dealerCode
     *            经销商编码
     * @param zcCode
     *            车补客户编码
     * @param carNumber
     *            车牌号
     * @param statisticsMonth
     *            统计月
     * @return {@link List}<{@link AuditCarSubsidyDetail}>
     */
    public List<AuditCarSubsidyDetail> findUniqueness(String orgName, String dealerCode, String zcCode,
        String carNumber, String statisticsMonth) {

        return this.lambdaQuery().eq(AuditCarSubsidyDetail::getOrgName, orgName)
            .eq(AuditCarSubsidyDetail::getCarNumber, carNumber).eq(AuditCarSubsidyDetail::getDealerCode, dealerCode)
            .eq(AuditCarSubsidyDetail::getZcCode, zcCode).eq(AuditCarSubsidyDetail::getStatisticsMonth, statisticsMonth)
            .eq(AuditCarSubsidyDetail::getStatisticsMonth, statisticsMonth).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate().in(AuditCarSubsidyDetail::getId, ids)
            .set(AuditCarSubsidyDetail::getEnableStatus, enable.getCode()).update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate().in(AuditCarSubsidyDetail::getId, ids)
            .set(AuditCarSubsidyDetail::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    public List<AuditCarSubsidyDetail> findDetailByZcCode(String zcCode) {
        return this.lambdaQuery().eq(AuditCarSubsidyDetail::getZcCode, zcCode)
            .eq(AuditCarSubsidyDetail::getDelFlag, DelFlagStatusEnum.NORMAL.getCode()).list();
    }
}
