package com.biz.crm.tpm.business.car.subsidy.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidy;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.local.mapper.AuditCarSubsidyMapper;
import java.util.List;

import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import org.springframework.stereotype.Component;

/**
 * TPM-车补信息(repository)
 *
 * @author liuyifan
 * @date 2022-12-30 17:37:45
 */
@Component
public class AuditCarSubsidyRepository extends ServiceImpl<AuditCarSubsidyMapper, AuditCarSubsidy> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<AuditCarSubsidyVo> findByConditions(Page<AuditCarSubsidyVo> page, AuditCarSubsidyDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public AuditCarSubsidy findById(String id) {
        return this.baseMapper.selectById(id);
    }


    /**
     * 唯一性查找 组织名称+SAP市场编码+车补客户编码+年月
     *
     * @param orgName         组织名字
     * @param dealerCode      经销商编码
     * @param zcCode          车补客户编码
     * @param statisticsMonth 统计月
     * @return {@link List}<{@link AuditCarSubsidy}>
     */
    public List<AuditCarSubsidy> findUniqueness(String orgName,String dealerCode,String zcCode,String statisticsMonth) {

        return this.lambdaQuery()
                .eq(AuditCarSubsidy::getOrgName,orgName)
                .eq(AuditCarSubsidy::getDealerCode,dealerCode)
                .eq(AuditCarSubsidy::getZcCode,zcCode)
                .eq(AuditCarSubsidy::getStatisticsMonth,statisticsMonth)
                .list();
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<AuditCarSubsidy> findByIds(List<String> ids) {
        return this.lambdaQuery().in(AuditCarSubsidy::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate()
                .in(AuditCarSubsidy::getId, ids)
                .set(AuditCarSubsidy::getEnableStatus, enable.getCode())
                .update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate()
                .in(AuditCarSubsidy::getId, ids)
                .set(AuditCarSubsidy::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .update();
    }


    public AuditCarSubsidy findValueByConditions(AuditCarSubsidyDto dto) {
        return this.lambdaQuery().eq(AuditCarSubsidy::getBusinessFormatCode,dto.getBusinessFormatCode())
                .eq(AuditCarSubsidy::getBusinessUnitCode,dto.getBusinessUnitCode())
                .eq(AuditCarSubsidy::getDealerCode,dto.getDealerCode())
                .eq(AuditCarSubsidy::getSalesRegionCode,dto.getSalesRegionCode())
                .eq(AuditCarSubsidy::getStatisticsMonth,dto.getStatisticsMonth())
                .eq(AuditCarSubsidy::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }
}
