package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyDetailVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyVo;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidy;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.local.repository.AuditCarSubsidyDetailRepository;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailLogEventDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.AuditCarSubsidyDetailEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.log.AuditCarSubsidyDetailLogEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * TPM-车补明细信息(AuditCarSubsidyDetail)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:37
 */
@Slf4j
@Service("auditCarSubsidyDetailService")
public class AuditCarSubsidyDetailVoServiceImpl implements AuditCarSubsidyDetailVoService {

    @Autowired(required = false)
    private AuditCarSubsidyDetailRepository auditCarSubsidyDetailRepository;

    @Autowired(required = false)
    private List<AuditCarSubsidyDetailEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private MasterDataMdgService masterDataMdgService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Resource
    private CustomerVoService customerVoService;

    @Override
    public Page<AuditCarSubsidyDetailVo> findByConditions(Pageable pageable, AuditCarSubsidyDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditCarSubsidyDetailDto());
        Page<AuditCarSubsidyDetailVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditCarSubsidyDetailRepository.findByConditions(page, dto);
    }

    @Override
    public AuditCarSubsidyDetailVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditCarSubsidyDetail auditCarSubsidyDetail = this.auditCarSubsidyDetailRepository.findById(id);
        if (auditCarSubsidyDetail == null) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(auditCarSubsidyDetail, AuditCarSubsidyDetailVo.class,
            HashSet.class, ArrayList.class);
    }

    @Override
    @Transactional
    public AuditCarSubsidyDetailVo create(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.createValidation(auditCarSubsidyDetailVo);
        List<AuditCarSubsidyDetail> uniqueness =
                this.auditCarSubsidyDetailRepository.findUniqueness(auditCarSubsidyDetailVo.getOrgName(),
                        auditCarSubsidyDetailVo.getDealerCode(), auditCarSubsidyDetailVo.getZcCode(),
                        auditCarSubsidyDetailVo.getCarNumber(), auditCarSubsidyDetailVo.getStatisticsMonth());
//        Validate.notEmpty(uniqueness, "组织名称+SAP市场编码+车补客户编码+车牌号+年月，需要保证唯一");
        if (CollectionUtils.isNotEmpty(uniqueness)){
            return null;
        }

        auditCarSubsidyDetailVo.setTenantCode(TenantUtils.getTenantCode());
        auditCarSubsidyDetailVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditCarSubsidyDetailVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        auditCarSubsidyDetailVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        auditCarSubsidyDetailVo.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());


        AuditCarSubsidyDetail auditCarSubsidyDetail = nebulaToolkitService.copyObjectByWhiteList(
            auditCarSubsidyDetailVo, AuditCarSubsidyDetail.class, HashSet.class, ArrayList.class);
        this.auditCarSubsidyDetailRepository.saveOrUpdate(auditCarSubsidyDetail);

        auditCarSubsidyDetailVo.setId(auditCarSubsidyDetail.getId());

        // crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditCarSubsidyDetailEventListener auditCarSubsidyDetailEventListener : eventListeners) {
                auditCarSubsidyDetailEventListener.onCreate(auditCarSubsidyDetailVo);
            }
        }

        // 发送通知
        AuditCarSubsidyDetailLogEventDto logEventDto = new AuditCarSubsidyDetailLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditCarSubsidyDetailVo);
        SerializableBiConsumer<AuditCarSubsidyDetailLogEventListener, AuditCarSubsidyDetailLogEventDto> onCreate =
            AuditCarSubsidyDetailLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditCarSubsidyDetailLogEventListener.class, onCreate);
        return auditCarSubsidyDetailVo;
    }

    @Override
    @Transactional
    public AuditCarSubsidyDetailVo update(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.updateValidation(auditCarSubsidyDetailVo);
        String currentId = auditCarSubsidyDetailVo.getId();
        AuditCarSubsidyDetail current = auditCarSubsidyDetailRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditCarSubsidyDetailVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current,
            AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class);

        this.auditCarSubsidyDetailRepository.saveOrUpdate(current);
        // crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditCarSubsidyDetailEventListener auditCarSubsidyDetailEventListener : eventListeners) {
                auditCarSubsidyDetailEventListener.onUpdate(oldVo, auditCarSubsidyDetailVo);
            }
        }

        // 发送修改通知
        AuditCarSubsidyDetailLogEventDto logEventDto = new AuditCarSubsidyDetailLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditCarSubsidyDetailVo);
        SerializableBiConsumer<AuditCarSubsidyDetailLogEventListener, AuditCarSubsidyDetailLogEventDto> onUpdate =
            AuditCarSubsidyDetailLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditCarSubsidyDetailLogEventListener.class, onUpdate);
        return auditCarSubsidyDetailVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyDetailRepository.updateDelFlagByIds(ids);
    }

    @Override
    public void fullAllData(MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto) {
        log.info("车补费用明细开始执行定时任务------>");
        Validate.notNull(masterDataMdgCarSubsidyDetailDto, "请求对象不能为空");
        if (StrUtil.isBlank(masterDataMdgCarSubsidyDetailDto.getPageNum())) {
            masterDataMdgCarSubsidyDetailDto.setPageNum("1");
        }
        if (StrUtil.isBlank(masterDataMdgCarSubsidyDetailDto.getPageSize())) {
            masterDataMdgCarSubsidyDetailDto.setPageSize("500");
        }

        while (true) {
            List<MasterDataMdgCarSubsidyDetailVo> masterDataMdgCarSubsidyDetailVos =
                this.masterDataMdgService.pullCarSubsidyDetail(masterDataMdgCarSubsidyDetailDto);
            log.info("车补费用明细从MDG获取,{}", JSON.toJSONString(masterDataMdgCarSubsidyDetailVos));
            if (CollectionUtils.isEmpty(masterDataMdgCarSubsidyDetailVos)) {
                return;
            } else {
                Collection<AuditCarSubsidyDetailVo> carSubsidyDetails = nebulaToolkitService.copyCollectionByWhiteList(
                    masterDataMdgCarSubsidyDetailVos, MasterDataMdgCarSubsidyDetailVo.class,
                    AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class);

                this.fullOrg(carSubsidyDetails);
                carSubsidyDetails.forEach(x->{
                    x.setTenantCode(TenantUtils.getTenantCode());
                    this.create(x);
                });

                // 叶码+1
                Integer pageNum = Integer.valueOf(masterDataMdgCarSubsidyDetailDto.getPageNum());
                pageNum = pageNum + 1;
                if (pageNum > 100) {
                    return;
                }

                masterDataMdgCarSubsidyDetailDto.setPageNum(pageNum.toString());
            }
        }

    }

    /**
     * 完善组织信息
     *
     * @param auditCarSubsidyVos 车补汇总vo
     */
    private void fullOrg(Collection<AuditCarSubsidyDetailVo> auditCarSubsidyDetailVos){

        if (CollectionUtils.isEmpty(auditCarSubsidyDetailVos)){
            return;
        }
        Set<String> erpCode = auditCarSubsidyDetailVos.stream().map(AuditCarSubsidyDetailVo::getZcCode).collect(Collectors.toSet());

        List<CustomerVo> customerVos = customerVoService.findByErpCodeList(Lists.newArrayList(erpCode));
        if (CollectionUtils.isEmpty(customerVos)){
            return;
        }

        Set<CustomerVo> customerVoSets = customerVos.stream().filter(Objects::nonNull).filter(x ->
                BusinessFormatEnum.NORMAL.getCode().equals(x.getBusinessFormatCode())
                        && "6000".equals(x.getSalesInstitutionErpCode())
                        && "20".equals(x.getCustomerChannelCode())).collect(Collectors.toSet());

        Map<String, List<CustomerVo>> saleOrgGroup = customerVoSets.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
        auditCarSubsidyDetailVos.forEach(auditCarSubsidyDetailVo -> {
            List<CustomerVo> customers = saleOrgGroup.get(auditCarSubsidyDetailVo.getDealerCode());
            if (CollectionUtils.isNotEmpty(customers)){
                CustomerVo customerVo = customers.get(0);
                auditCarSubsidyDetailVo.setSalesRegionName(customerVo.getSalesRegionName());
                auditCarSubsidyDetailVo.setSalesRegionCode(customerVo.getSalesRegionCode());
            }

        });
    }


    @Override
    public List<AuditCarSubsidyDetailVo> findDetailByZcCode(String zcCode) {
        List<AuditCarSubsidyDetail> details = this.auditCarSubsidyDetailRepository.findDetailByZcCode(zcCode);
        if (CollectionUtils.isEmpty(details)){
            return Lists.newArrayList();
        }
        Collection<AuditCarSubsidyDetailVo> detailVos = nebulaToolkitService.copyCollectionByWhiteList(details, AuditCarSubsidyDetail.class, AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class);
        return Lists.newArrayList(detailVos);
    }
    private void createValidation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.validation(auditCarSubsidyDetailVo);
//        List<AuditCarSubsidyDetail> uniqueness =
//            this.auditCarSubsidyDetailRepository.findUniqueness(auditCarSubsidyDetailVo.getOrgName(),
//                auditCarSubsidyDetailVo.getDealerCode(), auditCarSubsidyDetailVo.getZcCode(),
//                auditCarSubsidyDetailVo.getCarNumber(), auditCarSubsidyDetailVo.getStatisticsMonth());
//        Validate.notEmpty(uniqueness, "组织名称+SAP市场编码+车补客户编码+车牌号+年月，需要保证唯一");
    }

    private void updateValidation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        // TODO 具体实现
        this.validation(auditCarSubsidyDetailVo);
    }

    private void validation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
//        Validate.notEmpty(auditCarSubsidyDetailVo.getCarNumber(), "车牌号不能为空");
//        Validate.notEmpty(auditCarSubsidyDetailVo.getDealerCode(), "SAP市场编码不能为空");
//        Validate.notEmpty(auditCarSubsidyDetailVo.getOrgName(), "组织名称不能为空");
//        Validate.notEmpty(auditCarSubsidyDetailVo.getZcCode(), "车补客户编码不能为空");
//        Validate.notEmpty(auditCarSubsidyDetailVo.getStatisticsMonth(), "年月不能为空");
    }
}
