package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import java.util.Date;
import java.util.concurrent.TimeUnit;

import static com.biz.crm.tpm.business.car.subsidy.sdk.constants.AuditCarSubsidyConstants.carSubsidyDetail_lock;
import static com.biz.crm.tpm.business.car.subsidy.sdk.constants.AuditCarSubsidyConstants.carSubsidy_lock;

/**
 * 车补启动定时任务
 *
 * @author liuyifan
 * @date 2023/02/27
 */
@Component
@Slf4j
public class AuditCarSubsidyJob {

    private RedisLockService redisLockService;

    private AuditCarSubsidyVoService auditCarSubsidyVoService;

    private AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService;

    private LoginUserService loginUserService;

    @Autowired
    public void setLoginUserService(LoginUserService loginUserService) {
        this.loginUserService = loginUserService;
    }

    @Autowired
    public void setRedisLockService(RedisLockService redisLockService) {
        this.redisLockService = redisLockService;
    }

    @Autowired
    public void setAuditCarSubsidyVoService(AuditCarSubsidyVoService auditCarSubsidyVoService) {
        this.auditCarSubsidyVoService = auditCarSubsidyVoService;
    }

    @Autowired
    public void setAuditCarSubsidyDetailVoService(AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService) {
        this.auditCarSubsidyDetailVoService = auditCarSubsidyDetailVoService;
    }

    @DynamicTaskService(cornExpression = "0 59 23 * * ?", taskDesc = "每天23:59分扫描一下车补信息")
    public void executeCarSubsidy() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = redisLockService.tryLock(carSubsidy_lock, TimeUnit.HOURS, 2);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            //执行业务逻辑
            MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto = new MasterDataMdgCarSubsidyDto();
            masterDataMdgCarSubsidyDto.setStatisticsMonth(DateUtil.format(new Date(), "yyyy-MM"));
            this.auditCarSubsidyVoService.fullAllData(masterDataMdgCarSubsidyDto);

        } catch (Exception e) {
            log.error("每天23:59分扫描一下车补信息异常");
            log.error("", e);
            throw new IllegalArgumentException(e.getMessage(), e);
        } finally {
            if (lockSuccess) {
                redisLockService.unlock(carSubsidy_lock);
            }
        }
    }

    @DynamicTaskService(cornExpression = "0 59 23 * * ?", taskDesc = "每天23:59分扫描一下车补明细信息")
    public void executeCarSubsidyDetail() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = redisLockService.tryLock(carSubsidyDetail_lock, TimeUnit.HOURS, 2);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            //执行业务逻辑
            MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto = new MasterDataMdgCarSubsidyDetailDto();
            masterDataMdgCarSubsidyDetailDto.setStatisticsMonth(DateUtil.format(new Date(), "yyyy-MM"));
            this.auditCarSubsidyDetailVoService.fullAllData(masterDataMdgCarSubsidyDetailDto);

        } catch (Exception e) {
            log.error("每天23:59分扫描一下车补明细信息异常");
            log.error("", e);
            throw new IllegalArgumentException(e.getMessage(), e);
        } finally {
            if (lockSuccess) {
                redisLockService.unlock(carSubsidyDetail_lock);
            }
        }
    }
}
