package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyDetailVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyVo;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCustomerVo;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidy;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.local.repository.AuditCarSubsidyRepository;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyLogEventDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.AuditCarSubsidyEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.log.AuditCarSubsidyLogEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;

import java.util.*;
import java.util.stream.Collectors;

import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * TPM-车补信息(AuditCarSubsidy)表服务实现类
 *
 * @author liuyifan
 * @date 2022-12-30 17:37:45
 */
@Slf4j
@Service("auditCarSubsidyService")
public class AuditCarSubsidyVoServiceImpl implements AuditCarSubsidyVoService {

    @Autowired(required = false)
    private AuditCarSubsidyRepository auditCarSubsidyRepository;

    @Autowired(required = false)
    private AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService;

    @Autowired(required = false)
    private List<AuditCarSubsidyEventListener> eventListeners;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired
    @Qualifier("nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired
    private MasterDataMdgService masterDataMdgService;

    @Autowired
    private CustomerVoService customerVoService;

    @Override
    public Page<AuditCarSubsidyVo> findByConditions(Pageable pageable, AuditCarSubsidyDto dto) {
        pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(1, 50));
        dto = Optional.ofNullable(dto).orElse(new AuditCarSubsidyDto());
        Page<AuditCarSubsidyVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.auditCarSubsidyRepository.findByConditions(page, dto);
    }

    @Override
    public AuditCarSubsidyVo findDetailById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }

        AuditCarSubsidy auditCarSubsidy = this.auditCarSubsidyRepository.findById(id);
        if (auditCarSubsidy == null) {
            return null;
        }
        AuditCarSubsidyVo auditCarSubsidyVo = nebulaToolkitService.copyObjectByWhiteList(auditCarSubsidy, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class);
        auditCarSubsidyVo.setDetails(auditCarSubsidyDetailVoService.findDetailByZcCode(auditCarSubsidyVo.getZcCode()));
        return auditCarSubsidyVo;

    }

    @Override
    @Transactional
    public AuditCarSubsidyVo create(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.createValidation(auditCarSubsidyVo);

        List<AuditCarSubsidy> uniqueness = this.auditCarSubsidyRepository.findUniqueness(auditCarSubsidyVo.getOrgName(), auditCarSubsidyVo.getDealerCode(), auditCarSubsidyVo.getZcCode(), auditCarSubsidyVo.getStatisticsMonth());
//        Validate.notEmpty(uniqueness,"组织名称+SAP市场编码+车补客户编码+年月,需要保证唯一");
        if (CollectionUtils.isNotEmpty(uniqueness)){
            return null;
        }
        auditCarSubsidyVo.setTenantCode(TenantUtils.getTenantCode());
        auditCarSubsidyVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditCarSubsidyVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        auditCarSubsidyVo.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        auditCarSubsidyVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());


        AuditCarSubsidy auditCarSubsidy = nebulaToolkitService.copyObjectByWhiteList(auditCarSubsidyVo, AuditCarSubsidy.class, HashSet.class, ArrayList.class);
        this.auditCarSubsidyRepository.saveOrUpdate(auditCarSubsidy);

        auditCarSubsidyVo.setId(auditCarSubsidy.getId());

        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditCarSubsidyEventListener auditCarSubsidyEventListener : eventListeners) {
                auditCarSubsidyEventListener.onCreate(auditCarSubsidyVo);
            }
        }

        // 发送通知
        AuditCarSubsidyLogEventDto logEventDto = new AuditCarSubsidyLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditCarSubsidyVo);
        SerializableBiConsumer<AuditCarSubsidyLogEventListener, AuditCarSubsidyLogEventDto> onCreate =
                AuditCarSubsidyLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditCarSubsidyLogEventListener.class, onCreate);
        return auditCarSubsidyVo;
    }

    @Override
    @Transactional
    public AuditCarSubsidyVo update(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.updateValidation(auditCarSubsidyVo);
        String currentId = auditCarSubsidyVo.getId();
        AuditCarSubsidy current = auditCarSubsidyRepository.findById(currentId);
        current = Validate.notNull(current, "修改信息不存在");
        AuditCarSubsidyVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(current, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class);


        this.auditCarSubsidyRepository.saveOrUpdate(current);
        //crud监听事件
        if (!CollectionUtils.isEmpty(eventListeners)) {
            for (AuditCarSubsidyEventListener auditCarSubsidyEventListener : eventListeners) {
                auditCarSubsidyEventListener.onUpdate(oldVo, auditCarSubsidyVo);
            }
        }

        // 发送修改通知
        AuditCarSubsidyLogEventDto logEventDto = new AuditCarSubsidyLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditCarSubsidyVo);
        SerializableBiConsumer<AuditCarSubsidyLogEventListener, AuditCarSubsidyLogEventDto> onUpdate =
                AuditCarSubsidyLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditCarSubsidyLogEventListener.class, onUpdate);
        return auditCarSubsidyVo;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue(CollectionUtils.isNotEmpty(ids), "id集合不能为空");
        this.auditCarSubsidyRepository.updateDelFlagByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void fullAllData(MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto) {
        Validate.notNull(masterDataMdgCarSubsidyDto, "请求对象不能为空");
        if (StrUtil.isBlank(masterDataMdgCarSubsidyDto.getPageNum())){
            masterDataMdgCarSubsidyDto.setPageNum("1");
        }
        if (StrUtil.isBlank(masterDataMdgCarSubsidyDto.getPageSize())){
            masterDataMdgCarSubsidyDto.setPageSize("500");
        }

        while (true) {
            List<MasterDataMdgCarSubsidyVo> masterDataMdgCarSubsidyVos = this.masterDataMdgService.pullCarSubsidy(masterDataMdgCarSubsidyDto);
            if (CollectionUtils.isEmpty(masterDataMdgCarSubsidyVos)) {
                return;
            } else {
                Collection<AuditCarSubsidyVo> auditCarSubsidies = nebulaToolkitService.copyCollectionByWhiteList(masterDataMdgCarSubsidyVos, MasterDataMdgCarSubsidyVo.class, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class);
                this.fullOrg(auditCarSubsidies);
                auditCarSubsidies.forEach(x->{
                    x.setTenantCode(TenantUtils.getTenantCode());
                    this.create(x);
                });

                //叶码+1
                Integer pageNum = Integer.valueOf(masterDataMdgCarSubsidyDto.getPageNum());
                pageNum = pageNum + 1;
                if (pageNum >100){
                    return;
                }
                masterDataMdgCarSubsidyDto.setPageNum(pageNum.toString());
            }
        }

    }


    /**
     * 完善组织信息
     *
     * @param auditCarSubsidyVos 车补汇总vo
     */
    private void fullOrg(Collection<AuditCarSubsidyVo> auditCarSubsidyVos){

        if (CollectionUtils.isEmpty(auditCarSubsidyVos)){
            return;
        }
        Set<String> erpCode = auditCarSubsidyVos.stream().map(AuditCarSubsidyVo::getZcCode).collect(Collectors.toSet());

        List<CustomerVo> customerVos = customerVoService.findByErpCodeList(Lists.newArrayList(erpCode));
        if (CollectionUtils.isEmpty(customerVos)){
            return;
        }
        Set<CustomerVo> customerVoSets = customerVos.stream().filter(Objects::nonNull).filter(x ->
                BusinessFormatEnum.NORMAL.getCode().equals(x.getBusinessFormatCode())
                        && "6000".equals(x.getSalesInstitutionErpCode())
                        && "20".equals(x.getCustomerChannelCode())).collect(Collectors.toSet());

        Map<String, List<CustomerVo>> saleOrgGroup = customerVoSets.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
        auditCarSubsidyVos.forEach(auditCarSubsidyVo -> {
            List<CustomerVo> customers = saleOrgGroup.get(auditCarSubsidyVo.getDealerCode());
            if (CollectionUtils.isNotEmpty(customers)){
                CustomerVo customerVo = customers.get(0);
                auditCarSubsidyVo.setSalesRegionName(customerVo.getSalesRegionName());
                auditCarSubsidyVo.setSalesRegionCode(customerVo.getSalesRegionCode());
            }

        });
    }

    private void createValidation(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.validation(auditCarSubsidyVo);
//        List<AuditCarSubsidy> uniqueness = this.auditCarSubsidyRepository.findUniqueness(auditCarSubsidyVo.getOrgName(), auditCarSubsidyVo.getDealerCode(), auditCarSubsidyVo.getZcCode(), auditCarSubsidyVo.getStatisticsMonth());
//        Validate.notEmpty(uniqueness,"组织名称+SAP市场编码+车补客户编码+年月,需要保证唯一");
    }

    private void updateValidation(AuditCarSubsidyVo auditCarSubsidyVo) {
        // TODO 具体实现
        this.validation(auditCarSubsidyVo);
    }

    private void validation(AuditCarSubsidyVo auditCarSubsidyVo) {
//        Validate.notEmpty(auditCarSubsidyVo.getOrgName(),"组织名称不能为空");
//        Validate.notEmpty(auditCarSubsidyVo.getDealerCode(),"SAP市场编码不能为空");
//        Validate.notEmpty(auditCarSubsidyVo.getZcCode(),"车补客户编码不能为空");
//        Validate.notEmpty(auditCarSubsidyVo.getStatisticsMonth(),"年月不能为空");
    }

    @Override
    public AuditCarSubsidyVo findValueByConditions(AuditCarSubsidyDto dto) {
        if (StringUtils.isEmpty(dto.getBusinessFormatCode()) || StringUtils.isEmpty(dto.getBusinessUnitCode())
                || StringUtils.isEmpty(dto.getDealerCode()) || StringUtils.isEmpty(dto.getSalesRegionCode()) || StringUtils.isEmpty(dto.getStatisticsMonth())){
            return new AuditCarSubsidyVo();
        }
        AuditCarSubsidy detail = this.auditCarSubsidyRepository.findValueByConditions(dto);
        if (Objects.isNull(detail)) {
            return null;
        }
        return nebulaToolkitService.copyObjectByWhiteList(detail, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class);
    }

}
