/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyDetailVo;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidyDetail;
import com.biz.crm.tpm.business.car.subsidy.local.repository.AuditCarSubsidyDetailRepository;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailLogEventDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.AuditCarSubsidyDetailEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.log.AuditCarSubsidyDetailLogEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditCarSubsidyDetailService")
public class AuditCarSubsidyDetailVoServiceImpl
implements AuditCarSubsidyDetailVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditCarSubsidyDetailVoServiceImpl.class);
    @Autowired(required=false)
    private AuditCarSubsidyDetailRepository auditCarSubsidyDetailRepository;
    @Autowired(required=false)
    private List<AuditCarSubsidyDetailEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private MasterDataMdgService masterDataMdgService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Resource
    private CustomerVoService customerVoService;

    public Page<AuditCarSubsidyDetailVo> findByConditions(Pageable pageable, AuditCarSubsidyDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditCarSubsidyDetailDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditCarSubsidyDetailRepository.findByConditions((Page<AuditCarSubsidyDetailVo>)page, dto);
    }

    public AuditCarSubsidyDetailVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditCarSubsidyDetail auditCarSubsidyDetail = this.auditCarSubsidyDetailRepository.findById(id);
        if (auditCarSubsidyDetail == null) {
            return null;
        }
        return (AuditCarSubsidyDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCarSubsidyDetail, AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public AuditCarSubsidyDetailVo create(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.createValidation(auditCarSubsidyDetailVo);
        List<AuditCarSubsidyDetail> uniqueness = this.auditCarSubsidyDetailRepository.findUniqueness(auditCarSubsidyDetailVo.getOrgName(), auditCarSubsidyDetailVo.getDealerCode(), auditCarSubsidyDetailVo.getZcCode(), auditCarSubsidyDetailVo.getCarNumber(), auditCarSubsidyDetailVo.getStatisticsMonth());
        if (CollectionUtils.isNotEmpty(uniqueness)) {
            return null;
        }
        auditCarSubsidyDetailVo.setTenantCode(TenantUtils.getTenantCode());
        auditCarSubsidyDetailVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditCarSubsidyDetailVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        auditCarSubsidyDetailVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        auditCarSubsidyDetailVo.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        AuditCarSubsidyDetail auditCarSubsidyDetail = (AuditCarSubsidyDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCarSubsidyDetailVo, AuditCarSubsidyDetail.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditCarSubsidyDetailRepository.saveOrUpdate((Object)auditCarSubsidyDetail);
        auditCarSubsidyDetailVo.setId(auditCarSubsidyDetail.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditCarSubsidyDetailEventListener auditCarSubsidyDetailEventListener : this.eventListeners) {
                auditCarSubsidyDetailEventListener.onCreate(auditCarSubsidyDetailVo);
            }
        }
        AuditCarSubsidyDetailLogEventDto logEventDto = new AuditCarSubsidyDetailLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditCarSubsidyDetailVo);
        SerializableBiConsumer & Serializable onCreate = AuditCarSubsidyDetailLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditCarSubsidyDetailLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditCarSubsidyDetailVo;
    }

    @Transactional
    public AuditCarSubsidyDetailVo update(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.updateValidation(auditCarSubsidyDetailVo);
        String currentId = auditCarSubsidyDetailVo.getId();
        AuditCarSubsidyDetail current = this.auditCarSubsidyDetailRepository.findById(currentId);
        current = (AuditCarSubsidyDetail)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditCarSubsidyDetailVo oldVo = (AuditCarSubsidyDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditCarSubsidyDetailRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditCarSubsidyDetailEventListener auditCarSubsidyDetailEventListener : this.eventListeners) {
                auditCarSubsidyDetailEventListener.onUpdate(oldVo, auditCarSubsidyDetailVo);
            }
        }
        AuditCarSubsidyDetailLogEventDto logEventDto = new AuditCarSubsidyDetailLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditCarSubsidyDetailVo);
        SerializableBiConsumer & Serializable onUpdate = AuditCarSubsidyDetailLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditCarSubsidyDetailLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditCarSubsidyDetailVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyDetailRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyDetailRepository.updateDelFlagByIds(ids);
    }

    public void fullAllData(MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto) {
        log.info("\u8f66\u8865\u8d39\u7528\u660e\u7ec6\u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u4efb\u52a1------>");
        Validate.notNull((Object)masterDataMdgCarSubsidyDetailDto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StrUtil.isBlank((CharSequence)masterDataMdgCarSubsidyDetailDto.getPageNum())) {
            masterDataMdgCarSubsidyDetailDto.setPageNum("1");
        }
        if (StrUtil.isBlank((CharSequence)masterDataMdgCarSubsidyDetailDto.getPageSize())) {
            masterDataMdgCarSubsidyDetailDto.setPageSize("500");
        }
        while (true) {
            List masterDataMdgCarSubsidyDetailVos = this.masterDataMdgService.pullCarSubsidyDetail(masterDataMdgCarSubsidyDetailDto);
            log.info("\u8f66\u8865\u8d39\u7528\u660e\u7ec6\u4eceMDG\u83b7\u53d6,{}", (Object)JSON.toJSONString((Object)masterDataMdgCarSubsidyDetailVos));
            if (CollectionUtils.isEmpty((Collection)masterDataMdgCarSubsidyDetailVos)) {
                return;
            }
            Collection carSubsidyDetails = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)masterDataMdgCarSubsidyDetailVos, MasterDataMdgCarSubsidyDetailVo.class, AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.fullOrg(carSubsidyDetails);
            carSubsidyDetails.forEach(x -> {
                x.setTenantCode(TenantUtils.getTenantCode());
                this.create((AuditCarSubsidyDetailVo)x);
            });
            Integer pageNum = Integer.valueOf(masterDataMdgCarSubsidyDetailDto.getPageNum());
            pageNum = pageNum + 1;
            if (pageNum > 100) {
                return;
            }
            masterDataMdgCarSubsidyDetailDto.setPageNum(pageNum.toString());
        }
    }

    private void fullOrg(Collection<AuditCarSubsidyDetailVo> auditCarSubsidyDetailVos) {
        if (CollectionUtils.isEmpty(auditCarSubsidyDetailVos)) {
            return;
        }
        Set erpCode = auditCarSubsidyDetailVos.stream().map(AuditCarSubsidyDetailVo::getZcCode).collect(Collectors.toSet());
        List customerVos = this.customerVoService.findByErpCodeList((List)Lists.newArrayList(erpCode));
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return;
        }
        Set customerVoSets = customerVos.stream().filter(Objects::nonNull).filter(x -> BusinessFormatEnum.NORMAL.getCode().equals(x.getBusinessFormatCode()) && "6000".equals(x.getSalesInstitutionErpCode()) && "20".equals(x.getCustomerChannelCode())).collect(Collectors.toSet());
        Map<String, List<CustomerVo>> saleOrgGroup = customerVoSets.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
        auditCarSubsidyDetailVos.forEach(auditCarSubsidyDetailVo -> {
            List customers = (List)saleOrgGroup.get(auditCarSubsidyDetailVo.getDealerCode());
            if (CollectionUtils.isNotEmpty((Collection)customers)) {
                CustomerVo customerVo = (CustomerVo)customers.get(0);
                auditCarSubsidyDetailVo.setSalesRegionName(customerVo.getSalesRegionName());
                auditCarSubsidyDetailVo.setSalesRegionCode(customerVo.getSalesRegionCode());
            }
        });
    }

    public List<AuditCarSubsidyDetailVo> findDetailByZcCode(String zcCode) {
        List<AuditCarSubsidyDetail> details = this.auditCarSubsidyDetailRepository.findDetailByZcCode(zcCode);
        if (CollectionUtils.isEmpty(details)) {
            return Lists.newArrayList();
        }
        Collection detailVos = this.nebulaToolkitService.copyCollectionByWhiteList(details, AuditCarSubsidyDetail.class, AuditCarSubsidyDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)detailVos);
    }

    private void createValidation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.validation(auditCarSubsidyDetailVo);
    }

    private void updateValidation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
        this.validation(auditCarSubsidyDetailVo);
    }

    private void validation(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo) {
    }
}

