/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.date.DateUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AuditCarSubsidyJob {
    private static final Logger log = LoggerFactory.getLogger(AuditCarSubsidyJob.class);
    private RedisLockService redisLockService;
    private AuditCarSubsidyVoService auditCarSubsidyVoService;
    private AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService;
    private LoginUserService loginUserService;

    @Autowired
    public void setLoginUserService(LoginUserService loginUserService) {
        this.loginUserService = loginUserService;
    }

    @Autowired
    public void setRedisLockService(RedisLockService redisLockService) {
        this.redisLockService = redisLockService;
    }

    @Autowired
    public void setAuditCarSubsidyVoService(AuditCarSubsidyVoService auditCarSubsidyVoService) {
        this.auditCarSubsidyVoService = auditCarSubsidyVoService;
    }

    @Autowired
    public void setAuditCarSubsidyDetailVoService(AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService) {
        this.auditCarSubsidyDetailVoService = auditCarSubsidyDetailVoService;
    }

    @DynamicTaskService(cornExpression="0 59 23 * * ?", taskDesc="\u6bcf\u592923:59\u5206\u626b\u63cf\u4e00\u4e0b\u8f66\u8865\u4fe1\u606f")
    public void executeCarSubsidy() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("audit:carSubsidy:lock:", TimeUnit.HOURS, 2L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto = new MasterDataMdgCarSubsidyDto();
            masterDataMdgCarSubsidyDto.setStatisticsMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
            this.auditCarSubsidyVoService.fullAllData(masterDataMdgCarSubsidyDto);
        }
        catch (Exception e) {
            log.error("\u6bcf\u592923:59\u5206\u626b\u63cf\u4e00\u4e0b\u8f66\u8865\u4fe1\u606f\u5f02\u5e38");
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("audit:carSubsidy:lock:");
            }
        }
    }

    @DynamicTaskService(cornExpression="0 59 23 * * ?", taskDesc="\u6bcf\u592923:59\u5206\u626b\u63cf\u4e00\u4e0b\u8f66\u8865\u660e\u7ec6\u4fe1\u606f")
    public void executeCarSubsidyDetail() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("audit:carSubsidyDetail::lock:", TimeUnit.HOURS, 2L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto = new MasterDataMdgCarSubsidyDetailDto();
            masterDataMdgCarSubsidyDetailDto.setStatisticsMonth(DateUtil.format((Date)new Date(), (String)"yyyy-MM"));
            this.auditCarSubsidyDetailVoService.fullAllData(masterDataMdgCarSubsidyDetailDto);
        }
        catch (Exception e) {
            log.error("\u6bcf\u592923:59\u5206\u626b\u63cf\u4e00\u4e0b\u8f66\u8865\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38");
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("audit:carSubsidyDetail::lock:");
            }
        }
    }
}

