/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.car.subsidy.local.service.internal;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.service.MasterDataMdgService;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.vo.MasterDataMdgCarSubsidyVo;
import com.biz.crm.tpm.business.car.subsidy.local.entity.AuditCarSubsidy;
import com.biz.crm.tpm.business.car.subsidy.local.repository.AuditCarSubsidyRepository;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyLogEventDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.AuditCarSubsidyEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.event.log.AuditCarSubsidyLogEventListener;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyDetailVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.service.AuditCarSubsidyVoService;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditCarSubsidyService")
public class AuditCarSubsidyVoServiceImpl
implements AuditCarSubsidyVoService {
    private static final Logger log = LoggerFactory.getLogger(AuditCarSubsidyVoServiceImpl.class);
    @Autowired(required=false)
    private AuditCarSubsidyRepository auditCarSubsidyRepository;
    @Autowired(required=false)
    private AuditCarSubsidyDetailVoService auditCarSubsidyDetailVoService;
    @Autowired(required=false)
    private List<AuditCarSubsidyEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired
    private MasterDataMdgService masterDataMdgService;
    @Autowired
    private CustomerVoService customerVoService;

    public Page<AuditCarSubsidyVo> findByConditions(Pageable pageable, AuditCarSubsidyDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditCarSubsidyDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditCarSubsidyRepository.findByConditions((Page<AuditCarSubsidyVo>)page, dto);
    }

    public AuditCarSubsidyVo findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditCarSubsidy auditCarSubsidy = this.auditCarSubsidyRepository.findById(id);
        if (auditCarSubsidy == null) {
            return null;
        }
        AuditCarSubsidyVo auditCarSubsidyVo = (AuditCarSubsidyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCarSubsidy, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class, new String[0]);
        auditCarSubsidyVo.setDetails(this.auditCarSubsidyDetailVoService.findDetailByZcCode(auditCarSubsidyVo.getZcCode()));
        return auditCarSubsidyVo;
    }

    @Transactional
    public AuditCarSubsidyVo create(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.createValidation(auditCarSubsidyVo);
        List<AuditCarSubsidy> uniqueness = this.auditCarSubsidyRepository.findUniqueness(auditCarSubsidyVo.getOrgName(), auditCarSubsidyVo.getDealerCode(), auditCarSubsidyVo.getZcCode(), auditCarSubsidyVo.getStatisticsMonth());
        if (CollectionUtils.isNotEmpty(uniqueness)) {
            return null;
        }
        auditCarSubsidyVo.setTenantCode(TenantUtils.getTenantCode());
        auditCarSubsidyVo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        auditCarSubsidyVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        auditCarSubsidyVo.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        auditCarSubsidyVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        AuditCarSubsidy auditCarSubsidy = (AuditCarSubsidy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCarSubsidyVo, AuditCarSubsidy.class, HashSet.class, ArrayList.class, new String[0]));
        this.auditCarSubsidyRepository.saveOrUpdate((Object)auditCarSubsidy);
        auditCarSubsidyVo.setId(auditCarSubsidy.getId());
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditCarSubsidyEventListener auditCarSubsidyEventListener : this.eventListeners) {
                auditCarSubsidyEventListener.onCreate(auditCarSubsidyVo);
            }
        }
        AuditCarSubsidyLogEventDto logEventDto = new AuditCarSubsidyLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditCarSubsidyVo);
        SerializableBiConsumer & Serializable onCreate = AuditCarSubsidyLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditCarSubsidyLogEventListener.class, (SerializableBiConsumer)onCreate);
        return auditCarSubsidyVo;
    }

    @Transactional
    public AuditCarSubsidyVo update(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.updateValidation(auditCarSubsidyVo);
        String currentId = auditCarSubsidyVo.getId();
        AuditCarSubsidy current = this.auditCarSubsidyRepository.findById(currentId);
        current = (AuditCarSubsidy)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        AuditCarSubsidyVo oldVo = (AuditCarSubsidyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)current, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditCarSubsidyRepository.saveOrUpdate((Object)current);
        if (!CollectionUtils.isEmpty(this.eventListeners)) {
            for (AuditCarSubsidyEventListener auditCarSubsidyEventListener : this.eventListeners) {
                auditCarSubsidyEventListener.onUpdate(oldVo, auditCarSubsidyVo);
            }
        }
        AuditCarSubsidyLogEventDto logEventDto = new AuditCarSubsidyLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditCarSubsidyVo);
        SerializableBiConsumer & Serializable onUpdate = AuditCarSubsidyLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditCarSubsidyLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return auditCarSubsidyVo;
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
    }

    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.auditCarSubsidyRepository.updateDelFlagByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void fullAllData(MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto) {
        Validate.notNull((Object)masterDataMdgCarSubsidyDto, (String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StrUtil.isBlank((CharSequence)masterDataMdgCarSubsidyDto.getPageNum())) {
            masterDataMdgCarSubsidyDto.setPageNum("1");
        }
        if (StrUtil.isBlank((CharSequence)masterDataMdgCarSubsidyDto.getPageSize())) {
            masterDataMdgCarSubsidyDto.setPageSize("500");
        }
        List masterDataMdgCarSubsidyVos;
        while (!CollectionUtils.isEmpty((Collection)(masterDataMdgCarSubsidyVos = this.masterDataMdgService.pullCarSubsidy(masterDataMdgCarSubsidyDto)))) {
            Collection auditCarSubsidies = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)masterDataMdgCarSubsidyVos, MasterDataMdgCarSubsidyVo.class, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.fullOrg(auditCarSubsidies);
            auditCarSubsidies.forEach(x -> {
                x.setTenantCode(TenantUtils.getTenantCode());
                this.create((AuditCarSubsidyVo)x);
            });
            Integer pageNum = Integer.valueOf(masterDataMdgCarSubsidyDto.getPageNum());
            pageNum = pageNum + 1;
            if (pageNum > 100) {
                return;
            }
            masterDataMdgCarSubsidyDto.setPageNum(pageNum.toString());
        }
        return;
    }

    private void fullOrg(Collection<AuditCarSubsidyVo> auditCarSubsidyVos) {
        if (CollectionUtils.isEmpty(auditCarSubsidyVos)) {
            return;
        }
        Set erpCode = auditCarSubsidyVos.stream().map(AuditCarSubsidyVo::getZcCode).collect(Collectors.toSet());
        List customerVos = this.customerVoService.findByErpCodeList((List)Lists.newArrayList(erpCode));
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return;
        }
        Set customerVoSets = customerVos.stream().filter(Objects::nonNull).filter(x -> BusinessFormatEnum.NORMAL.getCode().equals(x.getBusinessFormatCode()) && "6000".equals(x.getSalesInstitutionErpCode()) && "20".equals(x.getCustomerChannelCode())).collect(Collectors.toSet());
        Map<String, List<CustomerVo>> saleOrgGroup = customerVoSets.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode));
        auditCarSubsidyVos.forEach(auditCarSubsidyVo -> {
            List customers = (List)saleOrgGroup.get(auditCarSubsidyVo.getDealerCode());
            if (CollectionUtils.isNotEmpty((Collection)customers)) {
                CustomerVo customerVo = (CustomerVo)customers.get(0);
                auditCarSubsidyVo.setSalesRegionName(customerVo.getSalesRegionName());
                auditCarSubsidyVo.setSalesRegionCode(customerVo.getSalesRegionCode());
            }
        });
    }

    private void createValidation(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.validation(auditCarSubsidyVo);
    }

    private void updateValidation(AuditCarSubsidyVo auditCarSubsidyVo) {
        this.validation(auditCarSubsidyVo);
    }

    private void validation(AuditCarSubsidyVo auditCarSubsidyVo) {
    }

    public AuditCarSubsidyVo findValueByConditions(AuditCarSubsidyDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || StringUtils.isEmpty((CharSequence)dto.getDealerCode()) || StringUtils.isEmpty((CharSequence)dto.getSalesRegionCode()) || StringUtils.isEmpty((CharSequence)dto.getStatisticsMonth())) {
            return new AuditCarSubsidyVo();
        }
        AuditCarSubsidy detail = this.auditCarSubsidyRepository.findValueByConditions(dto);
        if (Objects.isNull((Object)detail)) {
            return null;
        }
        return (AuditCarSubsidyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)detail, AuditCarSubsidyVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

