package com.biz.crm.tpm.business.car.subsidy.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * TPM-车补明细信息dto
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:58
 */
@Data
@ApiModel(value = "AuditCarSubsidyDetailDto", description = "TPM-车补明细信息dto")
public class AuditCarSubsidyDetailDto extends TenantFlagOpDto {

    @ApiModelProperty(value = "车牌号")
    private String carNumber;


    @ApiModelProperty(value = "补贴标准（元/公里）")
    private BigDecimal zstSubsidy;


    @ApiModelProperty(value = "组织名称")
    private String orgName;


    @ApiModelProperty(value = "sap市场编码")
    private String dealerCode;

    @ApiModelProperty(value = "sap市场名称")
    private String dealerName;

    @ApiModelProperty(value = "车补客户编码")
    private String zcCode;

    @ApiModelProperty(value = "车补客户名称")
    private String zcName;


    @ApiModelProperty(value = "车辆补贴金额（元）")
    private BigDecimal zstSubsidyMoy;



    @ApiModelProperty(value = "业务月月份")
    private String statisticsMonth;


    @ApiModelProperty(value = "乡镇里程数")
    private BigDecimal townMileage;


    @ApiModelProperty(value = "补贴上限")
    private BigDecimal zupSubsidy;


    @ApiModelProperty(value = "前置金额")
    private BigDecimal zbfMoney;


    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    private String salesRegionCode;


    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    private String salesRegionName;

}

