package com.biz.crm.tpm.business.car.subsidy.sdk.event;

import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;

import java.util.List;

/**
 * TPM-车补明细信息变更事件通知接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:58
 */
public interface AuditCarSubsidyDetailEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(AuditCarSubsidyDetailVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(AuditCarSubsidyDetailVo oldVo, AuditCarSubsidyDetailVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<AuditCarSubsidyDetailVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<AuditCarSubsidyDetailVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<AuditCarSubsidyDetailVo> list);
}

