package com.biz.crm.tpm.business.car.subsidy.sdk.event;

import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;

import java.util.List;

/**
 * TPM-车补信息变更事件通知接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:07
 */
public interface AuditCarSubsidyEventListener {

    /**
     * 创建时触发
     *
     * @param vo
     */
    void onCreate(AuditCarSubsidyVo vo);

    /**
     * 编辑时触发
     *
     * @param oldVo
     * @param newVo
     */
    void onUpdate(AuditCarSubsidyVo oldVo, AuditCarSubsidyVo newVo);

    /**
     * 启用时触发
     *
     * @param list
     */
    void onEnable(List<AuditCarSubsidyVo> list);


    /**
     * 禁用时触发
     *
     * @param list
     */
    void onDisable(List<AuditCarSubsidyVo> list);

    /**
     * 删除时触发
     *
     * @param list
     */
    void onDelete(List<AuditCarSubsidyVo> list);
}

