package com.biz.crm.tpm.business.car.subsidy.sdk.event.log;

import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * TPM-车补明细信息变更事件通知接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:59
 */
public interface AuditCarSubsidyDetailLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(AuditCarSubsidyDetailLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(AuditCarSubsidyDetailLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(AuditCarSubsidyDetailLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(AuditCarSubsidyDetailLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(AuditCarSubsidyDetailLogEventDto eventDto);

}

