package com.biz.crm.tpm.business.car.subsidy.sdk.event.log;

import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

import java.util.List;

/**
 * TPM-车补信息变更事件通知接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:08
 */
public interface AuditCarSubsidyLogEventListener extends NebulaEvent {


    /**
     * 创建日志事件
     */
    void onCreate(AuditCarSubsidyLogEventDto eventDto);

    /**
     * 删除日志事件
     *
     * @param eventDto
     */
    void onDelete(AuditCarSubsidyLogEventDto eventDto);

    /**
     * 更新日志事件
     *
     * @param eventDto
     */
    void onUpdate(AuditCarSubsidyLogEventDto eventDto);

    /**
     * 启用日志事件
     *
     * @param eventDto
     */
    void onEnable(AuditCarSubsidyLogEventDto eventDto);

    /**
     * 禁用日志事件
     *
     * @param eventDto
     */
    void onDisable(AuditCarSubsidyLogEventDto eventDto);

}

