package com.biz.crm.tpm.business.car.subsidy.sdk.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDetailDto;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import org.springframework.data.domain.Pageable;

/**
 * TPM-车补明细信息(AuditCarSubsidyDetail)表服务接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:59
 */
public interface AuditCarSubsidyDetailVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditCarSubsidyDetailVo> findByConditions(Pageable pageable, AuditCarSubsidyDetailDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    AuditCarSubsidyDetailVo findDetailById(String id);

    /**
     * 创建
     *
     * @param auditCarSubsidyDetailVo
     * @return
     */
    AuditCarSubsidyDetailVo create(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo);

    /**
     * 更新
     *
     * @param auditCarSubsidyDetailVo
     * @return
     */
    AuditCarSubsidyDetailVo update(AuditCarSubsidyDetailVo auditCarSubsidyDetailVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    void fullAllData(MasterDataMdgCarSubsidyDetailDto masterDataMdgCarSubsidyDetailDto);

    List<AuditCarSubsidyDetailVo> findDetailByZcCode(String zcCode);
}
