package com.biz.crm.tpm.business.car.subsidy.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.third.system.master.data.mdg.sdk.dto.MasterDataMdgCarSubsidyDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDetailDto;
import com.biz.crm.tpm.business.car.subsidy.sdk.dto.AuditCarSubsidyDto;
import java.util.List;

import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyDetailVo;
import com.biz.crm.tpm.business.car.subsidy.sdk.vo.AuditCarSubsidyVo;
import org.springframework.data.domain.Pageable;

/**
 * TPM-车补信息(AuditCarSubsidy)表服务接口
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:08
 */
public interface AuditCarSubsidyVoService {

    /**
     * 分页条件查询
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditCarSubsidyVo> findByConditions(Pageable pageable, AuditCarSubsidyDto dto);

    /**
     * 按id查询详情
     *
     * @param id
     * @return
     */
    AuditCarSubsidyVo findDetailById(String id);

    /**
     * 创建
     *
     * @param auditCarSubsidyVo
     * @return
     */
    AuditCarSubsidyVo create(AuditCarSubsidyVo auditCarSubsidyVo);

    /**
     * 更新
     *
     * @param auditCarSubsidyVo
     * @return
     */
    AuditCarSubsidyVo update(AuditCarSubsidyVo auditCarSubsidyVo);

    /**
     * 按id集合启用
     *
     * @param ids
     */
    void enableBatch(List<String> ids);

    /**
     * 按id集合禁用
     *
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 逻辑删除
     *
     * @param ids
     */
    void updateDelFlagByIds(List<String> ids);

    void fullAllData(MasterDataMdgCarSubsidyDto masterDataMdgCarSubsidyDto);

    /**
     * 条件查询
     *
     * @param carSubsidyDto
     * @return
     */
    AuditCarSubsidyVo findValueByConditions(AuditCarSubsidyDto carSubsidyDto);
}
