package com.biz.crm.tpm.business.car.subsidy.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * TPM-车补信息vo
 *
 * @author liuyifan
 * @date 2022-12-30 17:38:08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TPM-车补信息Vo")
public class AuditCarSubsidyVo extends TenantFlagOpVo {

    @ApiModelProperty(value = "组织名称")
    private String orgName;


    @ApiModelProperty(value = "sap市场编码")
    private String dealerCode;

    @ApiModelProperty(value = "sap市场名称")
    private String dealerName;

    @ApiModelProperty(value = "车补客户编码")
    private String zcCode;

    @ApiModelProperty(value = "车补客户名称")
    private String zcName;


    @ApiModelProperty(value = "车辆补贴金额（元）")
    private BigDecimal zstSubsidyMoy;



    @ApiModelProperty(value = "业务月月份")
    private String statisticsMonth;


    @ApiModelProperty(value = "乡镇里程数")
    private BigDecimal townMileage;


    @ApiModelProperty(value = "补贴上限")
    private BigDecimal zupSubsidy;


    @ApiModelProperty(value = "前置金额")
    private BigDecimal zbfMoney;


    @ApiModelProperty(value = "已结案补贴")
    private BigDecimal zCloseSubsidy;

    @ApiModelProperty(value = "累计车补系统补贴金额")
    private BigDecimal zSumMoney;

    @ApiModelProperty(value = "月度结案金额")
    private BigDecimal monthlyAmount;


    /**
     * 业态
     */
    @ApiModelProperty("业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    private String salesRegionCode;


    /**
     * 区域编码
     */
    @ApiModelProperty("大区")
    private String salesRegionName;

    @ApiModelProperty(value = "车补明细")
    private List<AuditCarSubsidyDetailVo> details;

}

