package com.biz.crm.tpm.business.channel.price.monitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.ChannelPriceService;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.constant.ChannelPriceConstant;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.ChannelPriceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * 渠道价格
 *
 * @author zhouyang
 * @date 2023-07-26 18:15:45
 */
@Slf4j
@RestController
@RequestMapping("/v1/channelPrice")
@Api(tags = "渠道价格")
public class ChannelPriceController {

    @Autowired(required = false)
    private ChannelPriceService channelPriceService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ChannelPriceDto>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "渠道价格") ChannelPriceDto dto) {
        try {
            return Result.ok(this.channelPriceService.findByConditions(pageable, dto));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "物理删除", httpMethod = "DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            channelPriceService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }

    @ApiOperation(value = "获取价格数据")
    @GetMapping("getSalesSpliceData")
    public Result<?> getSalesSpliceData(@RequestParam("yearAndMonth") String yearAndMonth) {
        try {
            Assert.hasLength(yearAndMonth, "年月不能为空!");
            try {
                Date date = DateUtil.date_yyyy_MM.parse(yearAndMonth);
                Assert.isTrue(yearAndMonth.equals(DateUtil.date_yyyy_MM.format(date)), "年月格式错误【yyyy-MM】");
            } catch (Exception e) {
                throw new IllegalArgumentException("年月格式错误【yyyy-MM】");
            }
            boolean isLock = redisLockService.isLock(ChannelPriceConstant.CHANNEL_PRICE_LOCK);
            Assert.isTrue(!isLock, "其他人正在操作数据,加锁失败,请稍后重试!");
            channelPriceService.getSalesSpliceDataAsync(yearAndMonth, loginUserService.getAbstractLoginUser());
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }

    }

}
