package com.biz.crm.tpm.business.channel.price.monitor.local.controller;


import com.biz.crm.tpm.business.channel.price.monitor.local.entity.TpmChannelPriceMonitor;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.TpmChannelPriceMonitorService;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.TpmChannelPriceMonitorDto;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
 * TPM-渠道价格监控(TpmChannelPriceMonitor)表相关的http接口
 *
 * @author duyiran
 * @since 2022-11-16 11:22:58
 */
@RestController
@RequestMapping("/v1/tpmChannelPriceMonitor")
@Slf4j
@Api(tags = "TPM-渠道价格监控")
public class TpmChannelPriceMonitorController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private TpmChannelPriceMonitorService tpmChannelPriceMonitorService;

    /**
     * 分页查询所有数据
     *
     * @param pageable               分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<TpmChannelPriceMonitorVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "dto", value = "TPM-渠道价格监控") TpmChannelPriceMonitorDto dto) {
        try {
            Page<TpmChannelPriceMonitorVo> page = this.tpmChannelPriceMonitorService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
