package com.biz.crm.tpm.business.channel.price.monitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 渠道价格
 *
 * @author zhouyang
 * @date 2023-07-26 18:15:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("tpm_channel_price")
@Table(name = "tpm_channel_price", indexes = {
        @Index(name = "tpm_channel_price_index1", columnList = "price_year_month"),
        @Index(name = "tpm_channel_price_index2", columnList = "channel_code"),
        @Index(name = "tpm_channel_price_index3", columnList = "trade_date"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_channel_price", comment = "渠道价格")
@ApiModel(value = "ChannelPriceEntity", description = "渠道价格")
public class ChannelPriceEntity extends TenantFlagOpEntity {

    @ApiModelProperty("年月")
    @Column(name = "price_year_month", length = 10, columnDefinition = "varchar(10) COMMENT '年月'")
    private String priceYearMonth;

    @ApiModelProperty("货品编号")
    @Column(name = "goods_code", length = 64, columnDefinition = "varchar(64) COMMENT '货品编号'")
    private String goodsCode;

    @ApiModelProperty("货品名称")
    @Column(name = "goods_name", length = 128, columnDefinition = "varchar(128) COMMENT '货品名称'")
    private String goodsName;

    @ApiModelProperty("业务模式")
    @Column(name = "business_model_code", length = 32, columnDefinition = "varchar(32) COMMENT '业务模式'")
    private String businessModelCode;

    @ApiModelProperty("业务模式名称")
    @Column(name = "business_model_name", length = 64, columnDefinition = "varchar(64) COMMENT '业务模式名称'")
    private String businessModelName;

    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 64, columnDefinition = "varchar(64) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("业态编码")
    @Column(name = "business_format_code", length = 32, columnDefinition = "varchar(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty("业态名称")
    @Column(name = "business_format_name", length = 128, columnDefinition = "varchar(128) COMMENT '业态名称'")
    private String businessFormatName;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("渠道")
    @Column(name = "channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '渠道'")
    private String channelName;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "varchar(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 128, columnDefinition = "varchar(128) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "varchar(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("平台编码")
    @Column(name = "platform_code", length = 32, columnDefinition = "varchar(32) COMMENT '平台编码'")
    private String platformCode;

    @ApiModelProperty("平台名称")
    @Column(name = "platform_name", length = 128, columnDefinition = "varchar(128) COMMENT '平台名称'")
    private String platformName;

    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 128, columnDefinition = "varchar(128) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("电商渠道编码")
    @Column(name = "estore_channel", length = 32, columnDefinition = "varchar(32) COMMENT '电商渠道编码'")
    private String estoreChannel;

    @ApiModelProperty("电商渠道名称")
    @Column(name = "estore_channel_name", length = 128, columnDefinition = "varchar(128) COMMENT '电商渠道名称'")
    private String estoreChannelName;

    @ApiModelProperty("标准零售价（元）")
    @Column(name = "suggested_retail_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '标准零售价（元）'")
    private BigDecimal suggestedRetailPrice;

    @ApiModelProperty("红线价（元）")
    @Column(name = "red_line_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '红线价（元）'")
    private BigDecimal redLinePrice;

    @ApiModelProperty("促销选品价（元）")
    @Column(name = "promotion_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '促销选品价（元）'")
    private BigDecimal promotionPrice;

    @ApiModelProperty("预估最低价（元）")
    @Column(name = "estimate_lower_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '预估最低价（元）'")
    private BigDecimal estimateLowerPrice;

    @ApiModelProperty("活动底价（元）")
    @Column(name = "activity_lower_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '活动底价（元）'")
    private BigDecimal activityLowerPrice;

    @ApiModelProperty("实际销售价（元）")
    @Column(name = "sale_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '实际销售价（元）'")
    private BigDecimal salePrice;

    @ApiModelProperty("实际销售价VS红线价")
    @Column(name = "sale_vs_red_line_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '实际销售价VS红线价'")
    private BigDecimal saleVsRedLinePrice;

    @ApiModelProperty("实际销售价VS促销选品价")
    @Column(name = "sale_vs_promotion_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '实际销售价VS促销选品价'")
    private BigDecimal saleVsPromotionPrice;

    @ApiModelProperty("实际销售价VS预估最低价")
    @Column(name = "sale_vs_estimate_lower_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '实际销售价VS预估最低价'")
    private BigDecimal saleVsEstimateLowerPrice;

    @ApiModelProperty("实际销售价VS活动底价")
    @Column(name = "sale_vs_activity_lower_price", length = 20, columnDefinition = "DECIMAL(20,2) COMMENT '实际销售价VS活动底价'")
    private BigDecimal saleVsActivityLowerPrice;

    @ApiModelProperty("交易日期")
    @Column(name = "trade_date", columnDefinition = "datetime COMMENT '实际销售价VS活动底价'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date tradeDate;
}