package com.biz.crm.tpm.business.channel.price.monitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 渠道价格监控 实体
 *
 * @author duyiran
 * @create 2022-11-07 17:42
 */
@Data
@TableName("tpm_channel_price_monitor")
@Entity(name = "tpm_channel_price_monitor")
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "TpmChannelPriceMonitor", description = "TPM-渠道价格监控")
@org.hibernate.annotations.Table(appliesTo = "tpm_channel_price_monitor", comment = "TPM-渠道价格监控")
@Table(name = "tpm_channel_price_monitor", indexes = {@Index(name = "tpm_channel_price_monitor_index1", columnList = "customer_code, product_code", unique = true)})
public class TpmChannelPriceMonitor extends TenantFlagOpEntity {

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "客户名称", notes = "客户编码")
    @Column(name = "customer_name", columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    /**
     * 日期
     */
    @ApiModelProperty(name = "日期", notes = "日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "promotion_date", nullable = true, length = 10, columnDefinition = "datetime COMMENT '日期'")
    private Date promotionDate;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品编码")
    @Column(name = "product_name", columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 渠道编码
     */
    @ApiModelProperty(name = "渠道编码", notes = "")
    @Column(name = "channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码 '")
    private String channelCode;

    /**
     * 渠道名称
     */
    @ApiModelProperty(name = "渠道名称", notes = "")
    @Column(name = "channel_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '渠道名称 '")
    private String channelName;

    /**
     * 活动形式编码
     */
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    /**
     * 活动形式名称
     */
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    /**
     * 建议零售价
     */
    @ApiModelProperty(name = "建议零售价", notes = "建议零售价")
    @Column(name = "suggested_retail_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '建议零售价'")
    private BigDecimal suggestedRetailPrice;

    /**
     * 促销选品价
     */
    @ApiModelProperty(name = "促销选品价", notes = "促销选品价")
    @Column(name = "selection_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '促销选品价'")
    private BigDecimal selectionPrice;

    /**
     * 基础面价
     */
    @ApiModelProperty(name = "基础面价", notes = "基础面价")
    @Column(name = "base_market_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '基础面价'")
    private BigDecimal baseMarketPrice;

    /**
     * 闪秒面价
     */
    @ApiModelProperty(name = "闪秒面价", notes = "闪秒面价")
    @Column(name = "flash_market_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '闪秒面价'")
    private BigDecimal flashMarketPrice;

    /**
     * 会员专享价
     */
    @ApiModelProperty(name = "会员专享价", notes = "会员专享价")
    @Column(name = "exclusive_price_for_members", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '会员专享价'")
    private BigDecimal exclusivePriceForMembers;

    /**
     * 最终面价
     */
    @ApiModelProperty(name = "最终面价", notes = "最终面价")
    @Column(name = "final_market_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '最终面价'")
    private BigDecimal finalMarketPrice;

    /**
     * 折扣
     */
    @ApiModelProperty(name = "折扣", notes = "折扣")
    @Column(name = "discount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折扣'")
    private BigDecimal discount;

    /**
     * 区域折扣
     */
    @ApiModelProperty(name = "区域折扣", notes = "区域折扣")
    @Column(name = "area_discount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '区域折扣'")
    private BigDecimal areaDiscount;

    /**
     * 优惠券
     */
    @ApiModelProperty(name = "优惠券", notes = "优惠券")
    @Column(name = "discount_coupon", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '优惠券'")
    private BigDecimal discountCoupon;

    /**
     * 全国会员预估到手价
     */
    @ApiModelProperty(name = "全国会员预估到手价", notes = "全国会员预估到手价")
    @Column(name = "estimate_price_for_nationwide_members", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '全国会员预估到手价'")
    private BigDecimal estimatePriceForNationwideMembers;

    /**
     * 非会员预估到手价
     */
    @ApiModelProperty(name = "非会员预估到手价", notes = "非会员预估到手价")
    @Column(name = "estimate_price_for_Nonmembers", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '非会员预估到手价'")
    private BigDecimal estimatePriceForNonmembers;

    /**
     * 区域非会员预估到手价
     */
    @ApiModelProperty(name = "区域非会员预估到手价", notes = "区域非会员预估到手价")
    @Column(name = "estimate_price_for_area_Nonmembers", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '区域非会员预估到手价'")
    private BigDecimal estimatePriceForAreaNonmembers;

    /**
     * 折扣力度
     */
    @ApiModelProperty(name = "折扣力度", notes = "折扣力度")
    @Column(name = "discount_intensity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '折扣力度'")
    private BigDecimal discountIntensity;

    /**
     * 预估最低价
     */
    @ApiModelProperty(name = "预估最低价", notes = "预估最低价")
    @Column(name = "estimate_floor_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预估最低价'")
    private BigDecimal estimateFloorPrice;

    /**
     * 库存最早月份
     */
    @ApiModelProperty(name = "库存最早月份", notes = "库存最早月份")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "earliest_month_in_repertory", nullable = true, length = 10, columnDefinition = "datetime COMMENT '库存最早月份'")
    private Date earliestMonthInRepertory;

    //下面是非导入字段

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 平台
     */
    @ApiModelProperty(name = "平台", notes = "平台")
    @Column(name = "platform", length = 256, columnDefinition = "VARCHAR(256) COMMENT '平台'")
    private String platform;

    /**
     * 促销类型编码
     */
    @ApiModelProperty("促销类型编码")
    @Column(name = "promotion_type_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '促销类型编码'")
    private String promotionTypeCode;

    /**
     * 平台供货价
     */
    @ApiModelProperty(name = "平台供货价", notes = "平台供货价")
    @Column(name = "platform_supply_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '平台供货价'")
    private BigDecimal platformSupplyPrice;

    /**
     * 活动底价
     */
    @ApiModelProperty(name = "活动底价", notes = "活动底价")
    @Column(name = "activity_floor_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '活动底价'")
    private BigDecimal activityFloorPrice;

    /**
     * 实际销售价
     */
    @ApiModelProperty(name = "实际销售价", notes = "实际销售价")
    @Column(name = "actual_selling_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际销售价'")
    private BigDecimal actualSellingPrice;

    /**
     * 规划价格力度
     */
    @ApiModelProperty(name = "规划价格力度", notes = "规划价格力度")
    @Column(name = "planned_intensity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '规划价格力度'")
    private BigDecimal plannedIntensity;

    /**
     * 规划价格力度
     */
    @ApiModelProperty(name = "规划价格力度", notes = "规划价格力度")
    @Column(name = "actual_intensity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '规划价格力度'")
    private BigDecimal actualIntensity;

    /**
     * 价格偏差
     */
    @ApiModelProperty(name = "价格偏差", notes = "价格偏差")
    @Column(name = "price_variance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '价格偏差'")
    private BigDecimal priceVariance;

}
