package com.biz.crm.tpm.business.channel.price.monitor.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 数据视图注册器
 * 基于nebula的数据视图提供列表查询功能
 *
 * @author zy
 * @create 2023-07-27
 */
@Component
@Slf4j
public class TpmChannelPriceRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_channel_price_data_view";
    }

    @Override
    public String desc() {
        return "TPM-渠道价格监控";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_channel_price t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
