package com.biz.crm.tpm.business.channel.price.monitor.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.channel.price.monitor.local.entity.ChannelPriceEntity;
import com.biz.crm.tpm.business.channel.price.monitor.local.mapper.ChannelPriceMapper;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.ChannelPriceDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/**
 * 渠道价格接口实现
 *
 * @author zhouyang
 * @date 2023-07-26 18:15:45
 */
@Slf4j
@Service
public class ChannelPriceRepository extends ServiceImpl<ChannelPriceMapper, ChannelPriceEntity> {

    /**
     * 分页
     *
     * @param pageable 分页参数
     * @param dto      dto
     * @return page
     */
    public Page<ChannelPriceDto> findByConditions(Pageable pageable, ChannelPriceDto dto) {
        return this.baseMapper.findByConditions(new Page<>(pageable.getPageNumber(), pageable.getPageSize()), dto);
    }

    /**
     * 根据年月删除
     *
     * @param yearAndMonth
     */
    public void removeByYearMonth(String yearAndMonth) {
        if (StringUtils.isEmpty(yearAndMonth)) {
            return;
        }
        this.lambdaUpdate()
                .eq(ChannelPriceEntity::getPriceYearMonth, yearAndMonth)
                .remove();

    }
}
