package com.biz.crm.tpm.business.channel.price.monitor.local.repository;


import com.biz.crm.tpm.business.channel.price.monitor.local.entity.TpmChannelPriceMonitor;
import com.biz.crm.tpm.business.channel.price.monitor.local.mapper.TpmChannelPriceMonitorMapper;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.TpmChannelPriceMonitorDto;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorVo;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * TPM-渠道价格监控(TpmChannelPriceMonitor)表数据库访问层
 *
 * @author duyiran
 * @since 2022-11-16 11:23:01
 */
@Component
public class TpmChannelPriceMonitorRepository extends ServiceImpl<TpmChannelPriceMonitorMapper, TpmChannelPriceMonitor> {

    @Autowired(required = false)
    private TpmChannelPriceMonitorMapper tpmChannelPriceMonitorMapper;

    /**
     * 分页查询数据
     *
     * @param pageable               分页对象
     * @param dto 实体对象
     * @return
     */
    public Page<TpmChannelPriceMonitorVo> findByConditions(Pageable pageable, TpmChannelPriceMonitorDto dto) {
        Page<TpmChannelPriceMonitorVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<TpmChannelPriceMonitorVo> pageList = this.tpmChannelPriceMonitorMapper.findByConditions(page, dto);
        return pageList;
    }
}

