package com.biz.crm.tpm.business.channel.price.monitor.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.ChannelPriceDto;
import org.springframework.data.domain.Pageable;
import java.util.List;

/**
 * 渠道价格接口
 *
 * @author zhouyang
 * @date 2023-07-26 18:15:45
 */
public interface ChannelPriceService{

    /**
     * 分页查询
     * @param pageable 分页参数
     * @param dto 入参
     * @return page 结果
    */
    Page<ChannelPriceDto> findByConditions(Pageable pageable, ChannelPriceDto dto);

    /**
     * 物理删除
     * @param ids ids
     */
    void delete(List<String> ids);

    /**
     * 获取价格数据
     * @param yearAndMonth
     */
    void getSalesSpliceDataAsync(String yearAndMonth, AbstractCrmUserIdentity abstractLoginUser);

    /**
     * 获取价格数据
     * @param yearAndMonth
     */
    void getSalesSpliceData(String yearAndMonth);
}

