package com.biz.crm.tpm.business.channel.price.monitor.local.service;


import com.biz.crm.tpm.business.channel.price.monitor.local.entity.TpmChannelPriceMonitor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.TpmChannelPriceMonitorDto;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * TPM-渠道价格监控(TpmChannelPriceMonitor)表服务接口
 *
 * @author duyiran
 * @since 2022-11-16 11:22:59
 */
public interface TpmChannelPriceMonitorService {

    /**
     * 分页查询数据
     *
     * @param pageable               分页对象
     * @param dto 实体对象
     * @return
     */
    Page<TpmChannelPriceMonitorVo> findByConditions(Pageable pageable, TpmChannelPriceMonitorDto dto);

    /**
     * 导入批量保存
     * @param importList
     */
    void saveBatch(List<TpmChannelPriceMonitorDto> importList);

}

