package com.biz.crm.tpm.business.channel.price.monitor.local.service.imports;

import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.channel.price.monitor.local.entity.TpmChannelPriceMonitor;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.TpmChannelPriceMonitorService;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.TpmChannelPriceMonitorDto;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

/**
 * @author duyiran
 * @create 2022-10-29 17:25
 */
@Slf4j
@Component
public class TpmChannelPriceMonitorImportsProcess implements ImportProcess<TpmChannelPriceMonitorImportsVo> {

    @Autowired(required = false)
    TpmChannelPriceMonitorService tpmChannelPriceMonitorService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 数据处理
     *
     * @param data     待处理的数据集合，k-流水号，v-excel解析后的对象
     * @param paramsVo 任务公共参数
     * @param params   导入任务自定义参数
     * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
     */
    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, TpmChannelPriceMonitorImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {

        Validate.notEmpty(data, "导入数据不能为空！");

        List<TpmChannelPriceMonitorDto> importList = this.validate(data);

        //保存
        tpmChannelPriceMonitorService.saveBatch(importList);

        return null;
    }

    /**
     * 校验数据
     *
     * @param data data
     * @author duyiran
     * @date 2022-10-29 15:04
     **/
    private List<TpmChannelPriceMonitorDto> validate(LinkedHashMap<Integer, TpmChannelPriceMonitorImportsVo> data) {
        List<TpmChannelPriceMonitorImportsVo> importsVos = new ArrayList<>(data.values());

        // TODO:校验
        importsVos.forEach(importsVo -> {

        });
        Collection<TpmChannelPriceMonitorDto> dtoList = nebulaToolkitService.copyCollectionByWhiteList(importsVos, TpmChannelPriceMonitorImportsVo.class, TpmChannelPriceMonitorDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(dtoList);
    }

    /**
     * 获取数据实体
     *
     * @return
     */
    @Override
    public Class<TpmChannelPriceMonitorImportsVo> findCrmExcelVoClass() {
        return TpmChannelPriceMonitorImportsVo.class;
    }

    /**
     * 获取数据实体
     *
     * @return
     */
    @Override
    public String getTemplateCode() {
        return "TPM_CHANNEL_PRICE_MONITOR";
    }

    /**
     * 获取业务对应的模板描述
     *
     * @return
     */
    @Override
    public String getTemplateName() {
        return "TPM-渠道价格监控";
    }

}
