package com.biz.crm.tpm.business.channel.price.monitor.local.service.internal;


import com.biz.crm.tpm.business.channel.price.monitor.local.repository.TpmChannelPriceMonitorRepository;
import com.biz.crm.tpm.business.channel.price.monitor.local.entity.TpmChannelPriceMonitor;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.TpmChannelPriceMonitorService;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.TpmChannelPriceMonitorDto;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorImportsVo;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.vo.TpmChannelPriceMonitorVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * TPM-渠道价格监控(TpmChannelPriceMonitor)表服务实现类
 *
 * @author duyiran
 * @since 2022-11-16 11:22:59
 */
@Service("tpmChannelPriceMonitorService")
public class TpmChannelPriceMonitorServiceImpl implements TpmChannelPriceMonitorService {

    @Autowired(required = false)
    private TpmChannelPriceMonitorRepository tpmChannelPriceMonitorRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 分页查询数据
     *
     * @param pageable               分页对象
     * @param dto 实体对象
     * @return
     */
    @Override
    public Page<TpmChannelPriceMonitorVo> findByConditions(Pageable pageable, TpmChannelPriceMonitorDto dto) {
        ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmChannelPriceMonitorDto();
        }
        return this.tpmChannelPriceMonitorRepository.findByConditions(pageable, dto);
    }

    /**
     * 导入批量保存
     *
     * @param importList
     */
    @Override
    public void saveBatch(List<TpmChannelPriceMonitorDto> importList) {
        Collection<TpmChannelPriceMonitor> tpmChannelPriceMonitors = nebulaToolkitService.copyCollectionByWhiteList(importList, TpmChannelPriceMonitorDto.class, TpmChannelPriceMonitor.class, LinkedHashSet.class, ArrayList.class);
        tpmChannelPriceMonitorRepository.saveBatch(tpmChannelPriceMonitors);
    }

}

