/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.channel.price.monitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.ChannelPriceService;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.ChannelPriceDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/channelPrice"})
@Api(tags={"\u6e20\u9053\u4ef7\u683c"})
public class ChannelPriceController {
    private static final Logger log = LoggerFactory.getLogger(ChannelPriceController.class);
    @Autowired(required=false)
    private ChannelPriceService channelPriceService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ChannelPriceDto>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u6e20\u9053\u4ef7\u683c") ChannelPriceDto dto) {
        try {
            return Result.ok(this.channelPriceService.findByConditions(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664", httpMethod="DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.channelPriceService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4ef7\u683c\u6570\u636e")
    @GetMapping(value={"getSalesSpliceData"})
    public Result<?> getSalesSpliceData(@RequestParam(value="yearAndMonth") String yearAndMonth) {
        try {
            Assert.hasLength((String)yearAndMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a!");
            try {
                Date date = DateUtil.date_yyyy_MM.parse(yearAndMonth);
                Assert.isTrue((boolean)yearAndMonth.equals(DateUtil.date_yyyy_MM.format(date)), (String)"\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\u3010yyyy-MM\u3011");
            }
            boolean isLock = this.redisLockService.isLock("tpm:channel_price:lock");
            Assert.isTrue((!isLock ? 1 : 0) != 0, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.channelPriceService.getSalesSpliceDataAsync(yearAndMonth, this.loginUserService.getAbstractLoginUser());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

