/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.channel.price.monitor.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceFeeVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.channel.price.monitor.local.entity.ChannelPriceEntity;
import com.biz.crm.tpm.business.channel.price.monitor.local.repository.ChannelPriceRepository;
import com.biz.crm.tpm.business.channel.price.monitor.local.service.ChannelPriceService;
import com.biz.crm.tpm.business.channel.price.monitor.sdk.dto.ChannelPriceDto;
import com.biz.crm.tpm.business.day.sales.sdk.dto.TpmDaySalesSpliceDto;
import com.biz.crm.tpm.business.day.sales.sdk.service.TpmDaySalesSpliceService;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesSpliceVo;
import com.biz.crm.tpm.business.day.sales.sdk.vo.TpmDaySalesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.CurrentMonthSaleDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ChannelPriceServiceImpl
implements ChannelPriceService {
    private static final Logger log = LoggerFactory.getLogger(ChannelPriceServiceImpl.class);
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private ChannelPriceRepository channelPriceRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private TpmDaySalesSpliceService tpmDaySalesSpliceService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceVoService priceVoService;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;

    @Override
    public Page<ChannelPriceDto> findByConditions(Pageable pageable, ChannelPriceDto dto) {
        return this.channelPriceRepository.findByConditions((Pageable)(pageable != null ? pageable : PageRequest.of((int)0, (int)50)), dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.channelPriceRepository.removeByIds(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void getSalesSpliceDataAsync(String yearAndMonth, AbstractCrmUserIdentity abstractLoginUser) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("tpm:channel_price:lock", TimeUnit.HOURS, 2L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.loginUserService.refreshAuthentication((Object)abstractLoginUser);
            this.getSalesSpliceData(yearAndMonth);
        }
        catch (Exception e) {
            log.error("=====>   \u6e20\u9053\u4ef7\u683c\u6570\u636e \u5f02\u5e38   <=====");
            log.error("", (Throwable)e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("tpm:channel_price:lock");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void getSalesSpliceData(String yearMonthLy) {
        Validate.notBlank((CharSequence)yearMonthLy, (String)"\u8bf7\u586b\u5165\u5e74\u6708", (Object[])new Object[0]);
        boolean isLock = this.redisLockService.isLock("tpm:channel_price:lock");
        Assert.isTrue((boolean)isLock, (String)"\u672a\u52a0\u9501,\u672c\u6b21\u4e0d\u6267\u884c!");
        this.removeByYearMonth(yearMonthLy);
        PageRequest pageable = PageRequest.of((int)1, (int)800);
        Page daySalesPage = null;
        TpmDaySalesSpliceDto dto = new TpmDaySalesSpliceDto();
        dto.setYearMonthLy(yearMonthLy);
        do {
            daySalesPage = this.tpmDaySalesSpliceService.findByYearAndMonth((Pageable)pageable, dto);
            log.info("=====>    \u67e5\u8be2\u6e20\u9053\u4ef7\u683c\u6570\u636e \u5e74\u6708[{}]  \u9875[{}/{}][{}]\u6761    <=====", new Object[]{yearMonthLy, daySalesPage.getCurrent(), daySalesPage.getPages(), daySalesPage.getSize()});
            if (CollectionUtil.isEmpty((Collection)daySalesPage.getRecords())) {
                return;
            }
            List<ChannelPriceEntity> channelPriceList = this.buildData(daySalesPage.getRecords(), yearMonthLy);
            this.saveDataList(channelPriceList);
        } while (daySalesPage.hasNext());
    }

    private List<ChannelPriceEntity> buildData(List<TpmDaySalesSpliceVo> records, String yearMonthLy) {
        if (CollectionUtil.isEmpty(records)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList<ChannelPriceEntity> channelPriceList = new ArrayList<ChannelPriceEntity>();
        records.forEach(item -> {
            List daySalesSpliceVos = this.tpmDaySalesSpliceService.getByCustomerAndProduct(yearMonthLy, item.getCustomer(), item.getGoodsCode());
            if (CollectionUtil.isEmpty((Collection)daySalesSpliceVos)) {
                return;
            }
            List resultList = daySalesSpliceVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TpmDaySalesSpliceVo>(Comparator.comparing(TpmDaySalesVo::getBusinessFormatCode).thenComparing(TpmDaySalesVo::getChannelCode).thenComparing(TpmDaySalesVo::getSalesInstitutionCode).thenComparing(TpmDaySalesVo::getCustomer).thenComparing(TpmDaySalesVo::getGoodsCode).thenComparing(TpmDaySalesVo::getTradeDate).thenComparing(TpmDaySalesSpliceVo::getChannel).thenComparing(TpmDaySalesSpliceVo::getActivityForm))), ArrayList::new));
            List customerCodes = resultList.stream().map(a -> a.getCustomer() + a.getSalesInstitutionCode() + a.getChannelCode() + a.getBusinessFormatCode()).distinct().collect(Collectors.toList());
            List customerVoList = this.customerVoService.findByCustomerCodes(customerCodes);
            HashMap customerVoMap = CollectionUtils.isEmpty((Collection)customerVoList) ? Maps.newHashMap() : customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n));
            List productCode = resultList.stream().map(TpmDaySalesVo::getGoodsCode).collect(Collectors.toList());
            List productVoList = this.productVoService.findByCodes(productCode);
            HashMap productVoMap = CollectionUtils.isEmpty((Collection)productVoList) ? Maps.newHashMap() : productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, v -> v, (n, o) -> n));
            resultList.forEach(e -> {
                ChannelPriceEntity entity = new ChannelPriceEntity();
                entity.setBusinessFormatCode(e.getBusinessFormatCode());
                entity.setBusinessFormatName(e.getBusinessFormatName());
                entity.setChannelCode(e.getChannelCode());
                entity.setChannelName(e.getChannelName());
                entity.setSalesInstitutionCode(e.getSalesInstitutionCode());
                entity.setSalesInstitutionName(e.getSalesInstitutionName());
                entity.setCustomerCode(e.getCustomer());
                entity.setCustomerName(e.getCustomerName());
                entity.setGoodsCode(e.getGoodsCode());
                entity.setGoodsName(e.getGoodsName());
                entity.setTradeDate(e.getTradeDate());
                entity.setEstoreChannel(e.getChannel());
                entity.setActivityFormCode(e.getActivityForm());
                entity.setActivityFormName(e.getActivityFormName());
                if (null != e.getAmount() && e.getNum().compareTo(BigDecimal.ZERO) != 0) {
                    entity.setSalePrice(Optional.ofNullable(e.getAmount()).orElse(BigDecimal.ZERO).divide(e.getNum(), 2, 1));
                }
                StringBuilder customerCode = new StringBuilder();
                customerCode.append(e.getCustomer());
                customerCode.append(e.getSalesInstitutionCode());
                customerCode.append(e.getChannelCode());
                customerCode.append(e.getBusinessFormatCode());
                if (customerVoMap.containsKey(customerCode.toString())) {
                    entity.setBusinessModelCode(((CustomerVo)customerVoMap.get(customerCode.toString())).getBusinessModelCode());
                    entity.setPlatformCode(((CustomerVo)customerVoMap.get(customerCode.toString())).getEstorePlatform());
                }
                if (productVoMap.containsKey(e.getGoodsCode())) {
                    entity.setProductBrandCode(((ProductVo)productVoMap.get(e.getGoodsCode())).getProductBrandCode());
                    entity.setProductBrandName(((ProductVo)productVoMap.get(e.getGoodsCode())).getProductBrandName());
                }
                try {
                    PriceFeeVo priceFeeVo = this.priceVoService.findByGoodsCode(entity.getGoodsCode(), entity.getCustomerCode(), entity.getBusinessModelCode(), yearMonthLy + "-01");
                    if (null != priceFeeVo) {
                        entity.setSuggestedRetailPrice(priceFeeVo.getStandardRetailPrice());
                        entity.setRedLinePrice(priceFeeVo.getRedLinePrice());
                        entity.setPromotionPrice(priceFeeVo.getPromotionalSelectionPrice());
                    }
                }
                catch (Exception error) {
                    log.error("\u65e5\u4ef7\u683c\u76d1\u63a7\u4ef7\u683c\u67e5\u8be2\u5931\u8d25\uff1a" + error.getMessage(), e);
                }
                CurrentMonthSaleDto currentMonthSaleDto = new CurrentMonthSaleDto();
                currentMonthSaleDto.setErpCode(entity.getCustomerCode());
                currentMonthSaleDto.setProductCode(entity.getGoodsCode());
                currentMonthSaleDto.setMonitorMonthStr(yearMonthLy);
                BigDecimal activityBasePrice = this.promotionPlanService.getMinActivityBasePrice(currentMonthSaleDto);
                entity.setActivityLowerPrice(activityBasePrice);
                if (null != entity.getSalePrice()) {
                    entity.setSaleVsRedLinePrice(entity.getSalePrice().subtract(Optional.ofNullable(entity.getRedLinePrice()).orElse(BigDecimal.ZERO)));
                    entity.setSaleVsPromotionPrice(entity.getSalePrice().subtract(Optional.ofNullable(entity.getPromotionPrice()).orElse(BigDecimal.ZERO)));
                    entity.setSaleVsEstimateLowerPrice(entity.getSalePrice().subtract(Optional.ofNullable(entity.getEstimateLowerPrice()).orElse(BigDecimal.ZERO)));
                    entity.setSaleVsActivityLowerPrice(entity.getSalePrice().subtract(Optional.ofNullable(entity.getActivityLowerPrice()).orElse(BigDecimal.ZERO)));
                }
                entity.setTenantCode(tenantCode);
                entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                entity.setPriceYearMonth(yearMonthLy);
                channelPriceList.add(entity);
            });
        });
        return channelPriceList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void saveDataList(List<ChannelPriceEntity> channelPriceList) {
        if (CollectionUtil.isEmpty(channelPriceList)) {
            return;
        }
        this.channelPriceRepository.saveOrUpdateBatch(channelPriceList);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void removeByYearMonth(String yearAndMonth) {
        if (StringUtil.isEmpty((CharSequence)yearAndMonth)) {
            return;
        }
        this.channelPriceRepository.removeByYearMonth(yearAndMonth);
    }
}

